/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.tx;

import edu.uiuc.ncsa.security.core.DateComparable;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.IdentifiableImpl;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.qdl_lang.xml.XMLUtils;
import org.qdl_lang.xml.XMLUtilsV2;

public class TXRecord
extends IdentifiableImpl
implements Identifiable,
Cloneable,
DateComparable {
    Date createdAt = null;
    String storedToken = null;
    TXRecord previousTXR = null;
    JSONObject token = null;
    String tokenType;
    List<String> audience;
    long expiresAt = System.currentTimeMillis();
    long lifetime = 0L;
    long issuedAt = System.currentTimeMillis();
    String issuer;
    Identifier parentID;
    List<String> scopes;
    List<URI> resource;
    boolean valid = false;
    OA2Client ersatzClient;

    public Date getCreationTS() {
        if (this.createdAt == null) {
            this.createdAt = new Date(this.getIssuedAt());
        }
        return this.createdAt;
    }

    public TXRecord(Identifier identifier) {
        super(identifier);
    }

    public String getStoredToken() {
        return this.storedToken;
    }

    public void setStoredToken(String storedToken) {
        this.storedToken = storedToken;
    }

    public TXRecord getPreviousTXR() {
        return this.previousTXR;
    }

    public void setPreviousTXR(TXRecord previousTXR) {
        this.previousTXR = previousTXR;
    }

    public JSONObject getToken() {
        return this.token;
    }

    public void setToken(JSONObject token) {
        this.token = token;
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public boolean hasPreviousTX() {
        return this.previousTXR != null;
    }

    public Identifier getParentID() {
        return this.parentID;
    }

    public void setParentID(Identifier parentID) {
        this.parentID = parentID;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    public long getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(long issuedAt) {
        this.issuedAt = issuedAt;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(long expiresAt) {
        this.expiresAt = expiresAt;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setScopes(Collection<String> newScopes) {
        this.scopes = new ArrayList<String>();
        this.scopes.addAll(newScopes);
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public boolean hasAudience() {
        return this.audience != null && !this.audience.isEmpty();
    }

    public List<String> getAudience() {
        return this.audience;
    }

    public void setAudience(List<String> audience) {
        this.audience = audience;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public List<URI> getResource() {
        return this.resource;
    }

    public void setResource(List<URI> resource) {
        this.resource = resource;
    }

    public boolean hasResources() {
        return this.resource != null && !this.resource.isEmpty();
    }

    public boolean hasScopes() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    public OA2Client getErsatzClient() {
        return this.ersatzClient;
    }

    public void setErsatzClient(OA2Client ersatzClient) {
        this.ersatzClient = ersatzClient;
    }

    public void toXML(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement("tx_record");
        xsw.writeAttribute("serialization_version", "2.0");
        xsw.writeAttribute("id", this.getIdentifierString());
        xsw.writeAttribute("expires_at", Long.toString(this.expiresAt));
        xsw.writeAttribute("lifetime", Long.toString(this.lifetime));
        xsw.writeAttribute("issue_at", Long.toString(this.issuedAt));
        xsw.writeAttribute("is_valid", Boolean.toString(this.valid));
        if (!StringUtils.isTrivial((String)this.storedToken)) {
            xsw.writeAttribute("stored_token", this.storedToken);
        }
        if (!StringUtils.isTrivial((String)this.issuer)) {
            xsw.writeAttribute("issuer", this.issuer);
        }
        if (!StringUtils.isTrivial((String)this.tokenType)) {
            xsw.writeAttribute("token_type", this.tokenType);
        }
        if (this.getParentID() != null) {
            xsw.writeAttribute("parent_id", this.getParentID().toString());
        }
        if (this.scopes != null && !this.scopes.isEmpty()) {
            xsw.writeStartElement("scopes");
            XMLUtilsV2.toCDATA((XMLStreamWriter)xsw, this.scopes);
            xsw.writeEndElement();
        }
        if (this.audience != null && !this.audience.isEmpty()) {
            xsw.writeStartElement("audience");
            XMLUtilsV2.toCDATA((XMLStreamWriter)xsw, this.audience);
            xsw.writeEndElement();
        }
        if (this.resource != null && !this.resource.isEmpty()) {
            xsw.writeStartElement("resources");
            ArrayList<String> ll = new ArrayList<String>();
            for (URI x : this.resource) {
                ll.add(x.toString());
            }
            XMLUtilsV2.toCDATA((XMLStreamWriter)xsw, ll);
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
    }

    public void fromXML(XMLEventReader xer) throws XMLStreamException {
        String versionNumber;
        XMLEvent xe = xer.nextEvent();
        while (!xe.isStartElement()) {
            xe = xer.nextEvent();
        }
        switch (versionNumber = this.doXMLAttributes(xe)) {
            case "2.0": {
                this.fromXMLNEW(xer);
                break;
            }
            default: {
                this.fromXMLOLD(xer);
            }
        }
    }

    protected void fromXMLOLD(XMLEventReader xer) throws XMLStreamException {
        while (xer.hasNext()) {
            XMLEvent xe = xer.peek();
            switch (xe.getEventType()) {
                case 1: {
                    switch (xe.asStartElement().getName().getLocalPart()) {
                        case "audience": {
                            this.audience = XMLUtils.readStemAsStrings((XMLEventReader)xer);
                            break;
                        }
                        case "scopes": {
                            xer.nextEvent();
                            this.scopes = XMLUtils.readStemAsStrings((XMLEventReader)xer);
                            break;
                        }
                        case "resources": {
                            List ll = XMLUtils.readStemAsStrings((XMLEventReader)xer);
                            this.resource = new ArrayList<URI>();
                            for (String s : ll) {
                                this.resource.add(URI.create(s));
                            }
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!xe.asEndElement().getName().getLocalPart().equals("tx_record")) break;
                    return;
                }
            }
            xer.next();
        }
        throw new IllegalStateException("Error: XML file corrupt. No end tag for tx_record");
    }

    protected void fromXMLNEW(XMLEventReader xer) throws XMLStreamException {
        while (xer.hasNext()) {
            XMLEvent xe = xer.peek();
            switch (xe.getEventType()) {
                case 1: {
                    switch (xe.asStartElement().getName().getLocalPart()) {
                        case "audience": {
                            JSONArray j = JSONArray.fromObject((Object)XMLUtilsV2.getText((XMLEventReader)xer, (String)"audience"));
                            this.audience = new ArrayList<String>();
                            this.audience.addAll((Collection<String>)j);
                            break;
                        }
                        case "scopes": {
                            JSONArray j = JSONArray.fromObject((Object)XMLUtilsV2.getText((XMLEventReader)xer, (String)"scopes"));
                            this.scopes = new ArrayList<String>();
                            this.scopes.addAll((Collection<String>)j);
                            break;
                        }
                        case "resources": {
                            JSONArray j = JSONArray.fromObject((Object)XMLUtilsV2.getText((XMLEventReader)xer, (String)"resources"));
                            ArrayList ll = new ArrayList();
                            ll.addAll(j);
                            this.resource = new ArrayList<URI>();
                            for (String s : ll) {
                                this.resource.add(URI.create(s));
                            }
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!xe.asEndElement().getName().getLocalPart().equals("tx_record")) break;
                    return;
                }
            }
            xer.next();
        }
        throw new IllegalStateException("Error: XML file corrupt. No end tag for tx_record");
    }

    private String doXMLAttributes(XMLEvent xe) {
        String versionNumber = "";
        Iterator<Attribute> iterator = xe.asStartElement().getAttributes();
        while (iterator.hasNext()) {
            Attribute a = iterator.next();
            String v = a.getValue();
            switch (a.getName().getLocalPart()) {
                case "serialization_version": {
                    versionNumber = v;
                    break;
                }
                case "stored_token": {
                    this.storedToken = v;
                    break;
                }
                case "token_type": {
                    this.tokenType = v;
                    break;
                }
                case "expires_at": {
                    this.expiresAt = Long.parseLong(v);
                    break;
                }
                case "issue_at": {
                    this.issuedAt = Long.parseLong(v);
                    break;
                }
                case "lifetime": {
                    this.lifetime = Long.parseLong(v);
                    break;
                }
                case "id": {
                    this.setIdentifier(BasicIdentifier.newID((String)v));
                    break;
                }
                case "parent_id": {
                    this.setParentID(BasicIdentifier.newID((String)v));
                    break;
                }
                case "issuer": {
                    this.issuer = v;
                    break;
                }
                case "is_valid": {
                    this.valid = Boolean.parseBoolean(v);
                }
            }
        }
        return versionNumber;
    }
}

