/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.tx;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecordSerializationKeys;
import org.oa4mp.server.loader.oauth2.storage.tx.TXStore;

public class TXRecordConverter<V extends TXRecord>
extends MapConverter<V> {
    TXStore<? extends TXRecord> txStore;
    ClientStore<? extends OA2Client> clientStore;

    public TXRecordConverter(SerializationKeys keys, IdentifiableProvider<V> provider, ClientStore<? extends OA2Client> clientStore) {
        super(keys, provider);
        this.clientStore = clientStore;
    }

    protected TXRecordSerializationKeys tkeys() {
        return this.getKeys();
    }

    public TXRecordSerializationKeys getKeys() {
        return (TXRecordSerializationKeys)super.getKeys();
    }

    public V fromMap(ConversionMap<String, Object> map, V v) {
        JSONArray a;
        TXRecord txr = (TXRecord)super.fromMap(map, v);
        if (map.containsKey((Object)this.tkeys().audience(new String[0])) && map.get((Object)this.tkeys().audience(new String[0])) != null) {
            a = JSONArray.fromObject((Object)map.getString((Object)this.tkeys().audience(new String[0])));
            txr.setAudience((List<String>)a);
        }
        txr.setParentID(map.getIdentifier((Object)this.tkeys().parentID(new String[0])));
        if (map.containsKey((Object)this.tkeys().ersatzID(new String[0]))) {
            txr.setErsatzClient((OA2Client)((Object)this.clientStore.get((Object)BasicIdentifier.newID((String)map.getString((Object)this.tkeys().ersatzID(new String[0]))))));
        }
        if (map.containsKey((Object)this.getKeys().token(new String[0]))) {
            txr.setToken(JSONObject.fromObject((Object)map.getString((Object)this.getKeys().token(new String[0]))));
        }
        txr.setExpiresAt(map.getLong((Object)this.tkeys().expiresAt(new String[0])));
        txr.setLifetime(map.getLong((Object)this.tkeys().lifetime(new String[0])));
        txr.setIssuedAt(map.getLong((Object)this.tkeys().issuedAt(new String[0])));
        txr.setTokenType(map.getString((Object)this.tkeys().tokenType(new String[0])));
        if (map.containsKey((Object)this.tkeys().storedToken(new String[0]))) {
            txr.setStoredToken(map.getString((Object)this.tkeys().storedToken(new String[0])));
        }
        if (map.containsKey((Object)this.tkeys().issuer(new String[0])) && map.get((Object)this.tkeys().issuer(new String[0])) != null) {
            txr.setIssuer(map.getString((Object)this.tkeys().issuer(new String[0])));
        }
        if (map.containsKey((Object)this.tkeys().resource(new String[0])) && map.get((Object)this.tkeys().resource(new String[0])) != null) {
            a = JSONArray.fromObject((Object)map.getString((Object)this.tkeys().resource(new String[0])));
            ArrayList<URI> a1 = new ArrayList<URI>();
            for (int i = 0; i < a.size(); ++i) {
                a1.add(URI.create(a.getString(i)));
            }
            a1.addAll((Collection<URI>)a);
            txr.setResource(a1);
        }
        if (map.containsKey((Object)this.tkeys().isValid(new String[0]))) {
            txr.setValid(map.getBoolean((Object)this.tkeys().isValid(new String[0])));
        }
        if (map.containsKey((Object)this.tkeys().scopes(new String[0])) && map.get((Object)this.tkeys().scopes(new String[0])) != null) {
            txr.setScopes((List<String>)JSONArray.fromObject((Object)map.getString((Object)this.tkeys().scopes(new String[0]))));
        }
        return (V)txr;
    }

    public void toMap(V value, ConversionMap<String, Object> data) {
        JSONArray array;
        super.toMap(value, data);
        if (((TXRecord)value).getParentID() != null) {
            data.put((Object)this.tkeys().parentID(new String[0]), (Object)((TXRecord)value).getParentID().toString());
        }
        data.put((Object)this.tkeys().issuedAt(new String[0]), (Object)((TXRecord)value).getIssuedAt());
        data.put((Object)this.tkeys().lifetime(new String[0]), (Object)((TXRecord)value).getLifetime());
        data.put((Object)this.tkeys().expiresAt(new String[0]), (Object)((TXRecord)value).getExpiresAt());
        data.put((Object)this.tkeys().isValid(new String[0]), (Object)((TXRecord)value).isValid());
        data.put((Object)this.tkeys().tokenType(new String[0]), (Object)((TXRecord)value).getTokenType());
        if (((TXRecord)value).getErsatzClient() != null) {
            data.put((Object)this.tkeys().ersatzID(new String[0]), (Object)((TXRecord)value).getErsatzClient().getIdentifierString());
        }
        if (((TXRecord)value).getToken() != null) {
            data.put((Object)this.tkeys().token(new String[0]), (Object)((TXRecord)value).getToken().toString());
        }
        if (((TXRecord)value).getStoredToken() != null) {
            data.put((Object)this.tkeys().storedToken(new String[0]), (Object)((TXRecord)value).getStoredToken());
        }
        if (((TXRecord)value).hasScopes()) {
            if (((TXRecord)value).getScopes() instanceof JSONArray) {
                array = (JSONArray)((TXRecord)value).getScopes();
            } else {
                array = new JSONArray();
                array.addAll(((TXRecord)value).getScopes());
            }
            data.put((Object)this.tkeys().scopes(new String[0]), (Object)array.toString());
        }
        if (((TXRecord)value).hasAudience()) {
            if (((TXRecord)value).getAudience() instanceof JSONArray) {
                array = (JSONArray)((TXRecord)value).getAudience();
            } else {
                array = new JSONArray();
                array.addAll(((TXRecord)value).getAudience());
            }
            data.put((Object)this.tkeys().audience(new String[0]), (Object)array.toString());
        }
        if (((TXRecord)value).hasResources()) {
            array = new JSONArray();
            for (URI uri : ((TXRecord)value).getResource()) {
                array.add((Object)uri.toString());
            }
            data.put((Object)this.tkeys().resource(new String[0]), (Object)array.toString());
        }
        if (!StringUtils.isTrivial((String)((TXRecord)value).getIssuer())) {
            data.put((Object)this.tkeys().issuer(new String[0]), (Object)((TXRecord)value).getIssuer());
        }
    }
}

