/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.vi;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.monitored.MonitoredSQLStore;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionRecord;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javax.inject.Provider;
import org.oa4mp.server.loader.oauth2.storage.vi.VISerializationKeys;
import org.oa4mp.server.loader.oauth2.storage.vi.VIStore;
import org.oa4mp.server.loader.oauth2.storage.vi.VirtualIssuer;

public class SQLVIStore<V extends VirtualIssuer>
extends MonitoredSQLStore<V>
implements VIStore<V> {
    public SQLVIStore(ConnectionPool connectionPool, Table table, Provider<V> identifiableProvider, MapConverter<V> converter) {
        super(connectionPool, table, identifiableProvider, converter);
    }

    @Override
    public V findByPath(String component) {
        String pathQuery = "select * from " + this.getTable().getFQTablename() + " where " + ((VISerializationKeys)this.getMapConverter().getKeys()).discoveryPath(new String[0]) + " = ?";
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        VirtualIssuer vo = null;
        try {
            PreparedStatement stmt = c.prepareStatement(pathQuery);
            stmt.setString(1, component);
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            if (!rs.next()) {
                rs.close();
                stmt.close();
                this.releaseConnection(cr);
                return null;
            }
            ColumnMap map = SQLVIStore.rsToMap((ResultSet)rs);
            rs.close();
            stmt.close();
            vo = (VirtualIssuer)this.create();
            this.populate(map, (Identifiable)vo);
            this.releaseConnection(cr);
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            throw new GeneralException("Error getting virtual issuer with path component \"" + component + "\"", (Throwable)e);
        }
        return (V)((Object)vo);
    }

    public void save(V value) {
        value.setLastModifiedTS(new Date());
        super.save(value);
    }

    public void update(V value) {
        value.setLastModifiedTS(new Date());
        super.update(value);
    }

    public String getCreationTSField() {
        return ((VISerializationKeys)this.getMapConverter().getKeys()).creationTS(new String[0]);
    }
}

