/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.vi;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.util.Date;
import org.oa4mp.server.loader.oauth2.storage.vi.VISerializationKeys;
import org.oa4mp.server.loader.oauth2.storage.vi.VirtualIssuer;

public class VIConverter<V extends VirtualIssuer>
extends MapConverter<V> {
    public VIConverter(SerializationKeys keys, IdentifiableProvider<V> provider) {
        super(keys, provider);
    }

    protected VISerializationKeys vok() {
        return (VISerializationKeys)this.keys;
    }

    public V fromMap(ConversionMap<String, Object> map, V v) {
        VirtualIssuer vi = (VirtualIssuer)super.fromMap(map, v);
        vi.setCreationTS(new Date(map.getLong((Object)this.vok().creationTS(new String[0]))));
        vi.setLastModifiedTS(new Date(map.getLong((Object)this.vok().lastModifiedTS(new String[0]))));
        vi.setLastAccessed(new Date(map.getLong((Object)this.vok().lastAccessed(new String[0]))));
        vi.setValid(map.getBoolean((Object)this.vok().valid(new String[0])));
        if (map.containsKey((Object)this.vok().issuer(new String[0])) && !StringUtils.isTrivial((String)map.getString((Object)this.vok().issuer(new String[0])))) {
            vi.setIssuer(map.getString((Object)this.vok().issuer(new String[0])));
        }
        if (map.containsKey((Object)this.vok().atIssuer(new String[0])) && !StringUtils.isTrivial((String)map.getString((Object)this.vok().atIssuer(new String[0])))) {
            vi.setAtIssuer(map.getString((Object)this.vok().atIssuer(new String[0])));
        }
        if (map.containsKey((Object)this.vok().defaultKeyID(new String[0])) && !StringUtils.isTrivial((String)map.getString((Object)this.vok().defaultKeyID(new String[0])))) {
            vi.setDefaultKeyID(map.getString((Object)this.vok().defaultKeyID(new String[0])));
        }
        if (map.containsKey((Object)this.vok().jsonWebKeys(new String[0])) && !StringUtils.isTrivial((String)map.getString((Object)this.vok().jsonWebKeys(new String[0])))) {
            try {
                JSONWebKeys keys = JSONWebKeyUtil.fromJSON((String)map.getString((Object)this.vok().jsonWebKeys(new String[0])));
                vi.setJsonWebKeys(keys);
            }
            catch (Throwable e) {
                DebugUtil.error((Object)((Object)this), (String)("Could not deserialize the JSON web keys for this VI.\"" + vi.getIdentifierString() + "\"."), (Throwable)e);
            }
        }
        if (map.containsKey((Object)this.vok().discoveryPath(new String[0])) && !StringUtils.isTrivial((String)map.getString((Object)this.vok().discoveryPath(new String[0])))) {
            vi.setDiscoveryPath(map.getString((Object)this.vok().discoveryPath(new String[0])));
        }
        if (map.containsKey((Object)this.vok().title(new String[0])) && !StringUtils.isTrivial((String)map.getString((Object)this.vok().title(new String[0])))) {
            vi.setTitle(map.getString((Object)this.vok().title(new String[0])));
        }
        return (V)((Object)vi);
    }

    public void toMap(V value, ConversionMap<String, Object> data) {
        super.toMap(value, data);
        data.put((Object)this.vok().valid(new String[0]), (Object)((VirtualIssuer)((Object)value)).isValid());
        if (value.getCreationTS() != null) {
            data.put((Object)this.vok().creationTS(new String[0]), (Object)value.getCreationTS().getTime());
        }
        if (value.getLastModifiedTS() != null) {
            data.put((Object)this.vok().lastModifiedTS(new String[0]), (Object)value.getLastModifiedTS().getTime());
        }
        if (value.getLastAccessed() != null) {
            data.put((Object)this.vok().lastAccessed(new String[0]), (Object)value.getLastAccessed().getTime());
        }
        if (!StringUtils.isTrivial((String)((VirtualIssuer)((Object)value)).getIssuer())) {
            data.put((Object)this.vok().issuer(new String[0]), (Object)((VirtualIssuer)((Object)value)).getIssuer());
        }
        if (!StringUtils.isTrivial((String)((VirtualIssuer)((Object)value)).getAtIssuer())) {
            data.put((Object)this.vok().atIssuer(new String[0]), (Object)((VirtualIssuer)((Object)value)).getAtIssuer());
        }
        if (!StringUtils.isTrivial((String)((VirtualIssuer)((Object)value)).getTitle())) {
            data.put((Object)this.vok().title(new String[0]), (Object)((VirtualIssuer)((Object)value)).getTitle());
        }
        if (!StringUtils.isTrivial((String)((VirtualIssuer)((Object)value)).getDefaultKeyID())) {
            data.put((Object)this.vok().defaultKeyID(new String[0]), (Object)((VirtualIssuer)((Object)value)).getDefaultKeyID());
        }
        if (!StringUtils.isTrivial((String)((VirtualIssuer)((Object)value)).getDiscoveryPath())) {
            data.put((Object)this.vok().discoveryPath(new String[0]), (Object)((VirtualIssuer)((Object)value)).getDiscoveryPath());
        }
        if (((VirtualIssuer)((Object)value)).getJsonWebKeys() != null) {
            data.put((Object)this.vok().jsonWebKeys(new String[0]), (Object)JSONWebKeyUtil.toJSON((JSONWebKeys)((VirtualIssuer)((Object)value)).getJsonWebKeys()).toString());
        }
    }
}

