/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.vi;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.GenericStoreUtils;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.monitored.MonitoredFileStore;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.oa4mp.server.loader.oauth2.storage.vi.VIStore;
import org.oa4mp.server.loader.oauth2.storage.vi.VirtualIssuer;

public class VIFileStore<V extends VirtualIssuer>
extends MonitoredFileStore<V>
implements VIStore<V> {
    public VIFileStore(File storeDirectory, File indexDirectory, IdentifiableProvider<V> identifiableProvider, MapConverter<V> converter, boolean removeEmptyFiles, boolean removeFailedFiles) {
        super(storeDirectory, indexDirectory, identifiableProvider, converter, removeEmptyFiles, removeFailedFiles);
    }

    public VIFileStore(File directory, IdentifiableProvider<V> idp, MapConverter<V> cp, boolean removeEmptyFiles, boolean removeFailedFiles) {
        super(directory, idp, cp, removeEmptyFiles, removeFailedFiles);
    }

    @Override
    public MapConverter<V> getMapConverter() {
        return this.converter;
    }

    @Override
    public V findByPath(String component) {
        return (V)((Object)((VirtualIssuer)this.getIndexEntry(component)));
    }

    protected V realRemove(V oldItem) {
        super.realRemove(oldItem);
        if (!StringUtils.isTrivial((String)((VirtualIssuer)((Object)oldItem)).getDiscoveryPath())) {
            this.removeIndexEntry(((VirtualIssuer)((Object)oldItem)).getDiscoveryPath());
        }
        return oldItem;
    }

    public void realSave(boolean checkExists, V t) {
        t.setLastModifiedTS(new Date());
        super.realSave(checkExists, t);
        try {
            if (!StringUtils.isTrivial((String)((VirtualIssuer)((Object)t)).getDiscoveryPath())) {
                this.createIndexEntry(((VirtualIssuer)((Object)t)).getDiscoveryPath(), t.getIdentifierString());
            }
        }
        catch (IOException e) {
            throw new GeneralException("Error serializing item " + String.valueOf(t) + "to file ");
        }
    }

    public List<V> getMostRecent(int n, List<String> attributes) {
        return GenericStoreUtils.getMostRecent((Store)this, (int)n, attributes);
    }
}

