/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.vi;

import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.XMLConverter;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.GenericStoreUtils;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.monitored.MonitoredMemoryStore;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.oa4mp.server.loader.oauth2.storage.vi.VIConverter;
import org.oa4mp.server.loader.oauth2.storage.vi.VIProvider;
import org.oa4mp.server.loader.oauth2.storage.vi.VIStore;
import org.oa4mp.server.loader.oauth2.storage.vi.VirtualIssuer;

public class VIMemoryStore<V extends VirtualIssuer>
extends MonitoredMemoryStore<V>
implements VIStore<V> {
    VIConverter<V> converter;
    Map<String, V> pathIndex = new HashMap<String, V>();

    public VIMemoryStore(VIProvider<V> identifiableProvider, VIConverter<V> converter) {
        super(identifiableProvider);
        this.converter = converter;
    }

    public XMLConverter<V> getXMLConverter() {
        return this.converter;
    }

    @Override
    public MapConverter<V> getMapConverter() {
        return this.converter;
    }

    @Override
    public V findByPath(String component) {
        return (V)((Object)((VirtualIssuer)((Object)this.pathIndex.get(component))));
    }

    protected void updateIndices(V v) {
        if (!StringUtils.isTrivial((String)((VirtualIssuer)((Object)v)).getDiscoveryPath())) {
            this.pathIndex.put(((VirtualIssuer)((Object)v)).getDiscoveryPath(), v);
        }
    }

    protected void removeIndex(V value) {
        if (!StringUtils.isTrivial((String)((VirtualIssuer)((Object)value)).getDiscoveryPath())) {
            this.pathIndex.remove(((VirtualIssuer)((Object)value)).getDiscoveryPath());
        }
    }

    public void register(V value) {
        super.register(value);
        this.updateIndices(value);
    }

    public void save(V value) {
        value.setLastModifiedTS(new Date());
        super.save(value);
        this.updateIndices(value);
    }

    public void update(V value) {
        value.setLastModifiedTS(new Date());
        super.update(value);
        this.updateIndices(value);
    }

    public void clear() {
        super.clear();
        this.clearIndices();
    }

    protected void clearIndices() {
        this.pathIndex = new HashMap<String, V>();
    }

    public V remove(Object key) {
        VirtualIssuer item = (VirtualIssuer)((Object)super.remove(key));
        if (item != null) {
            this.removeIndex(item);
        }
        return (V)((Object)item);
    }

    public List<V> getMostRecent(int n, List<String> attributes) {
        return GenericStoreUtils.getMostRecent((Store)this, (int)n, attributes);
    }
}

