/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.storage.vi;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.monitored.Monitored;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.qdl_lang.xml.XMLUtils;

public class VirtualIssuer
extends Monitored {
    String defaultKeyID;
    String discoveryPath;
    String issuer;
    String atIssuer;
    JSONWebKeys jsonWebKeys;
    String title;
    boolean valid = true;

    public VirtualIssuer(Identifier identifier) {
        super(identifier);
    }

    public String getAtIssuer() {
        return this.atIssuer;
    }

    public void setAtIssuer(String atIssuer) {
        this.atIssuer = atIssuer;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getDefaultKeyID() {
        return this.defaultKeyID;
    }

    public void setDefaultKeyID(String defaultKeyID) {
        this.defaultKeyID = defaultKeyID;
        if (this.getJsonWebKeys() != null) {
            this.getJsonWebKeys().setDefaultKeyID(defaultKeyID);
        }
    }

    public String getDiscoveryPath() {
        return this.discoveryPath;
    }

    public void setDiscoveryPath(String discoveryPath) {
        this.discoveryPath = discoveryPath;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public JSONWebKeys getJsonWebKeys() {
        return this.jsonWebKeys;
    }

    public void setJsonWebKeys(JSONWebKeys jsonWebKeys) {
        this.jsonWebKeys = jsonWebKeys;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void toXML(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement("virtual_issuer");
        xsw.writeAttribute("id", this.getIdentifierString());
        xsw.writeAttribute("created_at", Long.toString(this.getCreationTS().getTime()));
        xsw.writeAttribute("last_modified_at", Long.toString(this.getLastModifiedTS().getTime()));
        xsw.writeAttribute("last_accessed_at", Long.toString(this.getLastAccessed().getTime()));
        xsw.writeAttribute("is_valid", Boolean.toString(this.valid));
        if (!StringUtils.isTrivial((String)this.issuer)) {
            xsw.writeAttribute("issuer", this.issuer);
        }
        if (!StringUtils.isTrivial((String)this.discoveryPath)) {
            xsw.writeAttribute("discovery_path", this.discoveryPath);
        }
        if (!StringUtils.isTrivial((String)this.title)) {
            xsw.writeAttribute("title", this.title);
        }
        if (!StringUtils.isTrivial((String)this.defaultKeyID)) {
            xsw.writeAttribute("default_key", this.defaultKeyID);
        }
        if (this.jsonWebKeys != null) {
            JSONObject json = JSONWebKeyUtil.toJSON((JSONWebKeys)this.jsonWebKeys);
            xsw.writeStartElement("json_web_keys");
            XMLUtils.write((XMLStreamWriter)xsw, (String)Base64.encodeBase64String((byte[])json.toString().getBytes(StandardCharsets.UTF_8)));
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
    }

    public void fromXML(XMLEventReader xer) throws XMLStreamException {
        XMLEvent xe = xer.nextEvent();
        this.doXMLAttributes(xe);
        while (xer.hasNext()) {
            xe = xer.peek();
            switch (xe.getEventType()) {
                case 1: {
                    switch (xe.asStartElement().getName().getLocalPart()) {
                        case "json_web_keys": {
                            String raw = xe.asCharacters().getData();
                            this.jsonWebKeys = JSONWebKeyUtil.fromJSON((String)new String(Base64.decodeBase64((String)raw)));
                        }
                    }
                    break;
                }
                case 2: {
                    if (!xe.asEndElement().getName().getLocalPart().equals("virtual_issuer")) break;
                    return;
                }
            }
            xer.next();
        }
        throw new IllegalStateException("Error: XML file corrupt. No end tag for virtual_issuer");
    }

    private void doXMLAttributes(XMLEvent xe) {
        Iterator<Attribute> iterator = xe.asStartElement().getAttributes();
        while (iterator.hasNext()) {
            Attribute a = iterator.next();
            String v = a.getValue();
            switch (a.getName().getLocalPart()) {
                case "id": {
                    this.setIdentifier(BasicIdentifier.newID((String)v));
                    break;
                }
                case "created_at": {
                    this.setCreationTS(new Date(Long.parseLong(v)));
                    break;
                }
                case "last_modified_at": {
                    this.setLastModifiedTS(new Date(Long.parseLong(v)));
                    break;
                }
                case "last_accessed_at": {
                    this.setLastAccessed(new Date(Long.parseLong(v)));
                }
                case "is_valid": {
                    break;
                }
                case "issuer": {
                    this.issuer = v;
                    break;
                }
                case "default_key": {
                    this.defaultKeyID = v;
                    break;
                }
                case "discovery_path": {
                    this.discoveryPath = v;
                    break;
                }
                case "title": {
                    this.title = v;
                }
            }
        }
    }

    public String toString() {
        return "VirtualIssuer{created=" + String.valueOf(this.getCreationTS()) + ", defaultKeyID='" + this.defaultKeyID + "', discoveryPath='" + this.discoveryPath + "', issuer='" + this.issuer + "', atIssuer='" + this.atIssuer + "', lastModified=" + String.valueOf(this.getLastModifiedTS()) + ", lastAccessed=" + String.valueOf(this.getLastAccessed()) + ", title='" + this.title + "', valid=" + this.valid + "}";
    }
}

