/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.tokens;

import edu.uiuc.ncsa.security.core.util.DebugUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.server.loader.oauth2.claims.AbstractPayloadConfig;

public class AbstractCommonATandRTConfig
extends AbstractPayloadConfig {
    public static String ISSUER_KEY = "issuer";
    public static String AUDIENCE_KEY = "audience";
    public static String RESOURCE_KEY = "resource";
    String issuer;
    List<String> audience = new ArrayList<String>();
    List<URI> resource = new ArrayList<URI>();

    public List<URI> getResource() {
        return this.resource;
    }

    public void setResource(List<URI> resource) {
        this.resource = resource;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public List<String> getAudience() {
        return this.audience;
    }

    public void setAudience(List<String> audience) {
        this.audience = audience;
    }

    @Override
    public void fromJSON(JSONObject jsonObject) {
        Object obj;
        super.fromJSON(jsonObject);
        if (jsonObject.containsKey((Object)ISSUER_KEY)) {
            this.issuer = jsonObject.getString(ISSUER_KEY);
        }
        if (jsonObject.containsKey((Object)AUDIENCE_KEY)) {
            obj = jsonObject.get(AUDIENCE_KEY);
            DebugUtil.trace((Object)this, (String)("Got audience=" + String.valueOf(obj)));
            if (obj instanceof JSONArray) {
                this.audience = (List)obj;
            } else {
                ArrayList<String> x = new ArrayList<String>();
                x.add(obj.toString());
                this.audience = x;
            }
        }
        if (jsonObject.containsKey((Object)RESOURCE_KEY)) {
            obj = jsonObject.get(RESOURCE_KEY);
            DebugUtil.trace((Object)this, (String)("Got resource=" + String.valueOf(obj)));
            this.resource = new ArrayList<URI>();
            List raw = new ArrayList();
            if (obj instanceof JSONArray) {
                raw = (List)obj;
            } else {
                ArrayList<String> x = new ArrayList<String>();
                x.add(obj.toString());
                raw = x;
            }
            for (String rr : raw) {
                try {
                    this.resource.add(URI.create(rr));
                }
                catch (Throwable t) {
                    DebugUtil.trace((Object)this, (String)("skipping bad resource: \"" + rr + "\":" + t.getMessage()));
                }
            }
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (this.issuer != null) {
            json.put((Object)ISSUER_KEY, (Object)this.issuer);
        }
        if (this.audience != null) {
            json.put((Object)AUDIENCE_KEY, this.audience);
        }
        if (this.resource != null) {
            JSONArray j = new JSONArray();
            for (int i = 0; i < this.resource.size(); ++i) {
                j.add((Object)this.resource.get(i).toString());
            }
            json.put((Object)AUDIENCE_KEY, (Object)j);
        }
        return json;
    }
}

