/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.tokens;

import edu.uiuc.ncsa.security.core.util.BeanUtils;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import net.sf.json.JSONObject;

public class AuthorizationPath {
    String operation;
    String path = null;
    boolean extensible = true;

    public boolean isExtensible() {
        return this.extensible;
    }

    public void setExtensible(boolean extensible) {
        this.extensible = extensible;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getPath() {
        return this.path;
    }

    public boolean hasPath() {
        return !StringUtils.isTrivial((String)this.path);
    }

    public AuthorizationPath(JSONObject json) {
        this.fromJSON(json);
    }

    public AuthorizationPath(String operation, String path, boolean isExtensible) {
        this.operation = operation;
        this.path = path;
        this.extensible = isExtensible;
    }

    public AuthorizationPath(String operation) {
        this(operation, null, false);
    }

    public AuthorizationPath(String operation, String path) {
        this(operation, path, true);
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"op", (Object)this.operation);
        if (this.hasPath()) {
            jsonObject.put((Object)"path", (Object)this.path);
        }
        jsonObject.put((Object)"isExtensible", (Object)this.extensible);
        return jsonObject;
    }

    public void fromJSON(JSONObject j) {
        this.operation = j.getString("op");
        if (j.containsKey((Object)"isExtensible")) {
            this.extensible = j.getBoolean("isExtensible");
        }
        if (j.containsKey((Object)"path")) {
            this.path = j.getString("path");
        } else {
            this.extensible = false;
        }
    }

    public void fromString(String template) {
        int colonIndex = template.indexOf(":");
        if (colonIndex < 0) {
            this.operation = template;
            this.path = "";
        } else {
            this.operation = template.substring(0, colonIndex);
            this.path = template.substring(colonIndex + 1);
        }
    }

    public String toString() {
        return "AuthorizationPath{operation='" + this.operation + "', path='" + this.path + "', extensible=" + this.extensible + "}";
    }

    public String toPath() {
        return this.operation + (String)(StringUtils.isTrivial((String)this.path) ? "" : ":" + this.path);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AuthorizationPath)) {
            return false;
        }
        AuthorizationPath ap = (AuthorizationPath)obj;
        if (!BeanUtils.checkEquals((Object)ap.operation, (Object)this.operation)) {
            return false;
        }
        if (!BeanUtils.checkEquals((Object)ap.path, (Object)this.path)) {
            return false;
        }
        return ap.extensible != this.extensible;
    }
}

