/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.tokens;

import edu.uiuc.ncsa.security.core.util.BeanUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.server.loader.oauth2.tokens.AuthorizationPath;

public class AuthorizationTemplate {
    String audience;
    Collection<AuthorizationPath> paths;

    public AuthorizationTemplate(JSONObject json) {
        this.fromJSON(json);
    }

    public AuthorizationTemplate(String audience, Collection<AuthorizationPath> paths) {
        this.audience = audience;
        this.paths = paths;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public Collection<AuthorizationPath> getPaths() {
        return this.paths;
    }

    public void setPaths(Collection<AuthorizationPath> paths) {
        this.paths = paths;
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"aud", (Object)this.audience);
        JSONArray array = new JSONArray();
        for (AuthorizationPath path : this.paths) {
            array.add((Object)path.toJSON());
        }
        jsonObject.put((Object)"paths", (Object)array);
        return jsonObject;
    }

    public void fromJSON(JSONObject jsonObject) {
        this.audience = jsonObject.getString("aud");
        JSONArray x = jsonObject.getJSONArray("paths");
        this.paths = new LinkedList<AuthorizationPath>();
        for (int i = 0; i < x.size(); ++i) {
            AuthorizationPath authorizationPath = new AuthorizationPath(x.getJSONObject(i));
            this.paths.add(authorizationPath);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AuthorizationTemplate)) {
            return false;
        }
        AuthorizationTemplate at = (AuthorizationTemplate)obj;
        if (!BeanUtils.checkEquals((Object)at.audience, (Object)this.audience)) {
            return false;
        }
        if (at.getPaths().size() != this.getPaths().size()) {
            return false;
        }
        for (AuthorizationPath ap : this.getPaths()) {
            if (at.getPaths().contains(ap)) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            ArrayList<AuthorizationPath> paths = new ArrayList<AuthorizationPath>();
            paths.add(new AuthorizationPath("read", "/home/${sub}"));
            paths.add(new AuthorizationPath("read", "/home/${eppn}/${sub}"));
            paths.add(new AuthorizationPath("write", "/home/${sub}"));
            paths.add(new AuthorizationPath("execute", "/home/${memberOf}/ingest.sh"));
            paths.add(new AuthorizationPath("queue", "/home/${memberOf}/serialize.sh"));
            AuthorizationTemplate template = new AuthorizationTemplate("https://foo.bigstate.edu", paths);
            System.out.println(template.toJSON().toString(1));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

