/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.tokens;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.server.loader.oauth2.tokens.AuthorizationPath;
import org.oa4mp.server.loader.oauth2.tokens.AuthorizationTemplate;
import org.qdl_lang.variables.QDLStem;

public class AuthorizationTemplates
extends HashMap<String, AuthorizationTemplate> {
    public static final String OPERATION_KEY = "op";
    public static final String PATH_KEY = "path";
    public static final String EXTENSIBLE_KEY = "isExtensible";

    public AuthorizationTemplate put(AuthorizationTemplate value) {
        return super.put(value.getAudience(), value);
    }

    public void fromJSON(JSON json) {
        if (json.isArray()) {
            this.fromJSON((JSONArray)json);
        } else {
            JSONArray array = new JSONArray();
            array.add((Object)json);
            this.fromJSON(array);
        }
    }

    public void fromJSON(JSONArray array) {
        for (int i = 0; i < array.size(); ++i) {
            JSONObject json = array.getJSONObject(i);
            AuthorizationTemplate at = new AuthorizationTemplate(json);
            this.put(at.getAudience(), at);
        }
    }

    public void fromJSON(String rawJSON) {
        JSONArray array = null;
        try {
            array = JSONArray.fromObject((Object)rawJSON);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (array == null) {
            try {
                JSONObject json = JSONObject.fromObject((Object)rawJSON);
                array = new JSONArray();
                array.add((Object)json);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (array == null) {
            throw new GeneralException("Error: Could not parse string into JSON.");
        }
        this.fromJSON(array);
    }

    public JSONArray toJSON() {
        JSONArray array = new JSONArray();
        for (String audience : this.keySet()) {
            AuthorizationTemplate at = (AuthorizationTemplate)this.get(audience);
            array.add((Object)at.toJSON());
        }
        return array;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AuthorizationTemplates)) {
            return false;
        }
        AuthorizationTemplates ats = (AuthorizationTemplates)obj;
        if (ats.size() != this.size()) {
            return false;
        }
        for (String key : this.keySet()) {
            AuthorizationTemplate thatAT = (AuthorizationTemplate)ats.get(key);
            AuthorizationTemplate thisAT = (AuthorizationTemplate)this.get(key);
            if (thisAT.equals(thatAT)) continue;
            return false;
        }
        return true;
    }

    public Collection<String> getCapabilities(String audience) {
        ArrayList<String> out = new ArrayList<String>();
        AuthorizationTemplate at = (AuthorizationTemplate)this.get(audience);
        for (AuthorizationPath ap : at.getPaths()) {
            if (ap.hasPath()) continue;
            out.add(ap.getOperation());
        }
        return out;
    }

    public Collection<String> getCapabilities(String audience, Collection<String> requested) {
        ArrayList<String> out = new ArrayList<String>();
        AuthorizationTemplate at = (AuthorizationTemplate)this.get(audience);
        for (AuthorizationPath ap : at.getPaths()) {
            String cap;
            if (ap.hasPath() || !requested.contains(cap = ap.getOperation())) continue;
            out.add(cap);
        }
        return out;
    }

    public static void main(String[] args) {
        ArrayList<AuthorizationPath> paths = new ArrayList<AuthorizationPath>();
        paths.add(new AuthorizationPath("read", "/home/${sub}"));
        paths.add(new AuthorizationPath("write", "/home/${sub}"));
        paths.add(new AuthorizationPath("queue", "/home/${memberOf}/serialize.sh"));
        AuthorizationTemplate template = new AuthorizationTemplate("https://foo.bigstate.edu", paths);
        AuthorizationTemplates authorizationTemplates = new AuthorizationTemplates();
        authorizationTemplates.put(template);
        System.out.println(authorizationTemplates.toJSON().toString(1));
        paths = new ArrayList();
        paths.add(new AuthorizationPath("storage.create", "/home/${eppn}/${sub}"));
        paths.add(new AuthorizationPath("storage.read", "/home/${memberOf}/ingest.sh"));
        paths.add(new AuthorizationPath("compute.create"));
        paths.add(new AuthorizationPath("compute.modify"));
        template = new AuthorizationTemplate("https://bar.bigstate.edu", paths);
        authorizationTemplates.put(template);
        System.out.println(authorizationTemplates.toJSON().toString(1));
        System.out.println("capabilities:" + String.valueOf(authorizationTemplates.getCapabilities("https://bar.bigstate.edu")));
        QDLStem stem = new QDLStem();
        stem.fromJSON((JSON)authorizationTemplates.toJSON());
        System.out.println(stem.toString(1));
    }
}

