/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.tokens;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import edu.uiuc.ncsa.security.util.scripting.ScriptRunRequest;
import edu.uiuc.ncsa.security.util.scripting.ScriptRunResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.token.RefreshToken;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;
import org.oa4mp.delegation.server.jwt.MyOtherJWTUtil2;
import org.oa4mp.delegation.server.jwt.RefreshTokenHandlerInterface;
import org.oa4mp.delegation.server.server.claims.ClaimSource;
import org.oa4mp.server.loader.oauth2.claims.AbstractPayloadHandler;
import org.oa4mp.server.loader.oauth2.claims.PayloadHandlerConfigImpl;
import org.oa4mp.server.loader.oauth2.servlet.ClientUtils;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.oa4mp.server.loader.oauth2.tokens.RefreshTokenConfig;

public class BasicRefreshTokenHandler
extends AbstractPayloadHandler
implements RefreshTokenHandlerInterface {
    public static final String REFRESH_TOKEN_DEFAULT_HANDLER_TYPE = "default";
    public static final String REFRESH_TOKEN_BASIC_HANDLER_TYPE = "refresh";

    public BasicRefreshTokenHandler(PayloadHandlerConfigImpl payloadHandlerConfig) {
        super(payloadHandlerConfig);
    }

    public RefreshToken getRefreshToken() {
        return this.transaction.getRefreshToken();
    }

    public void setRefreshToken(RefreshToken refreshToken) {
        this.transaction.setRefreshToken(refreshToken);
    }

    public JSONObject getPayload() {
        if (this.payload == null) {
            this.payload = this.transaction.getRTData();
            if (this.payload == null) {
                this.payload = new JSONObject();
            }
        }
        return this.payload;
    }

    public void setRTData(JSONObject rtData) {
        this.setPayload(rtData);
    }

    public RefreshTokenImpl getSignedPayload(JSONWebKey key) {
        return this.getSignedPayload(key, null);
    }

    public RefreshTokenImpl getSignedPayload(JSONWebKey key, String headerType) {
        if (this.getPayload().isEmpty()) {
            return null;
        }
        if (this.getPayload().size() == 1) {
            String k = String.valueOf(this.getPayload().keySet().iterator().next());
            String v = String.valueOf(this.getPayload().get(k));
            this.oa2se.info("Single value in refresh token for \"" + this.client.getIdentifierString() + "\" found. Setting token value to " + v);
            return new RefreshTokenImpl(URI.create(v));
        }
        if (!this.getPayload().containsKey((Object)"jti")) {
            throw new IllegalStateException("no jti. Cannot create refresh token");
        }
        try {
            if (key == null) {
                key = new JSONWebKey();
                key.algorithm = "none";
            }
            String at = MyOtherJWTUtil2.createJWT((JSONObject)this.getPayload(), (JSONWebKey)key);
            return TokenFactory.createRT((String)at);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            e.printStackTrace();
            throw new GeneralException("Could not create signed refresh token", e);
        }
    }

    public void init() throws Throwable {
        this.setAccountingInformation();
    }

    public void addRequestState(ScriptRunRequest req) throws Throwable {
        if (req.getArgs().containsKey("refresh_token")) {
            this.getPayload().putAll((Map)req.getArgs().get("refresh_token"));
        }
        req.getArgs().put("refresh_token", this.getPayload());
    }

    @Override
    public void handleResponse(ScriptRunResponse resp) throws Throwable {
        super.handleResponse(resp);
        switch (resp.getReturnCode()) {
            case 1: {
                this.setRTData((JSONObject)resp.getReturnedValues().get("refresh_token"));
                return;
            }
            case 0: {
                return;
            }
        }
    }

    public void checkClaims() throws Throwable {
    }

    public List<ClaimSource> getSources() throws Throwable {
        return new ArrayList<ClaimSource>();
    }

    public void finish(String execPhase) throws Throwable {
        TXRecord txRecord;
        if (this.transaction.getRefreshTokenLifetime() == 0L) {
            throw new IllegalStateException("refresh lifetime disabled for this client");
        }
        JSONObject rtData = this.getPayload();
        if (this.transaction.getRefreshToken() != null) {
            rtData.put((Object)"jti", (Object)this.transaction.getRefreshToken().getToken());
        }
        if (this.hasTXRecord() && "urn:ietf:params:oauth:token-type:refresh_token".equals((txRecord = this.getTXRecord()).getTokenType())) {
            rtData.put((Object)"jti", (Object)txRecord.getIdentifierString());
        }
        this.refreshAccountingInformation();
        this.doServerVariables(rtData, null);
    }

    @Override
    public void saveState(String execPhase) throws Throwable {
        if (execPhase.equals("post_auth")) {
            this.transaction.setRTData(this.getPayload());
            this.transaction.setRefreshTokenLifetime(this.getPayload().getLong("exp") * 1000L);
        }
        super.saveState(execPhase);
    }

    protected RefreshTokenConfig getRTConfig() {
        return (RefreshTokenConfig)this.getPhCfg().getClientConfig();
    }

    public void setAccountingInformation() {
        JSONObject rtData = this.getPayload();
        if (!StringUtils.isTrivial((String)this.getRTConfig().getIssuer())) {
            rtData.put((Object)"iss", (Object)this.getRTConfig().getIssuer());
        }
        if (this.getRTConfig().getAudience() != null && !this.getRTConfig().getAudience().isEmpty()) {
            rtData.put((Object)"aud", (Object)this.listToString(this.getRTConfig().getAudience()));
        }
        if (this.getRTConfig().getResource() != null && !this.getRTConfig().getResource().isEmpty()) {
            rtData.put((Object)"resource", (Object)this.listToString(this.getRTConfig().getResource()));
        }
        if (this.transaction.getRefreshToken() != null) {
            rtData.put((Object)"jti", (Object)this.transaction.getRefreshToken().getToken());
        }
        this.refreshAccountingInformation();
    }

    public void refreshAccountingInformation() {
        JSONObject rtData = this.getPayload();
        long lifetime = ClientUtils.computeRefreshLifetime(this.transaction, this.client, this.oa2se);
        long issuedAt = System.currentTimeMillis();
        long expiresAt = issuedAt + lifetime;
        rtData.put((Object)"exp", (Object)(expiresAt / 1000L));
        rtData.put((Object)"nbf", (Object)((issuedAt - 5000L) / 1000L));
        rtData.put((Object)"iat", (Object)(issuedAt / 1000L));
        if (this.hasTXRecord()) {
            this.getTXRecord().setLifetime(lifetime);
            this.getTXRecord().setExpiresAt(expiresAt);
            this.getTXRecord().setIssuedAt(issuedAt);
        }
    }
}

