/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.tokens;

import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.util.configuration.TemplateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.oa4mp.server.loader.oauth2.claims.Groups;
import org.oa4mp.server.loader.oauth2.tokens.AuthorizationPath;
import org.oa4mp.server.loader.oauth2.tokens.AuthorizationTemplate;
import org.oa4mp.server.loader.oauth2.tokens.AuthorizationTemplates;

public class OldTemplateResolver {
    String username = null;
    Groups group = null;
    public static final String ST_GROUP_NAME = "group";
    public static final String ST_USER_NAME = "user";

    public List<String> resolve(AuthorizationTemplates authorizationTemplates, String audience, Collection<String> scopes) {
        LinkedList<String> returnedScopes = new LinkedList<String>();
        for (String key : authorizationTemplates.keySet()) {
            if (!this.check(key, audience)) continue;
            for (String scope : scopes) {
                String[] parts = scope.split(":");
                if (1 == parts.length) {
                    ServletDebugUtil.trace((Object)this, (String)("No operation found for scope request \"" + scope + "\", with audience = \"" + audience + "\""));
                    return returnedScopes;
                }
                String operation = parts[0];
                String path = parts[1];
                AuthorizationTemplate authorizationTemplate = (AuthorizationTemplate)authorizationTemplates.get(key);
                for (AuthorizationPath authorizationPath : authorizationTemplate.getPaths()) {
                    if (!authorizationPath.isExtensible() || !operation.equals(authorizationPath.operation) || !this.check(authorizationPath.path, path)) continue;
                    returnedScopes.add(operation + ":" + path);
                }
            }
        }
        return returnedScopes;
    }

    public OldTemplateResolver(String username, Groups group) {
        this.group = group;
        this.username = username;
    }

    protected boolean hasGroups() {
        return this.group != null && !this.group.isEmpty();
    }

    protected boolean hasUsername() {
        return this.username != null;
    }

    public boolean check(String template, String target) {
        DebugUtil.trace((Object)this, (String)("testing " + target + " against template " + template));
        ArrayList<String> tests = new ArrayList<String>();
        boolean un = template.contains("${user}");
        if (template.contains("${group}")) {
            if (this.hasGroups()) {
                for (String key : this.group.keySet()) {
                    HashMap<String, String> group = new HashMap<String, String>();
                    group.put(ST_GROUP_NAME, key);
                    if (this.hasUsername() && un) {
                        group.put(ST_USER_NAME, this.username);
                    }
                    String replacedString = TemplateUtil.replaceAll((String)template, group);
                    DebugUtil.trace((Object)this, (String)(template + " --> " + replacedString));
                    tests.add(replacedString);
                }
            }
        } else if (un) {
            HashMap<String, String> group = new HashMap<String, String>();
            group.put(ST_USER_NAME, this.username);
            tests.add(TemplateUtil.replaceAll((String)template, group));
        } else {
            tests.add(template);
        }
        for (String template1 : tests) {
            DebugUtil.trace((Object)this, (String)("   testing: " + template1 + ", username = " + this.username));
            if (template1.endsWith("/**")) {
                String noStars = null;
                Object r = target.toString();
                if (!((String)r).endsWith("/")) {
                    r = (String)r + "/";
                }
                if (!((String)r).startsWith(noStars = template1.substring(0, template1.length() - 2))) continue;
                DebugUtil.trace((Object)this, (String)("   testing: returning " + target));
                return true;
            }
            if (!template1.equals(target.toString())) continue;
            DebugUtil.trace((Object)this, (String)("   testing: returning " + target));
            return true;
        }
        System.err.println("   testing: returning false");
        return false;
    }
}

