/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.tokens;

import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.server.server.RFC9068Constants;
import org.oa4mp.server.loader.oauth2.claims.AbstractAccessTokenHandler;
import org.oa4mp.server.loader.oauth2.claims.PayloadHandlerConfigImpl;

public class RFC9068ATHandler
extends AbstractAccessTokenHandler
implements RFC9068Constants {
    public RFC9068ATHandler(PayloadHandlerConfigImpl payloadHandlerConfig) {
        super(payloadHandlerConfig);
    }

    @Override
    public void init() throws Throwable {
        super.init();
        JSONObject accessToken = this.getPayload();
        accessToken.put((Object)"sub", (Object)this.transaction.getUsername());
        accessToken.put((Object)"client_id", (Object)this.transaction.getOA2Client().getIdentifierString());
        if (this.getUserMetaData().containsKey((Object)"acr")) {
            accessToken.put((Object)"acr", this.getUserMetaData().get("acr"));
        }
        if (this.getUserMetaData().containsKey((Object)"amr")) {
            accessToken.put((Object)"amr", this.getUserMetaData().get("amr"));
        }
        if (this.transaction.getAuthTime() != null) {
            accessToken.put((Object)"auth_time", (Object)(this.transaction.getAuthTime().getTime() / 1000L));
        }
        if (!accessToken.containsKey((Object)"aud")) {
            accessToken.put((Object)"aud", (Object)this.transaction.getClient().getIdentifierString());
        }
        this.transaction.setATData(accessToken);
    }

    @Override
    public void setAccountingInformation() {
        super.setAccountingInformation();
        if (this.transaction.hasResource() && !this.transaction.getResource().isEmpty()) {
            if (this.transaction.getResource().size() == 1) {
                this.getPayload().put((Object)"aud", (Object)this.transaction.getResource().get(0));
            } else {
                JSONArray array = new JSONArray();
                array.addAll(this.transaction.getResource());
                this.getPayload().put((Object)"aud", (Object)array);
            }
        }
    }

    @Override
    public AccessTokenImpl getSignedPayload(JSONWebKey key) {
        return this.getSignedPayload(key, "at+jwt");
    }
}

