/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.tokens;

import javax.servlet.http.HttpServletRequest;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.server.loader.oauth2.servlet.OA2HeaderUtils;

public class UITokenUtils {
    public static AccessTokenImpl getAT(String rawAT) {
        return TokenFactory.createAT((String)rawAT);
    }

    public static RefreshTokenImpl getRT(String rawRT) {
        return TokenFactory.createRT((String)rawRT);
    }

    public static String getRawAT(HttpServletRequest request) {
        String headerAT = OA2HeaderUtils.getBearerAuthHeader((HttpServletRequest)request);
        String paramAT = request.getParameter("access_token");
        if (headerAT == null && paramAT == null) {
            throw new OA2GeneralError("invalid_request", "missing access token", 400, null);
        }
        return headerAT == null ? paramAT : headerAT;
    }
}

