/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.tokens;

import edu.uiuc.ncsa.security.core.util.StringUtils;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.OA2ATException;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.loader.oauth2.claims.AbstractAccessTokenHandler;
import org.oa4mp.server.loader.oauth2.claims.PayloadHandlerConfigImpl;
import org.oa4mp.server.loader.oauth2.tokens.WLCGConstants;

public class WLCGTokenHandler
extends AbstractAccessTokenHandler
implements WLCGConstants {
    public static String DEFAULT_AUDIENCE = "https://unknown.org";

    public WLCGTokenHandler(PayloadHandlerConfigImpl cfg) {
        super(cfg);
        OA4MPServlet.createDebugger((BaseClient)cfg.getTransaction().getClient()).trace((Object)this, "Created WLCG handler with transaction " + cfg.getTransaction().summary());
    }

    @Override
    public void setAccountingInformation() {
        super.setAccountingInformation();
        JSONObject atData = this.getPayload();
        atData.put((Object)"wlcg.ver", (Object)"1.0");
        if (this.transaction.getUserMetaData() != null && this.transaction.getUserMetaData().containsKey((Object)"eppn") && !atData.containsKey((Object)"sub")) {
            atData.put((Object)"sub", (Object)this.transaction.getUserMetaData().getString("eppn"));
        }
        if (this.getUserMetaData().containsKey((Object)"acr")) {
            atData.put((Object)"acr", this.getUserMetaData().get("acr"));
        }
        if (!atData.containsKey((Object)"auth_time")) {
            atData.put((Object)"auth_time", (Object)(this.transaction.getAuthTime().getTime() / 1000L));
        }
        if (this.getUserMetaData().containsKey((Object)"eduperson_assurance")) {
            atData.put((Object)"eduperson_assurance", this.getUserMetaData().get("eduperson_assurance"));
        }
        if (this.getATConfig().getAudience().isEmpty()) {
            if (!atData.containsKey((Object)"aud")) {
                atData.put((Object)"aud", (Object)DEFAULT_AUDIENCE);
            }
        } else {
            Object a = "";
            for (String x : this.getATConfig().getAudience()) {
                a = (String)a + " " + x;
            }
            a = ((String)a).trim();
            atData.put((Object)"aud", a);
        }
        this.transaction.setATData(atData);
    }

    @Override
    public void finish(boolean doTemplates, boolean isQuery) throws Throwable {
        JSONObject atData = this.getPayload();
        super.finish(doTemplates, isQuery);
        if (!atData.containsKey((Object)"scope") || StringUtils.isTrivial((String)atData.getString("scope"))) {
            throw new OA2ATException("access_denied", "No WLCG scopes found.", this.transaction.getRequestState(), (BaseClient)this.transaction.getClient());
        }
    }
}

