/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.acl;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.server.loader.qdl.scripting.OA2State;
import org.qdl_lang.exceptions.BadArgException;
import org.qdl_lang.exceptions.QDLIllegalAccessException;
import org.qdl_lang.extensions.QDLFunction;
import org.qdl_lang.extensions.QDLMetaModule;
import org.qdl_lang.state.State;
import org.qdl_lang.variables.values.BooleanValue;
import org.qdl_lang.variables.values.QDLValue;

public class QDLACL
implements QDLMetaModule {
    TreeSet<String> whiteList = null;
    TreeSet<String> blackList = null;
    public static String ACL_REJECT_NAME = "acl_blacklist";
    public static String ADD_TO_ACL_NAME = "acl_add";
    public static String CHECK_ACL_NAME = "acl_check";
    public static Identifier ACL_ACCEPT_ALL = BasicIdentifier.newID((String)"*");

    public TreeSet<String> getWhiteList() {
        if (this.whiteList == null) {
            this.whiteList = new TreeSet();
        }
        return this.whiteList;
    }

    public void setWhiteList(TreeSet<String> whiteList) {
        this.whiteList = whiteList;
    }

    public TreeSet<String> getBlackList() {
        if (this.blackList == null) {
            this.blackList = new TreeSet();
        }
        return this.blackList;
    }

    public void setBlackList(TreeSet<String> blackList) {
        this.blackList = blackList;
    }

    public boolean hasWhiteList() {
        return this.whiteList != null;
    }

    public boolean hasBlackList() {
        return this.blackList != null;
    }

    protected Boolean acceptOrReject(QDLValue[] qdlValues, State state, String name, boolean accept) {
        JSONArray ids;
        if (!(state instanceof OA2State)) {
            throw new IllegalArgumentException("Error: ACLs not supported in this environment.");
        }
        OA2State oa2State = (OA2State)state;
        if (qdlValues.length == 0) {
            throw new IllegalArgumentException("Error: " + name + " requires an argument");
        }
        switch (qdlValues[0].getType()) {
            case 4: {
                ids = qdlValues[0].asStem().getQDLList().toJSON();
                break;
            }
            case 3: {
                ids = new ArrayList();
                ids.add(qdlValues[0].asString());
                break;
            }
            default: {
                throw new BadArgException("Error: " + name + " requires a string or stem as its argument", 0);
            }
        }
        boolean failOnBadIds = false;
        if (qdlValues.length == 2) {
            if (!qdlValues[1].isBoolean()) {
                throw new BadArgException("Error: " + name + " requires a boolean as its second argument", 1);
            }
            failOnBadIds = qdlValues[1].asBoolean();
        }
        ArrayList<String> badIds = new ArrayList<String>();
        for (Object id : ids) {
            Identifier identifier;
            if (!(id instanceof String)) {
                throw new IllegalArgumentException("Error: '" + String.valueOf(id) + "' is not a valid identifier");
            }
            try {
                URI uri = URI.create((String)id);
                identifier = BasicIdentifier.newID((URI)uri);
            }
            catch (Throwable t) {
                if (failOnBadIds) {
                    throw new IllegalArgumentException("Error: " + name + " requires a valid identifier");
                }
                badIds.add(id.toString());
                continue;
            }
            boolean isClientID = oa2State.getOa2se().getClientStore().containsKey((Object)identifier);
            boolean isAdminID = oa2State.getOa2se().getAdminClientStore().containsKey((Object)identifier);
            if (isAdminID && isClientID) {
                throw new NFWException("Error: There is a regular client and an admin client with the same id '" + identifier.toString() + "'");
            }
            if (!isAdminID && !isClientID) {
                if (failOnBadIds) {
                    throw new QDLIllegalAccessException(" There is a no such client with id '" + identifier.toString() + "'. Access denied.");
                }
                badIds.add(identifier.toString());
            }
            if (accept) {
                this.getWhiteList().add(identifier.toString());
                continue;
            }
            this.getBlackList().add(identifier.toString());
        }
        if (0 < badIds.size()) {
            StringBuilder sb = new StringBuilder(badIds.size() + 2);
            sb.append("[");
            boolean firstLoop = true;
            for (String s : badIds) {
                if (firstLoop) {
                    firstLoop = false;
                    sb.append(s);
                    continue;
                }
                sb.append(", " + s);
            }
            sb.append("]");
            oa2State.getOa2se().getMyLogger().warn("failed to add the following IDs to the ACLs :" + String.valueOf(sb));
        }
        return Boolean.TRUE;
    }

    public JSONObject serializeToJSON() {
        JSONArray array;
        JSONObject json = new JSONObject();
        if (this.hasBlackList()) {
            array = new JSONArray();
            array.addAll(this.getBlackList());
            json.put((Object)"blacklist", (Object)array);
        }
        if (this.hasWhiteList()) {
            array = new JSONArray();
            array.addAll(this.getWhiteList());
            json.put((Object)"whitelist", (Object)array);
        }
        return json;
    }

    public void deserializeFromJSON(JSONObject jsonObject) {
        if (jsonObject.has("blacklist")) {
            this.getBlackList().addAll((Collection<String>)jsonObject.getJSONArray("blacklist"));
        }
        if (jsonObject.has("whitelist")) {
            this.getWhiteList().addAll((Collection<String>)jsonObject.getJSONArray("whitelist"));
        }
    }

    public class CheckACL2
    extends CheckACL {
        @Override
        public String getName() {
            return "check";
        }
    }

    public class CheckACL
    implements QDLFunction {
        public String getName() {
            return CHECK_ACL_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (!(state instanceof OA2State)) {
                throw new IllegalArgumentException(" This requires an OA2State object.");
            }
            OA2State oa2State = (OA2State)state;
            if (!oa2State.getAclBlackList().isEmpty()) {
                for (Identifier id : oa2State.getAclBlackList()) {
                    QDLACL.this.getBlackList().add(id.toString());
                }
            }
            if (!oa2State.getAclList().isEmpty()) {
                for (Identifier id : oa2State.getAclList()) {
                    QDLACL.this.getWhiteList().add(id.toString());
                }
            }
            if (QDLACL.this.getBlackList().contains(oa2State.getClientID().toString())) {
                throw new QDLIllegalAccessException(" client '" + String.valueOf(oa2State.getClientID()) + "' does not have permission to access this resource.");
            }
            for (Identifier adminID : oa2State.getAdminIDs()) {
                if (!QDLACL.this.getBlackList().contains(adminID.toString())) continue;
                throw new QDLIllegalAccessException(" admin '" + String.valueOf(adminID) + "' does not have permission to access this resource.");
            }
            if (QDLACL.this.getWhiteList().isEmpty()) {
                if (oa2State.isStrictACLs()) {
                    throw new QDLIllegalAccessException(" client '" + String.valueOf(oa2State.getClientID()) + "' does not have permission to access this resource.");
                }
                return BooleanValue.False;
            }
            if (QDLACL.this.getWhiteList().contains(ACL_ACCEPT_ALL.toString())) {
                return BooleanValue.True;
            }
            if (QDLACL.this.getWhiteList().contains(oa2State.getClientID().toString())) {
                return BooleanValue.True;
            }
            for (Identifier adminID : oa2State.getAdminIDs()) {
                if (!QDLACL.this.getWhiteList().contains(adminID.toString())) continue;
                return BooleanValue.True;
            }
            throw new QDLIllegalAccessException("Error: client '" + String.valueOf(oa2State.getClientID()) + "' does not have permission to access this resource.");
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + " check the current access list. If there is no such entry, an illegal access is triggered.");
            doxx.add("See also: " + ADD_TO_ACL_NAME);
            return doxx;
        }
    }

    public class AddToACL2
    extends AddToACL {
        @Override
        public String getName() {
            return "add";
        }
    }

    public class AddToACL
    implements QDLFunction {
        public String getName() {
            return ADD_TO_ACL_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            return QDLValue.asQDLValue((Object)QDLACL.this.acceptOrReject(objects, state, this.getName(), true));
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(id | id.{,fail_on_bad_ids}) add to the access control list for this object");
            if (argCount == 1) {
                doxx.add("Accepts either a string or a list of them.");
                doxx.add("if fail_on_bad_ids is true, then check each id to ensure it is valid and if not, throw an  exception.");
                doxx.add("   fail_on_bad_ids default is false.");
                doxx.add("This sets the admin_id or client_id. If an admin id, then any client has access ");
                doxx.add("to this object. If a client id, then precisely that client is allowed");
            }
            return doxx;
        }
    }

    public class ACLReject2
    extends ACLReject {
        @Override
        public String getName() {
            return "blacklist";
        }
    }

    public class ACLReject
    implements QDLFunction {
        public String getName() {
            return ACL_REJECT_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            QDLACL.this.acceptOrReject(objects, state, this.getName(), false);
            return null;
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<Object> doxx = new ArrayList<Object>();
            doxx.add(this.getName() + "(id | id.{,fail_on_bad_ids}) block access for this object or objects, AKA blacklist them.");
            doxx.add("if fail_on_bad_ids is true, then check each id to ensure it is valid and if not, throw an  exception.");
            doxx.add("   fail_on_bad_ids default is false.");
            return null;
        }
    }
}

