/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.claims;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.oa4mp.server.loader.oauth2.claims.AbstractAccessTokenHandler;
import org.oa4mp.server.loader.oauth2.claims.AbstractPayloadConfig;
import org.oa4mp.server.loader.oauth2.tokens.RFC9068ATHandler;
import org.oa4mp.server.loader.oauth2.tokens.ScitokenHandler;
import org.oa4mp.server.loader.oauth2.tokens.WLCGTokenHandler;
import org.oa4mp.server.loader.qdl.claims.TokenHandlerMethod;
import org.oa4mp.server.loader.qdl.scripting.OA2State;
import org.qdl_lang.exceptions.BadArgException;
import org.qdl_lang.extensions.QDLMetaModule;
import org.qdl_lang.state.State;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.values.QDLValue;

public class AccessTokenInitializer
implements QDLMetaModule {
    public static String AT_INIT_METHOD = "at_init";
    public static String AT_FINISH_METHOD = "at_finish";
    public static String AT_REFRESH_METHOD = "at_refresh";
    AbstractAccessTokenHandler atHandler;

    public AbstractAccessTokenHandler getAtHandler() {
        return this.atHandler;
    }

    public JSONObject serializeToJSON() {
        return null;
    }

    public void deserializeFromJSON(JSONObject jsonObject) {
    }

    public class atFinish
    extends ATMethod {
        public atFinish(OA2State oa2State) {
            super(oa2State);
        }

        public String getName() {
            return AT_FINISH_METHOD;
        }

        public int[] getArgCount() {
            return new int[]{2, 3};
        }

        @Override
        protected void doMethod() throws Throwable {
        }

        @Override
        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (objects.length != this.getArgCount()[0] && objects.length != this.getArgCount()[1]) {
                throw new IllegalArgumentException(this.getName() + " requires 2 or 3  arguments and you supplied " + objects.length);
            }
            this.oa2State = this.checkState(state);
            this.setupHandler(objects);
            QDLStem at = this.checkArg(objects, this.getName(), 1);
            QDLStem output = new QDLStem();
            Boolean doTemplates = Boolean.TRUE;
            Boolean isQuery = Boolean.FALSE;
            if (objects.length == 3) {
                if (objects[2].isBoolean()) {
                    doTemplates = objects[2].asBoolean();
                } else {
                    throw new BadArgException(" the third argument must be a boolean", 2);
                }
            }
            if (objects.length == 4) {
                if (objects[3].isBoolean()) {
                    isQuery = objects[3].asBoolean();
                } else {
                    throw new IllegalArgumentException("Error: the fourth argument must be a boolean");
                }
            }
            AccessTokenInitializer.this.getAtHandler().setPayload((JSONObject)at.toJSON());
            try {
                AccessTokenInitializer.this.getAtHandler().finish(doTemplates, isQuery);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
            output.fromJSON(AccessTokenInitializer.this.getAtHandler().getPayload());
            return QDLValue.asQDLValue((Object)output);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            switch (argCount) {
                case 2: {
                    doxx.add(this.getName() + "(type,  access_token.) - finish the creation of the token. ");
                    break;
                }
                case 3: {
                    doxx.add(this.getName() + "(type,  access_token., do_templates) - finish the creation of the token. ");
                    break;
                }
                case 4: {
                    doxx.add(this.getName() + "(type,  access_token., do_templates, is_query) - finish the creation of the token.");
                    doxx.add("is_query - treat the request as a query for available scopes. Default is false.");
                    break;
                }
                default: {
                    return doxx;
                }
            }
            this.addTypeDoc(doxx);
            doxx.add("access_token. - the stem that contains the claims for this token.");
            if (argCount == 3) {
                doxx.add("doTemplates - if there are templates in the configuration, run those if this is true.");
            }
            doxx.add("See also: " + AT_INIT_METHOD);
            return doxx;
        }
    }

    public class atRefresh
    extends ATMethod {
        public atRefresh(OA2State oa2State) {
            super(oa2State);
        }

        @Override
        protected void doMethod() throws Throwable {
            AccessTokenInitializer.this.getAtHandler().refresh();
        }

        public String getName() {
            return AT_REFRESH_METHOD;
        }

        public int[] getArgCount() {
            return new int[]{2};
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            if (argCount == 2) {
                doxx.add(this.getName() + "(type, access_token.) - refresh the access token with any specific information it requires.");
                this.addTypeDoc(doxx);
                doxx.add("You would call this in refresh phase.");
                doxx.add("See also: " + AT_INIT_METHOD + ", " + AT_FINISH_METHOD);
            }
            return doxx;
        }
    }

    public class atInit
    extends ATMethod {
        public atInit(OA2State oa2State) {
            super(oa2State);
        }

        public String getName() {
            return AT_INIT_METHOD;
        }

        public int[] getArgCount() {
            return new int[]{2};
        }

        @Override
        protected void doMethod() throws Throwable {
            AccessTokenInitializer.this.getAtHandler().init();
            this.isInit = true;
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            if (argCount == 2) {
                doxx.add(this.getName() + "(type, access_token.) - initialize an access token.");
                this.addTypeDoc(doxx);
                doxx.add("Every access token type has a specific set of required claims that it must contain.");
                doxx.add("the second argument is a stem of claims of whatever you want. This adds the accounting information to that stem, ");
                doxx.add("and returns a new stem of the result.");
                doxx.add("See also: " + AT_FINISH_METHOD);
            }
            return doxx;
        }
    }

    public abstract class ATMethod
    extends TokenHandlerMethod {
        public ATMethod(OA2State oa2State) {
            super(oa2State);
        }

        @Override
        public QDLValue evaluate(QDLValue[] objects, State state) {
            super.evaluate(objects, state);
            QDLStem at = this.checkArg(objects, this.getName(), 1);
            this.setupHandler(objects);
            JSONObject j = (JSONObject)at.toJSON();
            AccessTokenInitializer.this.getAtHandler().setPayload(new JSONObject());
            try {
                this.doMethod();
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
            QDLStem newAT = new QDLStem();
            JSONObject newToken = AccessTokenInitializer.this.getAtHandler().getPayload();
            newToken.putAll((Map)j);
            AccessTokenInitializer.this.getAtHandler().setPayload(newToken);
            newAT.fromJSON(newToken);
            return QDLValue.asQDLValue((Object)newAT);
        }

        protected void setupHandler(Object[] objects) {
            String type;
            if (!(objects[0] instanceof String)) {
                throw new IllegalArgumentException(" You must supply the type of the token.");
            }
            switch (type = (String)objects[0]) {
                case "wlcg": {
                    AccessTokenInitializer.this.atHandler = new WLCGTokenHandler(this.getPayloadHandlerConfig());
                    break;
                }
                case "sci_token": 
                case "scitoken": {
                    AccessTokenInitializer.this.atHandler = new ScitokenHandler(this.getPayloadHandlerConfig());
                    break;
                }
                case "rfc9068": 
                case "rfc_9068": {
                    AccessTokenInitializer.this.atHandler = new RFC9068ATHandler(this.getPayloadHandlerConfig());
                    break;
                }
                case "default": {
                    AccessTokenInitializer.this.atHandler = new AbstractAccessTokenHandler(this.getPayloadHandlerConfig());
                }
                default: {
                    throw new IllegalArgumentException("Unknown token type.");
                }
            }
        }

        protected abstract void doMethod() throws Throwable;

        @Override
        protected AbstractPayloadConfig getPayloadConfig() {
            return this.getClient().getAccessTokensConfig();
        }

        protected void addTypeDoc(List<String> doxx) {
            doxx.add("type - one of 'wlcg or sci_token that determines the type of token.");
        }
    }
}

