/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.claims;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.server.server.claims.ClaimSource;
import org.oa4mp.delegation.server.server.claims.ClaimSourceConfiguration;
import org.oa4mp.delegation.server.server.config.LDAPConfiguration;
import org.oa4mp.delegation.server.server.config.LDAPConfigurationUtil;
import org.oa4mp.server.loader.oauth2.claims.BasicClaimsSourceImpl;
import org.oa4mp.server.loader.oauth2.claims.FSClaimSource;
import org.oa4mp.server.loader.qdl.claims.CSConstants;
import org.qdl_lang.variables.QDLSet;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;

public class ClaimSourceConfigConverter
implements CSConstants {
    public static QDLStem convert(ClaimSource claimsSource, String type) {
        QDLStem stem = new QDLStem();
        ClaimSourceConfiguration cfg = claimsSource.getConfiguration();
        ClaimSourceConfigConverter.setDefaultsInStem(cfg, stem);
        StemUtility.put((QDLStem)stem, (Object)"type", (Object)type);
        LDAPConfiguration cfg2 = null;
        switch (type) {
            case "code": {
                if (!(claimsSource instanceof BasicClaimsSourceImpl)) {
                    throw new IllegalArgumentException(" Custom code must extend BasicClaimSourceImpl. The class \"" + claimsSource.getClass().getCanonicalName() + "\" does not.");
                }
                BasicClaimsSourceImpl basicClaimsSource = (BasicClaimsSourceImpl)claimsSource;
                if (cfg.getProperty("java_class") == null) {
                    throw new IllegalStateException("Error: No java class has been set for a custom claim source.");
                }
                for (String key : cfg.getProperties().keySet()) {
                    StemUtility.put((QDLStem)stem, (Object)key, (Object)cfg.getProperty(key));
                }
                break;
            }
            case "file": {
                FSClaimSource fsClaimSource = (FSClaimSource)claimsSource;
                StemUtility.put((QDLStem)stem, (Object)"file_path", (Object)cfg.getProperty(FSClaimSource.FILE_PATH_KEY));
                if (cfg.getProperty(FSClaimSource.FILE_CLAIM_KEY) != null) {
                    StemUtility.put((QDLStem)stem, (Object)"claim_key", (Object)cfg.getProperty(FSClaimSource.FILE_CLAIM_KEY));
                }
                StemUtility.put((QDLStem)stem, (Object)"use_default", (Object)fsClaimSource.isUseDefaultClaims());
                if (fsClaimSource.getDefaultClaimName() == null) break;
                StemUtility.put((QDLStem)stem, (Object)"default_claim", (Object)fsClaimSource.getDefaultClaimName());
                break;
            }
            case "filter": {
                if (cfg.getProperty("prefix") == null) break;
                StemUtility.put((QDLStem)stem, (Object)"prefix", (Object)cfg.getProperty("prefix"));
                break;
            }
            case "header": {
                if (cfg.getProperty("prefix") != null) {
                    StemUtility.put((QDLStem)stem, (Object)"prefix", (Object)cfg.getProperty("prefix"));
                }
                if (cfg.getProperty("regex") == null) break;
                StemUtility.put((QDLStem)stem, (Object)"regex", (Object)cfg.getProperty("regex"));
                break;
            }
            case "ncsa": {
                cfg2 = (LDAPConfiguration)claimsSource.getConfiguration();
                StemUtility.put((QDLStem)stem, (Object)"ldap_name", (Object)cfg2.getSearchFilterAttribute());
                break;
            }
            case "ldap": {
                LDAPConfigurationUtil cUtil = new LDAPConfigurationUtil();
                cfg2 = (LDAPConfiguration)claimsSource.getConfiguration();
                StemUtility.put((QDLStem)stem, (Object)"claim_name", (Object)cfg2.getSearchNameKey());
                StemUtility.put((QDLStem)stem, (Object)"address", (Object)cfg2.getServer());
                StemUtility.put((QDLStem)stem, (Object)"search_base", (Object)cfg2.getSearchBase());
                StemUtility.put((QDLStem)stem, (Object)"context", (Object)cfg2.getContextName());
                StemUtility.put((QDLStem)stem, (Object)"filter", (Object)cfg2.getAdditionalFilter());
                StemUtility.put((QDLStem)stem, (Object)"port", (Object)new Long(cfg2.getPort()));
                StemUtility.put((QDLStem)stem, (Object)"auth_type", (Object)cUtil.getAuthName(cfg2.getAuthType()));
                StemUtility.put((QDLStem)stem, (Object)"ldap_name", (Object)cfg2.getSearchFilterAttribute());
                if (cfg2.hasSearchScope()) {
                    StemUtility.put((QDLStem)stem, (Object)"search_scope", (Object)cfg2.getSearchScope());
                }
                if (cfg2.getAuthType() == 10) {
                    StemUtility.put((QDLStem)stem, (Object)"password", (Object)cfg2.getPassword());
                    StemUtility.put((QDLStem)stem, (Object)"username", (Object)cfg2.getSecurityPrincipal());
                }
                if (cfg2.getSearchAttributes() == null || cfg2.getSearchAttributes().isEmpty()) break;
                ArrayList<String> groups = new ArrayList<String>();
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<String> isList = new ArrayList<String>();
                QDLStem renames = new QDLStem();
                for (String key : cfg2.getSearchAttributes().keySet()) {
                    LDAPConfigurationUtil.AttributeEntry attributeEntry = (LDAPConfigurationUtil.AttributeEntry)cfg2.getSearchAttributes().get(key);
                    names.add(attributeEntry.sourceName);
                    if (attributeEntry.targetName != null && !attributeEntry.targetName.equals(attributeEntry.sourceName)) {
                        StemUtility.put((QDLStem)renames, (Object)attributeEntry.sourceName, (Object)attributeEntry.targetName);
                    }
                    if (attributeEntry.isGroup) {
                        groups.add(attributeEntry.sourceName);
                    }
                    if (attributeEntry.isList) {
                        isList.add(attributeEntry.sourceName);
                    }
                    QDLStem nameStem = new QDLStem();
                    nameStem.addList(names);
                    StemUtility.put((QDLStem)stem, (Object)"search_attributes", (Object)nameStem);
                    if (groups.size() != 0) {
                        QDLStem groupStem = new QDLStem();
                        groupStem.addList(groups);
                        StemUtility.put((QDLStem)stem, (Object)"groups", (Object)groupStem);
                    }
                    if (isList.size() != 0) {
                        QDLStem listStem = new QDLStem();
                        listStem.addList(isList);
                        StemUtility.put((QDLStem)stem, (Object)"lists", (Object)listStem);
                    }
                    if (renames.size() == 0) continue;
                    StemUtility.put((QDLStem)stem, (Object)"rename", (Object)renames);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Error: Unknown source type");
            }
        }
        return stem;
    }

    public static ClaimSourceConfiguration convert(QDLStem arg) {
        ClaimSourceConfiguration cfg = null;
        HashMap<String, Object> xp = new HashMap<String, Object>();
        switch (arg.getString("type")) {
            case "code": {
                cfg = new ClaimSourceConfiguration();
                cfg.setProperties((Map)((JSONObject)arg.toJSON()));
                return cfg;
            }
            case "file": {
                cfg = new ClaimSourceConfiguration();
                ClaimSourceConfigConverter.setDefaultsinCfg(arg, cfg);
                xp.put(FSClaimSource.FILE_PATH_KEY, arg.getString("file_path"));
                if (arg.containsKey((Object)"claim_key")) {
                    xp.put(FSClaimSource.FILE_CLAIM_KEY, arg.getString("claim_key"));
                }
                if (arg.containsKey((Object)"use_default")) {
                    xp.put(FSClaimSource.USE_DEFAULT_KEY, arg.getBoolean("use_default"));
                }
                if (arg.containsKey((Object)"default_claim")) {
                    xp.put(FSClaimSource.DEFAULT_CLAIM_KEY, arg.getString("default_claim"));
                }
                cfg.setProperties(xp);
                return cfg;
            }
            case "ldap": {
                QDLSet groups;
                LDAPConfiguration ldapCfg = new LDAPConfiguration();
                ClaimSourceConfigConverter.setDefaultsinCfg(arg, (ClaimSourceConfiguration)ldapCfg);
                LDAPConfigurationUtil cUtil = new LDAPConfigurationUtil();
                ldapCfg.setSearchNameKey(arg.getString("claim_name"));
                ldapCfg.setServer(arg.getString("address"));
                if (arg.containsKey((Object)"ldap_name")) {
                    ldapCfg.setSearchFilterAttribute(arg.getString("ldap_name"));
                }
                if (arg.containsKey((Object)"search_scope")) {
                    ldapCfg.setSearchScope(arg.getString("search_scope"));
                }
                if (arg.containsKey((Object)"enabled")) {
                    ldapCfg.setEnabled(arg.getBoolean("enabled").booleanValue());
                } else {
                    ldapCfg.setEnabled(true);
                }
                if (arg.containsKey((Object)"filter")) {
                    ldapCfg.setAdditionalFilter(arg.getString("filter"));
                } else {
                    ldapCfg.setAdditionalFilter("");
                }
                if (arg.containsKey((Object)"context")) {
                    ldapCfg.setContextName(arg.getString("context"));
                } else {
                    ldapCfg.setContextName("");
                }
                if (arg.containsKey((Object)"port")) {
                    ldapCfg.setPort(arg.getLong("port").intValue());
                } else {
                    ldapCfg.setPort(636);
                }
                ldapCfg.setAuthType(cUtil.getAuthType(arg.getString("auth_type")));
                if (ldapCfg.getAuthType() == 10) {
                    ldapCfg.setPassword(arg.getString("password"));
                    ldapCfg.setSecurityPrincipal(arg.getString("username"));
                }
                ldapCfg.setSearchBase(arg.getString("search_base"));
                QDLStem renames = null;
                if (arg.containsKey((Object)"rename")) {
                    renames = arg.get("rename").asStem();
                }
                QDLSet lists = null;
                if (arg.containsKey((Object)"lists")) {
                    QDLStem listNames = arg.get("lists").asStem();
                    lists = listNames.values();
                } else {
                    lists = new ArrayList();
                }
                if (arg.containsKey((Object)"groups")) {
                    QDLStem groupStem = arg.get("groups").asStem();
                    groups = groupStem.values();
                } else {
                    groups = new ArrayList();
                }
                if (arg.containsKey((Object)"search_attributes")) {
                    QDLStem searchAttr = arg.get("search_attributes").asStem();
                    HashMap<String, LDAPConfigurationUtil.AttributeEntry> attrs = new HashMap<String, LDAPConfigurationUtil.AttributeEntry>();
                    for (Object key : searchAttr.keySet()) {
                        String attrName = String.valueOf(searchAttr.get(key));
                        boolean isGroup = groups.contains(attrName);
                        boolean isList = lists.contains(attrName);
                        if (isList && isGroup) {
                            throw new IllegalArgumentException("You cannot have a \"" + attrName + "\" be both a group and a list. ");
                        }
                        String rename = attrName;
                        if (renames != null && renames.containsKey((Object)attrName)) {
                            rename = renames.getString(attrName);
                        }
                        LDAPConfigurationUtil.AttributeEntry attributeEntry = new LDAPConfigurationUtil.AttributeEntry(attrName, rename, isList, isGroup);
                        attrs.put(attrName, attributeEntry);
                    }
                    if (!attrs.isEmpty()) {
                        ldapCfg.setSearchAttributes(attrs);
                    }
                }
                return ldapCfg;
            }
            case "filter": {
                cfg = new ClaimSourceConfiguration();
                ClaimSourceConfigConverter.setDefaultsinCfg(arg, cfg);
                if (arg.containsKey((Object)"prefix")) {
                    xp.put("prefix", arg.getString("prefix"));
                }
                cfg.setProperties(xp);
                return cfg;
            }
            case "header": {
                cfg = new ClaimSourceConfiguration();
                ClaimSourceConfigConverter.setDefaultsinCfg(arg, cfg);
                if (arg.containsKey((Object)"prefix")) {
                    xp.put("prefix", arg.getString("prefix"));
                }
                if (arg.containsKey((Object)"regex")) {
                    xp.put("regex", arg.getString("prefix"));
                }
                cfg.setProperties(xp);
                return cfg;
            }
        }
        return null;
    }

    protected static void setDefaultsinCfg(QDLStem arg, ClaimSourceConfiguration cfg) {
        if (arg.containsKey((Object)"id")) {
            cfg.setId(arg.getString("id"));
        }
        if (arg.containsKey((Object)"fail_on_error")) {
            cfg.setFailOnError(arg.getBoolean("fail_on_error").booleanValue());
        }
        if (arg.containsKey((Object)"notify_on_fail")) {
            cfg.setNotifyOnFail(arg.getBoolean("notify_on_fail").booleanValue());
        }
        if (arg.containsKey((Object)"enabled")) {
            cfg.setEnabled(arg.getBoolean("enabled").booleanValue());
        }
        if (arg.containsKey((Object)"name")) {
            cfg.setName(arg.getString("name"));
        }
        if (arg.containsKey((Object)"retry_wait")) {
            cfg.setMaxWait(arg.getLong("retry_wait").longValue());
        }
        if (arg.containsKey((Object)"retry_count")) {
            cfg.setRetryCount(Math.toIntExact(arg.getLong("retry_count")));
        }
    }

    protected static void setDefaultsInStem(ClaimSourceConfiguration cfg, QDLStem arg) {
        StemUtility.put((QDLStem)arg, (Object)"id", (Object)cfg.getId());
        StemUtility.put((QDLStem)arg, (Object)"fail_on_error", (Object)cfg.isFailOnError());
        StemUtility.put((QDLStem)arg, (Object)"enabled", (Object)cfg.isEnabled());
        StemUtility.put((QDLStem)arg, (Object)"notify_on_fail", (Object)cfg.isNotifyOnFail());
        StemUtility.put((QDLStem)arg, (Object)"name", (Object)cfg.getName());
        StemUtility.put((QDLStem)arg, (Object)"retry_count", (Object)cfg.getRetryCount());
        StemUtility.put((QDLStem)arg, (Object)"retry_wait", (Object)cfg.getMaxWait());
    }
}

