/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.claims;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.server.loader.oauth2.claims.BasicClaimsSourceImpl;
import org.oa4mp.server.loader.oauth2.claims.FSClaimSource;
import org.oa4mp.server.loader.oauth2.claims.HTTPHeaderClaimsSource;
import org.oa4mp.server.loader.oauth2.claims.LDAPClaimsSource;
import org.oa4mp.server.loader.oauth2.claims.NCSALDAPClaimSource;
import org.oa4mp.server.loader.oauth2.claims.QDLHeadersClaimsSource;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.qdl.claims.CSConstants;
import org.oa4mp.server.loader.qdl.claims.ConfigtoCS;
import org.oa4mp.server.loader.qdl.claims.CreateSourceConfig;
import org.oa4mp.server.loader.qdl.claims.TestHTTPRequest;
import org.oa4mp.server.loader.qdl.scripting.OA2State;
import org.qdl_lang.exceptions.BadArgException;
import org.qdl_lang.expressions.ConstantNode;
import org.qdl_lang.expressions.Polyad;
import org.qdl_lang.extensions.QDLFunction;
import org.qdl_lang.state.State;
import org.qdl_lang.statements.ExpressionInterface;
import org.qdl_lang.variables.QDLList;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;
import org.qdl_lang.variables.values.LongValue;
import org.qdl_lang.variables.values.QDLKey;
import org.qdl_lang.variables.values.QDLValue;
import org.qdl_lang.variables.values.StringValue;

public class ClaimsSourceGetter
implements QDLFunction,
CSConstants {
    public static final String GET_CLAIMS_NAME = "get_claims";
    ConfigtoCS configtoCS = null;
    static String rawConfig = " {\n        \"ldap\": {\n          \"id\": \"ncsa-default\",\n          \"name\": \"ncsa-default\",\n          \"address\": \"ldap1.ncsa.illinois.edu,ldap2.ncsa.illinois.edu\",\n          \"port\": 636,\n          \"enabled\": true,\n          \"authorizationType\": \"none\",\n          \"failOnError\": false,\n          \"notifyOnFail\": false,\n          \"searchAttributes\": [\n            {\n              \"name\": \"mail\",\n              \"returnAsList\": false,\n              \"returnName\": \"email\"\n            },\n            {\n              \"name\": \"cn\",\n              \"returnAsList\": false,\n              \"returnName\": \"name\"\n            },\n            {\n              \"name\": \"uidNumber\",\n              \"returnAsList\": false,\n              \"returnName\": \"uidNumber\"\n            },\n            {\n              \"name\": \"uid\",\n              \"returnAsList\": false,\n              \"returnName\": \"uid\"\n            },\n            {\n              \"name\": \"memberOf\",\n              \"IsInGroup\": true,\n              \"returnAsList\": false,\n              \"returnName\": \"isMemberOf\"\n            }\n          ],\n          \"searchBase\": \"ou=People,dc=ncsa,dc=illinois,dc=edu\",\n          \"searchName\": \"uid\",\n          \"searchFilterAttribute\": \"uid\",\n          \"contextName\": \"\",\n          \"ssl\": {\n            \"keystore\": {},\n            \"tlsVersion\": \"TLS\",\n            \"useJavaTrustStore\": true,\n          }\n        }\n      }";

    public String getName() {
        return GET_CLAIMS_NAME;
    }

    public int[] getArgCount() {
        return new int[]{2};
    }

    protected ConfigtoCS getConfigToCS() {
        if (this.configtoCS == null) {
            this.configtoCS = new ConfigtoCS();
        }
        return this.configtoCS;
    }

    public QDLValue evaluate(QDLValue[] objects, State state) {
        if (!objects[0].isStem()) {
            throw new BadArgException(this.getName() + " requires a stem variable as its first argument", 0);
        }
        QDLStem arg = objects[0].asStem();
        if (objects[1] == null || !objects[1].isString()) {
            throw new BadArgException(this.getName() + " requires the name of the user as its second argument", 1);
        }
        String username = objects[1].asString();
        if (!arg.containsKey((Object)"type")) {
            throw new IllegalStateException(this.getName() + " must have the type of claim source");
        }
        QDLStem headers = null;
        if (arg.getString("type").equals("filter")) {
            headers = arg.get("headers.").asStem();
        }
        switch (arg.getString("type")) {
            case "code": {
                return QDLValue.asQDLValue((Object)this.doCode(arg, username, headers, state));
            }
            case "file": {
                return QDLValue.asQDLValue((Object)this.doFS(arg, username, state));
            }
            case "ldap": {
                return QDLValue.asQDLValue((Object)this.doLDAP(arg, username, state));
            }
            case "filter": {
                return QDLValue.asQDLValue((Object)this.doHeaders(arg, username, headers, state));
            }
            case "header": {
                return QDLValue.asQDLValue((Object)this.doQDLHeaders(arg, username, headers, state));
            }
            case "ncsa": {
                return QDLValue.asQDLValue((Object)this.doNCSA(arg, username, state));
            }
        }
        return null;
    }

    private QDLStem doQDLHeaders(QDLStem arg, String username, QDLStem headers, State state) {
        OA2State oa2State = null;
        if (state instanceof OA2State) {
            oa2State = (OA2State)state;
        }
        QDLHeadersClaimsSource qdlHeaderClaimsSource = (QDLHeadersClaimsSource)this.getConfigToCS().convert(arg, oa2State == null ? null : oa2State.getOa2se());
        if (state instanceof OA2State) {
            qdlHeaderClaimsSource.setOa2State((OA2State)state);
        }
        OA2ServiceTransaction t = new OA2ServiceTransaction((Identifier)null);
        t.setUsername(username);
        JSONObject protoClaims = t.getUserMetaData();
        TestHTTPRequest req = new TestHTTPRequest(headers);
        JSONObject j = qdlHeaderClaimsSource.process(protoClaims, req, (ServiceTransaction)t);
        QDLStem output = new QDLStem();
        output.fromJSON(j);
        return output;
    }

    protected QDLStem doCode(QDLStem arg, String username, QDLStem headers, State state) {
        OA2State oa2State = null;
        if (state instanceof OA2State) {
            oa2State = (OA2State)state;
        }
        BasicClaimsSourceImpl basicClaimsSource = (BasicClaimsSourceImpl)this.getConfigToCS().convert(arg, oa2State == null ? null : oa2State.getOa2se());
        OA2ServiceTransaction t = new OA2ServiceTransaction((Identifier)null);
        t.setUsername(username);
        JSONObject claims = new JSONObject();
        TestHTTPRequest req = new TestHTTPRequest(headers);
        claims = basicClaimsSource.process(claims, req, (ServiceTransaction)t);
        QDLStem output = new QDLStem();
        output.fromJSON(claims);
        return output;
    }

    protected QDLStem doNCSA(QDLStem arg, String username, State state) {
        OA2State oa2State = null;
        if (state instanceof OA2State) {
            oa2State = (OA2State)state;
        }
        DebugUtil.setIsEnabled((boolean)true);
        DebugUtil.setDebugLevel((int)1);
        NCSALDAPClaimSource ncsaldapClaimSource = (NCSALDAPClaimSource)this.getConfigToCS().convert(arg, oa2State == null ? null : oa2State.getOa2se());
        OA2ServiceTransaction t = new OA2ServiceTransaction((Identifier)null);
        t.setUsername(username);
        JSONObject protoClaims = new JSONObject();
        protoClaims.put((Object)"uid", (Object)username);
        JSONObject j = ncsaldapClaimSource.process(protoClaims, (ServiceTransaction)t);
        QDLStem output = new QDLStem();
        output.fromJSON(j);
        return output;
    }

    public QDLStem doHeaders(QDLStem arg, String username, QDLStem headers, State state) {
        OA2State oa2State = null;
        if (state instanceof OA2State) {
            oa2State = (OA2State)state;
        }
        HTTPHeaderClaimsSource httpHeaderClaimsSource = (HTTPHeaderClaimsSource)this.getConfigToCS().convert(arg, oa2State == null ? null : oa2State.getOa2se());
        OA2ServiceTransaction t = new OA2ServiceTransaction((Identifier)null);
        t.setUsername(username);
        JSONObject protoClaims = new JSONObject();
        TestHTTPRequest req = new TestHTTPRequest(headers);
        JSONObject j = httpHeaderClaimsSource.process(protoClaims, req, (ServiceTransaction)t);
        QDLStem output = new QDLStem();
        output.fromJSON(j);
        return output;
    }

    private QDLStem doLDAP(QDLStem arg, String username, State state) {
        OA2State oa2State = null;
        if (state instanceof OA2State) {
            oa2State = (OA2State)state;
        }
        LDAPClaimsSource ldapClaimsSource = (LDAPClaimsSource)this.getConfigToCS().convert(arg, oa2State == null ? null : oa2State.getOa2se());
        OA2ServiceTransaction t = new OA2ServiceTransaction((Identifier)null);
        t.setUsername(username);
        JSONObject protoClaims = new JSONObject();
        protoClaims.put((Object)arg.getString("claim_name"), (Object)username);
        JSONObject j = ldapClaimsSource.process(protoClaims, (ServiceTransaction)t);
        QDLStem output = this.claimsToStem(j);
        if (output.containsKey((Object)arg.getString("claim_name")) && output.getString(arg.getString("claim_name")).equals(username)) {
            output.remove(arg.getString("claim_name"));
        }
        return output;
    }

    protected QDLStem claimsToStem(JSONObject claims) {
        QDLStem out = new QDLStem();
        for (Object k : claims.keySet()) {
            String key = k.toString();
            Object obj = claims.get(k);
            if (obj instanceof JSONObject) {
                StemUtility.put((QDLStem)out, (Object)(String.valueOf(k) + "."), (Object)this.claimsToStem((JSONObject)obj));
                continue;
            }
            if (obj instanceof JSONArray) {
                JSONArray array = (JSONArray)obj;
                QDLList sl = new QDLList();
                for (int i = 0; i < array.size(); ++i) {
                    Object obj1 = array.get(i);
                    QDLStem out1 = null;
                    if (obj1 instanceof JSONObject) {
                        out1 = this.claimsToStem((JSONObject)obj1);
                        sl.append((Object)out1);
                        continue;
                    }
                    sl.append(array.get(i));
                }
                QDLStem st1 = new QDLStem();
                st1.setQDLList(sl);
                StemUtility.put((QDLStem)out, (Object)key, (Object)st1);
                continue;
            }
            StemUtility.put((QDLStem)out, (Object)key, (Object)obj.toString());
        }
        return out;
    }

    protected QDLStem doFS(QDLStem arg, String username, State state) {
        OA2State oa2State = null;
        if (state instanceof OA2State) {
            oa2State = (OA2State)state;
        }
        String rawJSON = null;
        if (arg.containsKey((Object)"claims")) {
            QDLValue ooo = arg.get("claims");
            if (!(ooo instanceof QDLStem)) {
                throw new IllegalArgumentException("the claims argument must be a stem of claims");
            }
            rawJSON = ((QDLStem)ooo).toJSON().toString();
        } else if (arg.containsKey((Object)"file_path")) {
            Polyad polyad = new Polyad("file_read");
            polyad.addArgument((ExpressionInterface)new ConstantNode(QDLValue.asQDLValue((Object)arg.getString("file_path"))));
            state.getMetaEvaluator().evaluate(polyad, state);
            rawJSON = polyad.getResult().toString();
        }
        if (rawJSON == null) {
            throw new IllegalStateException("neither a path to the claims nor a stem of claims has been given");
        }
        FSClaimSource fsClaimSource = (FSClaimSource)this.getConfigToCS().convert(arg, oa2State, oa2State == null ? null : oa2State.getOa2se());
        fsClaimSource.setRawJSON(rawJSON);
        OA2ServiceTransaction t = new OA2ServiceTransaction((Identifier)null);
        t.setUsername(username);
        JSONObject claims = fsClaimSource.process(new JSONObject(), (ServiceTransaction)t);
        QDLStem output = new QDLStem();
        output.fromJSON(claims);
        return output;
    }

    protected static void testFS() {
        QDLStem mystem = new QDLStem();
        StemUtility.put((QDLStem)mystem, (Object)"type", (Object)"file");
        StemUtility.put((QDLStem)mystem, (Object)"file_path", (Object)(DebugUtil.getDevPath() + "/oa4mp/server-test/src/main/resources/test-claims.json"));
        CreateSourceConfig csc = new CreateSourceConfig();
        QDLStem out = csc.evaluate(new QDLValue[]{QDLValue.asQDLValue((Object)mystem)}, null).asStem();
        System.out.println(out.toJSON().toString(2));
        ClaimsSourceGetter cst = new ClaimsSourceGetter();
        QDLStem claims = cst.evaluate(new QDLValue[]{QDLValue.asQDLValue((Object)mystem), new StringValue("jeff")}, null).asStem();
        System.out.println("File claim source configuration:");
        System.out.println(claims.toJSON().toString(2));
    }

    protected static void testLDAP2() {
        QDLStem mystem = new QDLStem();
        StemUtility.put((QDLStem)mystem, (Object)"type", (Object)"ldap");
        StemUtility.put((QDLStem)mystem, (Object)"address", (Object)"ldap1.ncsa.illinois.edu,ldap2.ncsa.illinois.edu");
        StemUtility.put((QDLStem)mystem, (Object)"ldap_name", (Object)"uid");
        StemUtility.put((QDLStem)mystem, (Object)"search_base", (Object)"ou=People,dc=ncsa,dc=illinois,dc=edu");
        StemUtility.put((QDLStem)mystem, (Object)"claim_name", (Object)"uid");
        StemUtility.put((QDLStem)mystem, (Object)"auth_type", (Object)"none");
        CreateSourceConfig createSourceConfig = new CreateSourceConfig();
        QDLStem cfg = createSourceConfig.evaluate(new QDLValue[]{QDLValue.asQDLValue((Object)mystem)}, null).asStem();
        ClaimsSourceGetter cst = new ClaimsSourceGetter();
        QDLStem claims = cst.evaluate(new QDLValue[]{QDLValue.asQDLValue((Object)cfg), new StringValue("jgaynor")}, null).asStem();
        System.out.println(claims.toJSON().toString(2));
    }

    protected static void testNCSA() {
        CreateSourceConfig csc = new CreateSourceConfig();
        QDLStem cfg = new QDLStem();
        csc.doNCSA(new QDLStem(), cfg);
        System.out.println("NCSA default config:" + cfg.toString(1));
        ClaimsSourceGetter cst = new ClaimsSourceGetter();
        QDLStem claims = cst.evaluate(new QDLValue[]{QDLValue.asQDLValue((Object)cfg), new StringValue("jgaynor")}, null).asStem();
        System.out.println(claims.toString(2));
    }

    protected static void testLDAP() {
        QDLStem mystem = new QDLStem();
        StemUtility.put((QDLStem)mystem, (Object)"type", (Object)"ldap");
        StemUtility.put((QDLStem)mystem, (Object)"address", (Object)"ldap4.ncsa.illinois.edu,ldap2.ncsa.illinois.edu,ldap1.ncsa.illinois.edu");
        StemUtility.put((QDLStem)mystem, (Object)"auth_type", (Object)"none");
        StemUtility.put((QDLStem)mystem, (Object)"claim_name", (Object)"uid");
        StemUtility.put((QDLStem)mystem, (Object)"enabled", (Object)Boolean.TRUE);
        StemUtility.put((QDLStem)mystem, (Object)"ldap_name", (Object)"uid");
        StemUtility.put((QDLStem)mystem, (Object)"search_base", (Object)"ou=People,dc=ncsa,dc=illinois,dc=edu");
        ArrayList<String> searchAttr = new ArrayList<String>();
        searchAttr.add("mail");
        searchAttr.add("uid");
        searchAttr.add("uidNumber");
        searchAttr.add("cn");
        searchAttr.add("memberOf");
        QDLStem sa = new QDLStem();
        sa.addList(searchAttr);
        QDLStem groupNames = new QDLStem();
        groupNames.put((QDLKey)LongValue.Zero, (Object)"memberOf");
        StemUtility.put((QDLStem)mystem, (Object)"search_attributes", (Object)sa);
        StemUtility.put((QDLStem)mystem, (Object)"groups", (Object)groupNames);
        System.out.println("\n-----\nldap cfg:\n-----\n" + mystem.toString(1));
        ClaimsSourceGetter cst = new ClaimsSourceGetter();
        QDLStem claims = cst.evaluate(new QDLValue[]{QDLValue.asQDLValue((Object)mystem), new StringValue("jgaynor")}, null).asStem();
        System.out.println(claims.toString(2));
    }

    public static void main(String[] args) {
        System.out.println("Testing File System claims");
        ClaimsSourceGetter.testFS();
        System.out.println("Testing LDAP claims");
        ClaimsSourceGetter.testLDAP();
        System.out.println("Testing NCSA claims");
        ClaimsSourceGetter.testNCSA();
    }

    public List<String> getDocumentation(int argCount) {
        ArrayList<String> docs = new ArrayList<String>();
        docs.add(this.getName() + "(config., user_name) -- test a given claims configuration, returning a stem of claims");
        docs.add("Note that this is dependent on several factors, e.g. if you are testing LDAP, you may need to be on a VPN");
        return docs;
    }
}

