/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.claims;

import org.oa4mp.delegation.server.server.claims.ClaimSource;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.claims.BasicClaimsSourceImpl;
import org.oa4mp.server.loader.oauth2.claims.CodeClaimSource;
import org.oa4mp.server.loader.oauth2.claims.FSClaimSource;
import org.oa4mp.server.loader.oauth2.claims.HTTPHeaderClaimsSource;
import org.oa4mp.server.loader.oauth2.claims.LDAPClaimsSource;
import org.oa4mp.server.loader.oauth2.claims.NCSALDAPClaimSource;
import org.oa4mp.server.loader.oauth2.claims.QDLHeadersClaimsSource;
import org.oa4mp.server.loader.qdl.claims.CSConstants;
import org.oa4mp.server.loader.qdl.scripting.OA2State;
import org.qdl_lang.state.State;
import org.qdl_lang.variables.QDLStem;

public class ConfigtoCS
implements CSConstants {
    public ClaimSource convert(QDLStem arg, OA2SE oa2SE) {
        return this.convert(arg, null, oa2SE);
    }

    public ClaimSource convert(QDLStem arg, State qdlState, OA2SE oa2SE) {
        switch (arg.getString("type")) {
            case "basic": {
                return new BasicClaimsSourceImpl(arg);
            }
            case "code": {
                return new CodeClaimSource(arg);
            }
            case "file": {
                return new FSClaimSource(arg);
            }
            case "ldap": {
                return new LDAPClaimsSource(arg, oa2SE);
            }
            case "filter": {
                return new HTTPHeaderClaimsSource(arg);
            }
            case "header": {
                QDLHeadersClaimsSource cs = new QDLHeadersClaimsSource(arg);
                if (qdlState instanceof OA2State) {
                    cs.setOa2State((OA2State)qdlState);
                }
                return cs;
            }
            case "ncsa": {
                return new NCSALDAPClaimSource(arg, oa2SE);
            }
        }
        throw new IllegalArgumentException("Error: Unrecognized claim source type \"" + arg.getString("type") + "\"");
    }
}

