/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.claims;

import edu.uiuc.ncsa.security.core.exceptions.IllegalAccessException;
import java.util.ArrayList;
import java.util.List;
import org.oa4mp.server.loader.qdl.claims.CSConstants;
import org.qdl_lang.extensions.QDLFunction;
import org.qdl_lang.state.State;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;
import org.qdl_lang.variables.values.BooleanValue;
import org.qdl_lang.variables.values.LongValue;
import org.qdl_lang.variables.values.QDLKey;
import org.qdl_lang.variables.values.QDLValue;
import org.qdl_lang.variables.values.StringValue;

public class CreateSourceConfig
implements QDLFunction,
CSConstants {
    public static final String CREATE_SOURCE_NAME = "create_source";
    String rawLDAP = "{\n        \"ldap\": {\n          \"failOnError\": \"false\",\n          \"address\": \"ldap-test2.ncsa.illinois.edu\",\n          \"port\": 636,\n          \"enabled\": \"true\",\n          \"authorizationType\": \"none\",\n          \"searchName\": \"foo\",\n          \"searchAttributes\": [\n            {\n              \"name\": \"mail\",\n              \"returnAsList\": false,\n              \"returnName\": \"email\"\n            },\n            {\n              \"name\": \"uid\",\n              \"returnAsList\": false,\n              \"returnName\": \"uid\"\n            },\n            {\n              \"name\": \"uid\",\n              \"returnAsList\": false,\n              \"returnName\": \"uid\"\n            },\n            {\n              \"name\": \"uidNumber\",\n              \"returnAsList\": false,\n              \"returnName\": \"uidNumber\"\n            },\n            {\n              \"name\": \"cn\",\n              \"returnAsList\": false,\n              \"returnName\": \"name\"\n            },\n            {\n              \"name\": \"memberOf\",\n              \"IsInGroup\": true,\n              \"returnAsList\": false,\n              \"returnName\": \"isMemberOf\"\n            }\n          ],\n          \"searchBase\": \"ou=People,dc=ncsa,dc=illinois,dc=edu\",\n          \"contextName\": \"\",\n          \"ssl\": {\n            \"tlsVersion\": \"TLS\",\n            \"useJavaTrustStore\": true\n          },\n          \"name\": \"3258ed63b62d1a78\"\n        }\n      }";

    public String getName() {
        return CREATE_SOURCE_NAME;
    }

    public int[] getArgCount() {
        return new int[]{1};
    }

    public QDLValue evaluate(QDLValue[] objects, State state) {
        if (objects == null || objects.length == 0) {
            throw new IllegalArgumentException(this.getName() + " requires one argument");
        }
        if (!objects[0].isStem()) {
            throw new IllegalAccessException(this.getName() + " requires a stem variable as its argument.");
        }
        QDLStem arg = objects[0].asStem();
        if (!arg.containsKey((Object)"type")) {
            throw new IllegalArgumentException("Error: You must specify a type for the claim source");
        }
        QDLStem output = new QDLStem();
        this.setBasicValues(arg, output);
        switch (arg.getString("type")) {
            case "file": {
                return QDLValue.asQDLValue((Object)this.doFS(arg, output));
            }
            case "ncsa": {
                return QDLValue.asQDLValue((Object)this.doNCSA(arg, output));
            }
            case "ldap": {
                return QDLValue.asQDLValue((Object)this.doLDAP(arg, output));
            }
            case "filter": {
                return QDLValue.asQDLValue((Object)this.doHeaders(arg, output));
            }
            case "header": {
                return QDLValue.asQDLValue((Object)this.doQDLHeaders(arg, output));
            }
            case "code": {
                return QDLValue.asQDLValue((Object)this.doCode(arg, output));
            }
        }
        return QDLValue.asQDLValue((Object)output);
    }

    private QDLStem doCode(QDLStem arg, QDLStem output) {
        if (!arg.containsKey((Object)"java_class")) {
            throw new IllegalArgumentException("Error:java_class is required for a custom code configuration.");
        }
        this.setBasicValues(arg, output);
        return output.union(new QDLStem[]{arg});
    }

    protected QDLStem doNCSA(QDLStem arg, QDLStem output) {
        StemUtility.put((QDLStem)output, (Object)"address", (Object)"ldap4.ncsa.illinois.edu,ldap2.ncsa.illinois.edu,ldap1.ncsa.illinois.edu");
        StemUtility.put((QDLStem)output, (Object)"port", (Object)636L);
        StemUtility.put((QDLStem)output, (Object)"type", (Object)"ldap");
        StemUtility.put((QDLStem)output, (Object)"claim_name", (Object)"uid");
        StemUtility.put((QDLStem)output, (Object)"ldap_name", (Object)"uid");
        StemUtility.put((QDLStem)output, (Object)"enabled", (Object)Boolean.TRUE);
        StemUtility.put((QDLStem)output, (Object)"fail_on_error", (Object)Boolean.FALSE);
        StemUtility.put((QDLStem)output, (Object)"notify_on_fail", (Object)Boolean.TRUE);
        StemUtility.put((QDLStem)output, (Object)"search_base", (Object)"ou=People,dc=ncsa,dc=illinois,dc=edu");
        QDLStem searchAtt = new QDLStem();
        StemUtility.put((QDLStem)searchAtt, (Object)0L, (Object)"mail");
        StemUtility.put((QDLStem)searchAtt, (Object)1L, (Object)"uid");
        StemUtility.put((QDLStem)searchAtt, (Object)2L, (Object)"uidNumber");
        StemUtility.put((QDLStem)searchAtt, (Object)3L, (Object)"cn");
        StemUtility.put((QDLStem)searchAtt, (Object)4L, (Object)"memberOf");
        StemUtility.put((QDLStem)output, (Object)"search_attributes", (Object)searchAtt);
        QDLStem groups = new QDLStem();
        StemUtility.put((QDLStem)groups, (Object)0L, (Object)"memberOf");
        StemUtility.put((QDLStem)output, (Object)"groups", (Object)groups);
        QDLStem renames = new QDLStem();
        StemUtility.put((QDLStem)renames, (Object)"memberOf", (Object)"isMemberOf");
        StemUtility.put((QDLStem)renames, (Object)"mail", (Object)"email");
        StemUtility.put((QDLStem)output, (Object)"rename", (Object)renames);
        return output.union(new QDLStem[]{arg});
    }

    private QDLStem doHeaders(QDLStem arg, QDLStem output) {
        return output.union(new QDLStem[]{arg});
    }

    private QDLStem doQDLHeaders(QDLStem arg, QDLStem output) {
        return arg;
    }

    protected QDLStem doLDAP(QDLStem arg, QDLStem output) {
        if (!arg.containsKey((Object)"address")) {
            throw new IllegalArgumentException("Error:address is required for ldap configurations");
        }
        this.setValue(arg, output, "context", (QDLValue)new StringValue());
        return output.union(new QDLStem[]{arg});
    }

    protected void setValue(QDLStem arg, QDLStem config, String argKey) {
        this.setValue(arg, config, argKey, QDLValue.asQDLValue((Object)argKey));
    }

    protected QDLStem doFS(QDLStem arg, QDLStem output) {
        if (!arg.containsKey((Object)"file_path") && !arg.containsKey((Object)"claims")) {
            throw new IllegalArgumentException("Error: No file_path specified. You must specify this.");
        }
        if (arg.containsKey((Object)"file_path")) {
            this.setValue(arg, output, "file_path", null);
        }
        return output.union(new QDLStem[]{arg});
    }

    protected void setValue(QDLStem arg, QDLStem output, String key, QDLValue defaultValue) {
        if (arg == null) {
            output.put(key, defaultValue);
            return;
        }
        output.put(key, (QDLValue)arg.getOrDefault((Object)key, (Object)defaultValue));
    }

    protected void setBasicValues(QDLStem arg, QDLStem output) {
        this.setValue(arg, output, "type", QDLValue.asQDLValue((Object)"type"));
        this.setValue(arg, output, "enabled", (QDLValue)BooleanValue.True);
        this.setValue(arg, output, "fail_on_error", (QDLValue)BooleanValue.False);
        this.setValue(arg, output, "notify_on_fail", (QDLValue)BooleanValue.True);
        this.setValue(arg, output, "id", QDLValue.asQDLValue((Object)"qdl_claim_source"));
    }

    public List<String> getDocumentation(int argCount) {
        ArrayList<String> docs = new ArrayList<String>();
        docs.add(this.getName() + "(your_values.) -- creates a claim source configuration");
        docs.add("The argument at the least should have a type. The result is a configuration (as a stem)");
        docs.add("with all the required configuration (which may be quite a bit more than your specific values");
        return docs;
    }

    public static void main(String[] args) {
        QDLStem mystem = new QDLStem();
        StemUtility.put((QDLStem)mystem, (Object)"type", (Object)"ldap");
        StemUtility.put((QDLStem)mystem, (Object)"address", (Object)"ldap-test2.ncsa.illinois.edu");
        StemUtility.put((QDLStem)mystem, (Object)"auth_type", (Object)"none");
        StemUtility.put((QDLStem)mystem, (Object)"claim_name", (Object)"username");
        ArrayList<String> searchAttr = new ArrayList<String>();
        searchAttr.add("mail");
        searchAttr.add("uid");
        searchAttr.add("uidNumber");
        searchAttr.add("cn");
        searchAttr.add("memberOf");
        QDLStem sa = new QDLStem();
        sa.addList(searchAttr);
        QDLStem groupNames = new QDLStem();
        groupNames.put((QDLKey)LongValue.Zero, (Object)"memberOf");
        StemUtility.put((QDLStem)mystem, (Object)"search_attributes", (Object)sa);
        StemUtility.put((QDLStem)mystem, (Object)"groups", (Object)groupNames);
        StemUtility.put((QDLStem)mystem, (Object)"search_base", (Object)"ou=People,dc=ncsa,dc=illinois,dc=edu");
        CreateSourceConfig csc = new CreateSourceConfig();
        System.out.println(csc.evaluate(new QDLValue[]{new StringValue("ldap")}, null).asStem().toJSON().toString(1));
        QDLStem out = csc.evaluate(new QDLValue[]{QDLValue.asQDLValue((Object)mystem)}, null).asStem();
        System.out.println(out.toJSON().toString(2));
    }
}

