/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.claims;

import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.oa4mp.server.loader.oauth2.claims.AbstractPayloadConfig;
import org.oa4mp.server.loader.oauth2.claims.IDTokenHandler;
import org.oa4mp.server.loader.qdl.claims.TokenHandlerMethod;
import org.oa4mp.server.loader.qdl.scripting.OA2State;
import org.qdl_lang.exceptions.BadArgException;
import org.qdl_lang.extensions.QDLMetaModule;
import org.qdl_lang.state.State;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.values.BooleanValue;
import org.qdl_lang.variables.values.QDLValue;

public class IDTokenInitializer
implements QDLMetaModule {
    public static String ID_TOKEN_INIT_METHOD = "id_init";
    public static String ID_TOKEN_FINISH_METHOD = "id_finish";
    public static String ID_TOKEN_REFRESH_METHOD = "id_refresh";
    public static String ID_TOKEN_CHECK_CLAIM_METHOD = "id_check_claim";
    IDTokenHandler idTokenHandler;
    boolean isInit = false;

    protected IDTokenHandler getidTokenHandler() {
        return this.idTokenHandler;
    }

    public JSONObject serializeToJSON() {
        return null;
    }

    public void deserializeFromJSON(JSONObject jsonObject) {
    }

    public class idCheckClaims
    extends IDMethods {
        public idCheckClaims(OA2State oa2State) {
            super(oa2State);
        }

        public String getName() {
            return ID_TOKEN_CHECK_CLAIM_METHOD;
        }

        public int[] getArgCount() {
            return new int[]{0};
        }

        @Override
        public void doMethod(String execPhase) throws Throwable {
        }

        @Override
        public QDLValue evaluate(QDLValue[] objects, State state) {
            this.checkState(state);
            if (!this.isInit) {
                throw new IllegalStateException("You must call init first.");
            }
            try {
                IDTokenInitializer.this.getidTokenHandler().checkClaims();
            }
            catch (Throwable throwable) {
                return BooleanValue.False;
            }
            return BooleanValue.True;
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            if (argCount == 0) {
                doxx.add(this.getName() + "() - check if the current set of claims is valid. This also normalizes them (e.g. empty claims are removed.");
                doxx.add("Generally this is called right before the " + ID_TOKEN_FINISH_METHOD + " to see if something needs to be done.");
                doxx.add("This returns a true if the claims check and a false otherwise.");
                doxx.add("See also: " + ID_TOKEN_INIT_METHOD);
            }
            return doxx;
        }
    }

    public class idRefresh
    extends IDMethods {
        public idRefresh(OA2State oa2State) {
            super(oa2State);
        }

        public String getName() {
            return ID_TOKEN_REFRESH_METHOD;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        @Override
        public void doMethod(String execPhase) throws Throwable {
            if (!this.isInit) {
                throw new IllegalStateException(" You must run init first.");
            }
            IDTokenInitializer.this.getidTokenHandler().refresh();
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            if (argCount == 1) {
                doxx.add(this.getName() + "(id_token.) - refresh the id token");
                doxx.add("See also: " + ID_TOKEN_INIT_METHOD + ", " + ID_TOKEN_FINISH_METHOD);
            }
            return doxx;
        }
    }

    public class idFinish
    extends IDMethods {
        public idFinish(OA2State oa2State) {
            super(oa2State);
        }

        public String getName() {
            return ID_TOKEN_FINISH_METHOD;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        @Override
        public void doMethod(String execPhase) throws Throwable {
            if (!this.isInit) {
                throw new IllegalStateException(" You must run init first.");
            }
            IDTokenInitializer.this.getidTokenHandler().finish(execPhase);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            if (argCount == 1) {
                doxx.add(this.getName() + "(id_token.) - finish any setup that is required for this token, e.g., the expiration time.");
                doxx.add("This is the last thing that you should invoke before returning the id token.");
                doxx.add("See also: " + ID_TOKEN_INIT_METHOD);
            }
            return doxx;
        }
    }

    public class idInit
    extends IDMethods {
        public idInit(OA2State oa2State) {
            super(oa2State);
        }

        public String getName() {
            return ID_TOKEN_INIT_METHOD;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        @Override
        public void doMethod(String execPhase) throws Throwable {
            IDTokenInitializer.this.getidTokenHandler().init();
            this.isInit = true;
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            if (argCount == 1) {
                doxx.add(this.getName() + "(id_token.) - initialize an id token with all the standard claims.");
                doxx.add("You should invoke this before any other processing to be sure that things like the issued at timestamp are accurate.");
                doxx.add("Also, various internal things (such as global claims processing at the server level) are invoked. Always call this if you ");
                doxx.add("are going to roll your own id token.");
                doxx.add("See also: " + ID_TOKEN_FINISH_METHOD);
            }
            return doxx;
        }
    }

    public abstract class IDMethods
    extends TokenHandlerMethod {
        public IDMethods(OA2State oa2State) {
            super(oa2State);
        }

        protected Boolean isQuery(String execPhase) {
            boolean isQuery = false;
            switch (execPhase) {
                case "pre_auth": 
                case "post_auth": 
                case "init": {
                    isQuery = true;
                    break;
                }
                default: {
                    isQuery = false;
                }
            }
            return isQuery;
        }

        @Override
        protected AbstractPayloadConfig getPayloadConfig() {
            return this.getClient().getIDTokenConfig();
        }

        public abstract void doMethod(String var1) throws Throwable;

        @Override
        public QDLValue evaluate(QDLValue[] objects, State state) {
            super.evaluate(objects, state);
            QDLStem idtoken = this.checkArg(objects, this.getName(), 0);
            QDLStem output = new QDLStem();
            if (IDTokenInitializer.this.idTokenHandler == null) {
                IDTokenInitializer.this.idTokenHandler = new IDTokenHandler(this.getPayloadHandlerConfig());
            }
            if (1 < objects.length) {
                throw new IllegalArgumentException(" Missing second argument must be the execution phase.");
            }
            if (!objects[1].isString()) {
                throw new BadArgException(" The second argument must be a string.", 1);
            }
            String execPhase = objects[1].asString();
            IDTokenInitializer.this.getidTokenHandler().setUserMetaData((JSONObject)idtoken.toJSON());
            try {
                this.doMethod(execPhase);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
            output.fromJSON(IDTokenInitializer.this.getidTokenHandler().getUserMetaData());
            return QDLValue.asQDLValue((Object)output);
        }
    }
}

