/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.claims;

import java.util.ArrayList;
import java.util.List;
import org.oa4mp.server.loader.oauth2.claims.Groups;
import org.qdl_lang.exceptions.BadArgException;
import org.qdl_lang.extensions.QDLFunction;
import org.qdl_lang.state.State;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.values.BooleanValue;
import org.qdl_lang.variables.values.QDLValue;

public class IsInGroup
implements QDLFunction {
    public static final String IN_GROUP_NAME = "in_group";

    public String getName() {
        return IN_GROUP_NAME;
    }

    public int[] getArgCount() {
        return new int[]{2};
    }

    public QDLValue evaluate(QDLValue[] objects, State state) {
        if (objects == null) {
            return BooleanValue.False;
        }
        if (objects.length != 2) {
            throw new IllegalArgumentException(" This function requires two arguments, a stem and a string.");
        }
        if (objects[0] == null) {
            return BooleanValue.False;
        }
        if (!objects[0].isStem()) {
            throw new BadArgException(" The first argument of " + this.getName() + " must be a stem list of groups.", 0);
        }
        QDLStem groups = objects[0].asStem();
        if (groups.size() == 0) {
            return BooleanValue.False;
        }
        if (objects[1] == null | !objects[1].isString()) {
            throw new BadArgException(" The second argument of " + this.getName() + " must be a string.", 1);
        }
        String name = objects[1].asString();
        for (Object key : groups.keySet()) {
            QDLStem group;
            QDLValue obj = groups.get(key);
            if (!(obj.isStem() ? (group = obj.asStem()).containsKey((Object)Groups.GROUP_ENTRY_NAME) && group.getString(Groups.GROUP_ENTRY_NAME).equals(name) : obj.toString().equals(name))) continue;
            return BooleanValue.True;
        }
        return BooleanValue.False;
    }

    public List<String> getDocumentation(int argCount) {
        ArrayList<String> docs = new ArrayList<String>();
        docs.add("Deprecated. Use in_group2 which can process stems. Note the arguments are swapped there.");
        docs.add(this.getName() + "(groups., group_name) - checks if a group_name is in the given set of groups.");
        docs.add("This will work on either a flat list of group names or an isMemberOf structure,");
        docs.add("where each entry is of the form {name,id}");
        return docs;
    }
}

