/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.claims;

import java.util.ArrayList;
import java.util.List;
import org.oa4mp.server.loader.oauth2.claims.Groups;
import org.qdl_lang.exceptions.BadArgException;
import org.qdl_lang.extensions.QDLFunction;
import org.qdl_lang.state.State;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;
import org.qdl_lang.variables.values.BooleanValue;
import org.qdl_lang.variables.values.QDLValue;

public class IsInGroup2
implements QDLFunction {
    public static final String IN_GROUP_NAME = "in_group2";

    public String getName() {
        return IN_GROUP_NAME;
    }

    public int[] getArgCount() {
        return new int[]{2};
    }

    public QDLValue evaluate(QDLValue[] objects, State state) {
        QDLStem groupNames;
        if (objects == null) {
            return BooleanValue.False;
        }
        if (objects[0] == null || !objects[0].isStem() && !objects[0].isString()) {
            throw new BadArgException(" The first argument of " + this.getName() + " must be a string or stem of them.", 0);
        }
        if (objects[1] == null) {
            throw new BadArgException(" Undefined second argument for " + this.getName(), 1);
        }
        if (!objects[1].isStem()) {
            throw new IllegalArgumentException(" The second argument of " + this.getName() + " must be a stem list of groups.");
        }
        QDLStem groups = objects[1].asStem();
        if (groups.size() == 0) {
            return BooleanValue.False;
        }
        boolean isScalar = objects[0].isString();
        if (isScalar) {
            groupNames = new QDLStem();
            groupNames.listAdd(objects[0]);
        } else {
            groupNames = objects[0].asStem();
        }
        QDLStem result = new QDLStem();
        for (Object keys : groupNames.keySet()) {
            String name = groupNames.get(keys).asString();
            Boolean rValue = Boolean.FALSE;
            for (Object key : groups.keySet()) {
                QDLValue obj = groups.get(key);
                if (obj.isStem()) {
                    QDLStem group = obj.asStem();
                    if (!group.containsKey((Object)Groups.GROUP_ENTRY_NAME) || !group.getString(Groups.GROUP_ENTRY_NAME).equals(name)) continue;
                    rValue = Boolean.TRUE;
                    break;
                }
                if (!obj.isString()) {
                    throw new IllegalArgumentException("Error: unrecognized element in group.'" + String.valueOf(obj) + "'");
                }
                if (!obj.asString().equals(name)) continue;
                rValue = Boolean.TRUE;
                break;
            }
            if (keys instanceof Long) {
                StemUtility.put((QDLStem)result, keys, (Object)rValue);
                continue;
            }
            StemUtility.put((QDLStem)result, keys, (Object)rValue);
        }
        if (isScalar) {
            return result.get(Long.valueOf(0L));
        }
        return QDLValue.asQDLValue((Object)result);
    }

    public List<String> getDocumentation(int argCount) {
        ArrayList<String> docs = new ArrayList<String>();
        docs.add(this.getName() + "(group_name, groups.) - checks if a group_name is in the given set of groups.");
        docs.add("the first argument is either a string with the group name or a stem of group names.");
        docs.add("The result is always left conformable.");
        docs.add("This will work on either a flat list of groups.  or an isMemberOf structure,");
        docs.add("where each entry is of the form {name,id}");
        docs.add("E.g.");
        docs.add("Example where the groups. is a group structure with name and id");
        docs.add("   groups. := [{'name':'test0','id':123}, {'name':'test1','id':234}, {'name':'test2','id':345}, {'name':'test3','id':456}];");
        docs.add("   " + this.getName() + "(['test0', 'foo'], groups.)");
        docs.add("[true,false]");
        docs.add("E.g.");
        docs.add("Example to show this works with a scalar and returns a scalar.");
        docs.add("   " + this.getName() + "('test2', groups.)");
        docs.add("true");
        docs.add("E.g.");
        docs.add("Example where the groups. is a flat list of names -- which can happen too.");
        docs.add("   groups2. := ['test0', 'test1', 'test2', 'test3'];");
        docs.add("   " + this.getName() + "(['test0', 'foo'], groups.)");
        docs.add("[true,false]");
        docs.add("\nFinal note: If group_name is a list, the result is a list, if it is a stem");
        docs.add("the result is a stem as well. This makes it easy to use with mask and other functions.");
        return docs;
    }
}

