/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.claims;

import java.util.ArrayList;
import java.util.List;
import org.oa4mp.server.loader.qdl.claims.CSConstants;
import org.qdl_lang.exceptions.BadArgException;
import org.qdl_lang.extensions.QDLFunction;
import org.qdl_lang.state.State;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;
import org.qdl_lang.variables.values.QDLValue;

public class NewTemplate
implements QDLFunction,
CSConstants {
    public static final String NEW_TEMPLATE_NAME = "new_template";
    public static String REQUIRED_TEMPLATE = "**";

    public String getName() {
        return NEW_TEMPLATE_NAME;
    }

    public int[] getArgCount() {
        return new int[]{1};
    }

    public QDLValue evaluate(QDLValue[] objects, State state) {
        String type = objects[0].asString();
        QDLStem output = new QDLStem();
        switch (type) {
            case "file": {
                StemUtility.put((QDLStem)output, (Object)"type", (Object)"file");
                return QDLValue.asQDLValue((Object)output);
            }
            case "ldap": {
                output = new QDLStem();
                StemUtility.put((QDLStem)output, (Object)"type", (Object)"ldap");
                StemUtility.put((QDLStem)output, (Object)"address", (Object)REQUIRED_TEMPLATE);
                StemUtility.put((QDLStem)output, (Object)"search_base", (Object)REQUIRED_TEMPLATE);
                StemUtility.put((QDLStem)output, (Object)"claim_name", (Object)REQUIRED_TEMPLATE);
                StemUtility.put((QDLStem)output, (Object)"ldap_name", (Object)REQUIRED_TEMPLATE);
                StemUtility.put((QDLStem)output, (Object)"auth_type", (Object)REQUIRED_TEMPLATE);
                return QDLValue.asQDLValue((Object)output);
            }
            case "ncsa": {
                StemUtility.put((QDLStem)output, (Object)"type", (Object)"ncsa");
                return QDLValue.asQDLValue((Object)output);
            }
            case "filter": {
                StemUtility.put((QDLStem)output, (Object)"type", (Object)"filter");
                StemUtility.put((QDLStem)output, (Object)"prefix", (Object)REQUIRED_TEMPLATE);
                return QDLValue.asQDLValue((Object)output);
            }
            case "header": {
                StemUtility.put((QDLStem)output, (Object)"type", (Object)"header");
                return QDLValue.asQDLValue((Object)output);
            }
            case "code": {
                StemUtility.put((QDLStem)output, (Object)"type", (Object)"code");
                StemUtility.put((QDLStem)output, (Object)"java_class", (Object)REQUIRED_TEMPLATE);
                return QDLValue.asQDLValue((Object)output);
            }
        }
        throw new BadArgException("Error: unknown configuration type \"" + type + "\".", 0);
    }

    public List<String> getDocumentation(int argCount) {
        ArrayList<String> doc = new ArrayList<String>();
        doc.add(this.getName() + "(type) creates a template with the minimum required arguments for a source of this type.");
        doc.add("Generally you use this, then call create_source to add all the other required values before either");
        doc.add("testing it or adding it as a claim source.");
        doc.add("Supported types are:");
        doc.add("file - for file-based claims");
        doc.add("header - retrieve all of the headers.");
        doc.add("ldap - to get claims from a generic LDAP");
        doc.add("ncsa - to get claims from the NCSA LDAP (NOTE requires you be on the NCSA internal network!)");
        doc.add("code - for custom written claim sources. (Note: The class must be available in the JVM.)");
        return doc;
    }
}

