/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.claims;

import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.oa4mp.server.loader.oauth2.claims.AbstractPayloadConfig;
import org.oa4mp.server.loader.oauth2.tokens.BasicRefreshTokenHandler;
import org.oa4mp.server.loader.qdl.claims.TokenHandlerMethod;
import org.oa4mp.server.loader.qdl.scripting.OA2State;
import org.qdl_lang.exceptions.BadArgException;
import org.qdl_lang.extensions.QDLMetaModule;
import org.qdl_lang.state.State;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.values.QDLValue;

public class RefreshTokenInitializer
implements QDLMetaModule {
    public static String RT_INIT_METHOD = "rt_init";
    public static String RT_FINISH_METHOD = "rt_finish";
    public static String RT_REFRESH_METHOD = "rt_refresh";

    public JSONObject serializeToJSON() {
        return null;
    }

    public void deserializeFromJSON(JSONObject jsonObject) {
    }

    public class rtRefresh
    extends RTMethod {
        public rtRefresh(OA2State oa2State) {
            super(oa2State);
        }

        public String getName() {
            return RT_REFRESH_METHOD;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        @Override
        protected void doMethod(String execPhase) throws Throwable {
            this.getRtHandler().refresh();
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            if (argCount == 1) {
                doxx.add(this.getName() + "(refresh_token.) - do any required tasks to make a token for the refresh phase.");
                doxx.add("See also: " + RT_INIT_METHOD + ", " + RT_FINISH_METHOD);
            }
            return doxx;
        }
    }

    public class rtFinish
    extends RTMethod {
        public rtFinish(OA2State oa2State) {
            super(oa2State);
        }

        public String getName() {
            return RT_FINISH_METHOD;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        @Override
        protected void doMethod(String execPhase) throws Throwable {
            this.getRtHandler().finish(execPhase);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            if (argCount == 1) {
                doxx.add(this.getName() + "(refresh_token.) - finish the initialization for this refresh token.");
                doxx.add("See also: " + RT_INIT_METHOD + ", " + RT_REFRESH_METHOD);
            }
            return doxx;
        }
    }

    public class rtInit
    extends RTMethod {
        public rtInit(OA2State oa2State) {
            super(oa2State);
        }

        public String getName() {
            return RT_INIT_METHOD;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        @Override
        protected void doMethod(String execPhase) throws Throwable {
            this.getRtHandler().init();
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            if (argCount == 1) {
                doxx.add(this.getName() + "(refresh_token.) - intialize a refresh token.");
                doxx.add("");
                doxx.add("See also: " + RT_FINISH_METHOD + ", " + RT_REFRESH_METHOD);
            }
            return doxx;
        }
    }

    public abstract class RTMethod
    extends TokenHandlerMethod {
        BasicRefreshTokenHandler rtHandler;

        public RTMethod(OA2State oa2State) {
            super(oa2State);
        }

        @Override
        protected AbstractPayloadConfig getPayloadConfig() {
            return this.getClient().getRefreshTokensConfig();
        }

        public BasicRefreshTokenHandler getRtHandler() {
            if (this.rtHandler == null) {
                this.rtHandler = new BasicRefreshTokenHandler(this.getPayloadHandlerConfig());
            }
            return this.rtHandler;
        }

        protected abstract void doMethod(String var1) throws Throwable;

        @Override
        public QDLValue evaluate(QDLValue[] objects, State state) {
            super.evaluate(objects, state);
            QDLStem rt = this.checkArg(objects, this.getName(), 0);
            QDLStem output = new QDLStem();
            this.getRtHandler().setRTData((JSONObject)rt.toJSON());
            String execPhase = null;
            if (1 < objects.length) {
                if (!objects[1].isString()) {
                    throw new BadArgException("Error: The second argument must be a string.", 1);
                }
                execPhase = objects[1].asString();
            }
            try {
                this.doMethod(execPhase);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
            output.fromJSON(this.getRtHandler().getPayload());
            return QDLValue.asQDLValue((Object)output);
        }
    }

    public abstract class IDMethods
    extends TokenHandlerMethod {
        public IDMethods(OA2State oa2State) {
            super(oa2State);
        }

        protected Boolean isQuery(String execPhase) {
            boolean isQuery = false;
            switch (execPhase) {
                case "pre_auth": 
                case "post_auth": 
                case "init": {
                    isQuery = true;
                    break;
                }
                default: {
                    isQuery = false;
                }
            }
            return isQuery;
        }
    }
}

