/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.claims;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSONArray;
import org.oa4mp.server.loader.oauth2.claims.ScopeTemplateUtil;
import org.qdl_lang.exceptions.BadArgException;
import org.qdl_lang.expressions.ConstantNode;
import org.qdl_lang.expressions.Polyad;
import org.qdl_lang.extensions.QDLFunction;
import org.qdl_lang.state.State;
import org.qdl_lang.statements.ExpressionInterface;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.values.LongValue;
import org.qdl_lang.variables.values.QDLValue;
import org.qdl_lang.variables.values.StemValue;
import org.qdl_lang.variables.values.StringValue;

public class ScopeTemplateQDLUtil
implements Serializable {
    public static final String RESOLVE_TEMPLATES_NAME = "resolve_templates";
    public static final String QUERY_SCOPES_NAME = "query_scopes";
    public static final String DOWNSCOPE_NAME = "downscope";
    public static final String TO_SCOPE_STRING_NAME = "to_scope_string";

    protected QDLStem doIt(QDLStem allowedStem, QDLStem requestedStem, boolean isQuery) {
        JSONArray computedScopes = allowedStem.getQDLList().toJSON();
        JSONArray requestedScopes = requestedStem.getQDLList().toJSON();
        Collection<String> returnedScopes = ScopeTemplateUtil.doCompareTemplates((Collection<String>)computedScopes, (Collection<String>)requestedScopes, isQuery);
        ArrayList<String> rc = new ArrayList<String>();
        rc.addAll(returnedScopes);
        QDLStem output = new QDLStem();
        output.addList(rc);
        return output;
    }

    public class ToScopeString
    implements QDLFunction {
        List<String> doxx = null;

        public String getName() {
            return ScopeTemplateQDLUtil.TO_SCOPE_STRING_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (!objects[0].isStem()) {
                throw new BadArgException("to_scope_string requires a stem as its argument", 0);
            }
            QDLStem parameters = objects[0].asStem();
            Polyad unique = new Polyad("unique");
            unique.addArgument((ExpressionInterface)new ConstantNode(QDLValue.asQDLValue((Object)parameters)));
            Polyad detokenize = new Polyad("detokenize");
            detokenize.addArgument((ExpressionInterface)unique);
            detokenize.addArgument((ExpressionInterface)new ConstantNode((QDLValue)new StringValue(" ")));
            detokenize.addArgument((ExpressionInterface)new ConstantNode((QDLValue)new LongValue(Long.valueOf(2L))));
            detokenize.evaluate(state);
            return detokenize.getResult();
        }

        public List<String> getDocumentation(int argCount) {
            if (this.doxx == null) {
                this.doxx = new ArrayList<String>();
                this.doxx.add("to_scope_string(scopes.) - convert a list of scopes to an OAuth string of scopes.");
                this.doxx.add("In OAuth, the scope value is a blank delimited string. ");
                this.doxx.add("E.g.");
                this.doxx.add("    to_scope_string(['openid','profile']);");
                this.doxx.add("openid profile");
                this.doxx.add("This is a string with blanks between the arguments.");
            }
            return this.doxx;
        }
    }

    public class Downscope
    implements QDLFunction {
        public String getName() {
            return ScopeTemplateQDLUtil.DOWNSCOPE_NAME;
        }

        public int[] getArgCount() {
            return new int[]{2};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (!objects[0].isStem()) {
                throw new BadArgException("Error: The first argument (for the computed scopes) must be a stem.", 0);
            }
            QDLStem allowedStem = objects[0].asStem();
            if (!objects[1].isStem()) {
                throw new BadArgException("Error: The second argument (for the requested scopes) must be a stem.", 1);
            }
            QDLStem requestedStem = objects[1].asStem();
            return QDLValue.asQDLValue((Object)ScopeTemplateQDLUtil.this.doIt(allowedStem, requestedStem, false));
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(allowed_scopes., requested_scopes.)");
            doxx.add("Downscopes from the computed scopes. ");
            doxx.add("allowed_scopes. = allowed scopes (e.g. from templates).");
            doxx.add("requested_scopes. = the scopes in the client request.");
            doxx.add("E.g. There are two templates");
            doxx.add("   as. :=['x.y:/abc/def','p.q:/rst']");
            doxx.add("   // The requested scopes includes a super-scope of the p.q template");
            doxx.add("   req. := ['x.y:/abc/def/ghi','x.y:/abc/defg', 'p.q:/']");
            doxx.add("   // Setting is_query to false means resolve only sub-scopes");
            doxx.add("  resolve_templates(as., req.)");
            doxx.add("[x.y:/abc/def/ghi]");
            doxx.add("N.B: downscope('x.,y.) == resolve_templates(x.,y., false)");
            doxx.add("See also: query_scopes, resolve_templates");
            return doxx;
        }
    }

    public class QueryScopes
    implements QDLFunction {
        public String getName() {
            return ScopeTemplateQDLUtil.QUERY_SCOPES_NAME;
        }

        public int[] getArgCount() {
            return new int[]{2};
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(allowed_scopes., requested_scopes.)");
            doxx.add("Query what scopes are allowed from the computed scopes");
            doxx.add("This is properly done in the authorization so the client knows what is allowed.");
            doxx.add("allowed_scopes. = allowed scopes (e.g. from templates).");
            doxx.add("requested_scopes. = the scopes in the client request.");
            doxx.add("E.g. There are two templates");
            doxx.add("   as. :=['x.y:/abc/def','p.q:/rst']");
            doxx.add("   // The requested scopes includes a super-scope of the p.q template");
            doxx.add("   req. := ['x.y:/abc/def/ghi','x.y:/abc/defg', 'p.q:/']");
            doxx.add("  " + this.getName() + "(as., req.)");
            doxx.add("[p.q:/rst,x.y:/abc/def/ghi]");
            doxx.add("N.B: query_scopes('x.,y.) == resolve_templates(x.,y., true)");
            doxx.add("See also: downscope, resolve_templates");
            return doxx;
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (!objects[0].isStem()) {
                throw new BadArgException("Error: The first argument (for the computed scopes) must be a stem.", 0);
            }
            QDLStem allowedStem = objects[0].asStem();
            if (!objects[1].isStem()) {
                throw new BadArgException("Error: The second argument (for the requested scopes) must be a stem.", 1);
            }
            QDLStem requestedStem = objects[1].asStem();
            return QDLValue.asQDLValue((Object)ScopeTemplateQDLUtil.this.doIt(allowedStem, requestedStem, true));
        }
    }

    public class ResolveTemplates
    implements QDLFunction {
        public String getName() {
            return ScopeTemplateQDLUtil.RESOLVE_TEMPLATES_NAME;
        }

        public int[] getArgCount() {
            return new int[]{3};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (objects[0] == null || objects[0].isNull()) {
                return new StemValue();
            }
            if (!objects[0].isStem()) {
                throw new BadArgException(" " + this.getName() + "(0)  (computed scopes) must be a stem, got a '" + String.valueOf(objects[0]) + "'", 0);
            }
            QDLStem allowedStem = objects[0].asStem();
            if (allowedStem.isEmpty()) {
                return new StemValue();
            }
            if (!objects[1].isStem()) {
                throw new BadArgException(" " + this.getName() + "(1) (requested scopes)  must be a stem, got a '" + String.valueOf(objects[1]) + "'", 1);
            }
            QDLStem requestedStem = objects[1].asStem();
            if (requestedStem.isEmpty()) {
                return new StemValue();
            }
            if (!objects[2].isBoolean()) {
                throw new BadArgException(" " + this.getName() + "(2) (queries available scopes?)  must be a boolean, got '" + String.valueOf(objects[2]) + "'.", 2);
            }
            Boolean isQuery = objects[2].asBoolean();
            return QDLValue.asQDLValue((Object)ScopeTemplateQDLUtil.this.doIt(allowedStem, requestedStem, isQuery));
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(allowed_scopes., requested_scopes., is_query)");
            doxx.add("Query or downscope, based on the final argument");
            doxx.add("allowed_scopes. = allowed scopes (e.g. from templates).");
            doxx.add("requested_scopes. = the scopes in the client request.");
            doxx.add("is_query = true if this call is to query available scopes. ");
            doxx.add("E.g. There are two templates");
            doxx.add("   as. :=['x.y:/abc/def','p.q:/rst']");
            doxx.add("   // The requested scopes includes a super-scope of the p.q template");
            doxx.add("   req. := ['x.y:/abc/def/ghi','x.y:/abc/defg', 'p.q:/']");
            doxx.add("   // Setting is_query to false means resolve only sub-scopes");
            doxx.add("  resolve_templates(as., req., false)");
            doxx.add("[x.y:/abc/def/ghi]");
            doxx.add("   // Setting is_query to true means to interpret super-scopes as");
            doxx.add("   // requests for supported templates");
            doxx.add("  resolve_templates(as., req., true)");
            doxx.add("[p.q:/rst,x.y:/abc/def/ghi]");
            doxx.add("See also: downscope, query_scopes");
            return doxx;
        }
    }
}

