/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.scripting;

import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.util.scripting.ScriptSet;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.server.loader.qdl.scripting.OA2QDLEnvironment;
import org.qdl_lang.config.QDLConfigurationLoader;
import org.qdl_lang.scripting.AnaphorUtil;

public class OA2QDLConfigurationLoader<T extends OA2QDLEnvironment>
extends QDLConfigurationLoader<T> {
    Boolean skipBadModulesOnLoad = null;
    public static String SCRIPTS_TAG = "scripts";
    public static String SCRIPT_TAG = "script";
    public static String SKIP_BAD_MODULES_TAG = "skipBadModulesOnLoad";

    public OA2QDLConfigurationLoader(String cfgFile, ConfigurationNode node) {
        super(cfgFile, node);
    }

    public OA2QDLConfigurationLoader(String cfgFile, ConfigurationNode node, MyLoggingFacade logger) {
        super(cfgFile, node, logger);
    }

    public T createInstance() {
        return (T)((Object)new OA2QDLEnvironment(this.myLogger, this.getConfigFile(), this.getName(), this.isEnabled(), this.isServerModeOn(), this.isRestrictedIO(), this.getNumericDigits(), this.getBootScript(), this.getWSHomeDir(), this.getWSEnvFile(), this.isEchoModeOn(), this.isPrettyPrint(), this.isWSVerboseOn(), this.getCompressionOn(), this.showBanner(), this.getVFSConfigs(), this.getModuleConfigs(), this.getScriptPath(), this.getModulePath(), this.getLibPath(), this.getDebugLevel(), this.isAutosaveOn(), this.getAutosaveInterval(), this.isAutosaveMessagesOn(), this.useWSExternalEditor(), this.getExternalEditorPath(), this.getEditors(), this.isEnableLibrarySupport(), this.areAssertionsEnabled(), this.getSaveDir(), this.isOverwriteBaseFunctionsOn(), this.getServerScriptSet(), this.getLibLoader(), this.useLogo(), this.isSkipBadModulesOnLoad(), this.isPreprocessorOn(), this.getLibrarySupportMode()));
    }

    private boolean isSkipBadModulesOnLoad() {
        if (this.skipBadModulesOnLoad == null) {
            String x = Configurations.getNodeValue((ConfigurationNode)this.cn, (String)SKIP_BAD_MODULES_TAG);
            this.skipBadModulesOnLoad = x == null ? Boolean.valueOf(true) : Boolean.valueOf(x.equalsIgnoreCase("true"));
        }
        return this.skipBadModulesOnLoad;
    }

    protected String getWSEnvFile() {
        ConfigurationNode node = Configurations.getFirstNode((ConfigurationNode)this.cn, (String)"workspace");
        return Configurations.getNodeValue((ConfigurationNode)node, (String)"env", (String)"");
    }

    public ScriptSet getServerScriptSet() {
        ConfigurationNode node = Configurations.getFirstNode((ConfigurationNode)this.cn, (String)SCRIPTS_TAG);
        if (node == null) {
            return null;
        }
        List scripts = node.getChildren(SCRIPT_TAG);
        if (scripts == null || scripts.isEmpty()) {
            return null;
        }
        JSONArray allScripts = new JSONArray();
        for (ConfigurationNode scriptNode : scripts) {
            JSONObject jsonObject;
            Object o;
            String rawJSON = (String)scriptNode.getValue();
            if (rawJSON == null || rawJSON.trim().isEmpty() || !((o = (jsonObject = JSONObject.fromObject((Object)rawJSON)).get("qdl")) instanceof JSON)) continue;
            if (o instanceof JSONArray) {
                allScripts.addAll((Collection)((JSONArray)o));
            }
            if (!(o instanceof JSONObject)) continue;
            allScripts.add(o);
        }
        return AnaphorUtil.createScripts((JSON)allScripts);
    }
}

