/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.scripting;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.qdl_lang.evaluate.MetaEvaluator;
import org.qdl_lang.evaluate.OpEvaluator;
import org.qdl_lang.expressions.module.MIStack;
import org.qdl_lang.expressions.module.MTStack;
import org.qdl_lang.functions.FStack;
import org.qdl_lang.state.State;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.VStack;

public class OA2State
extends State {
    transient OA2ServiceTransaction transaction;
    transient OA2SE oa2se;
    transient HttpServletRequest request;
    JSONWebKeys jsonWebKeys;
    boolean strictACLs = false;
    transient List<Identifier> aclList = new ArrayList<Identifier>();
    transient List<Identifier> aclBlackList = new ArrayList<Identifier>();
    transient TXRecord txRecord;

    public OA2State(VStack vStack, OpEvaluator opEvaluator, MetaEvaluator metaEvaluator, FStack ft, MTStack mTemplates, MIStack mInstance, MyLoggingFacade myLoggingFacade, boolean isServerMode, boolean isRestrictedIO, boolean assertionsOn, boolean strictACLs, JSONWebKeys keys) {
        super(vStack, opEvaluator, metaEvaluator, ft, mTemplates, mInstance, myLoggingFacade, isServerMode, isRestrictedIO, assertionsOn);
        this.strictACLs = strictACLs;
        this.jsonWebKeys = keys;
    }

    public State newLocalState() {
        OA2State oa2State = (OA2State)super.newLocalState();
        return this.oa2StateInit(oa2State);
    }

    private OA2State oa2StateInit(OA2State oa2State) {
        oa2State.setOa2se(this.getOa2se());
        oa2State.setTransaction(this.getTransaction());
        oa2State.setStrictACLs(this.isStrictACLs());
        oa2State.setJsonWebKeys(this.getJsonWebKeys());
        oa2State.setTxRecord(this.getTxRecord());
        oa2State.setAclList(this.getAclList());
        oa2State.setAclBlackList(this.getAclBlackList());
        oa2State.setRequest(this.getRequest());
        return oa2State;
    }

    public State newFunctionState() {
        OA2State oa2State = (OA2State)super.newFunctionState();
        return this.oa2StateInit(oa2State);
    }

    public State newCleanState() {
        OA2State oa2State = (OA2State)super.newCleanState();
        return this.oa2StateInit(oa2State);
    }

    public JSONWebKeys getJsonWebKeys() {
        return this.jsonWebKeys;
    }

    public void setJsonWebKeys(JSONWebKeys jsonWebKeys) {
        this.jsonWebKeys = jsonWebKeys;
    }

    public void setStrictACLs(boolean strictACLs) {
        this.strictACLs = strictACLs;
    }

    public boolean isStrictACLs() {
        return this.strictACLs;
    }

    public List<Identifier> getAclList() {
        return this.aclList;
    }

    public void setAclList(List<Identifier> aclList) {
        this.aclList = aclList;
    }

    public List<Identifier> getAclBlackList() {
        return this.aclBlackList;
    }

    public void setAclBlackList(List<Identifier> aclBlackList) {
        this.aclBlackList = aclBlackList;
    }

    public TXRecord getTxRecord() {
        return this.txRecord;
    }

    public void setTxRecord(TXRecord txRecord) {
        this.txRecord = txRecord;
    }

    public OA2ServiceTransaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(OA2ServiceTransaction transaction) {
        this.transaction = transaction;
    }

    public OA2SE getOa2se() {
        return this.oa2se;
    }

    public void setOa2se(OA2SE oa2se) {
        this.oa2se = oa2se;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public List<Identifier> getAdminIDs() {
        return this.getOa2se().getPermissionStore().getAdmins(this.getClientID());
    }

    public Identifier getClientID() {
        return this.getTransaction().getClient().getIdentifier();
    }

    public void readExtraXMLElements(XMLEvent xe, XMLEventReader xer) throws XMLStreamException {
        super.readExtraXMLElements(xe, xer);
        switch (xe.asStartElement().getName().getLocalPart()) {
            case "tx_record": {
                this.txRecord = new TXRecord(null);
                this.txRecord.fromXML(xer);
            }
        }
    }

    public void writeExtraXMLElements(XMLStreamWriter xsw) throws XMLStreamException {
        super.writeExtraXMLElements(xsw);
        if (this.txRecord != null) {
            this.txRecord.toXML(xsw);
        }
    }

    public State newInstance(VStack vStack, OpEvaluator opEvaluator, MetaEvaluator metaEvaluator, FStack fStack, MTStack mTemplates, MIStack mInstances, MyLoggingFacade myLoggingFacade, boolean isServerMode, boolean isRestrictedIO, boolean assertionsOn) {
        OA2State s = new OA2State(vStack, opEvaluator, metaEvaluator, fStack, mTemplates, mInstances, myLoggingFacade, isServerMode, isRestrictedIO, assertionsOn, this.isStrictACLs(), this.getJsonWebKeys());
        return this.oa2StateInit(s);
    }

    protected QDLStem addManifestConstants(String path) {
        return super.addManifestConstants(path);
    }
}

