/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.scripting;

import edu.uiuc.ncsa.security.core.configuration.XProperties;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.FileUtil;
import edu.uiuc.ncsa.security.core.util.Iso8601;
import edu.uiuc.ncsa.security.util.scripting.ScriptInterface;
import edu.uiuc.ncsa.security.util.scripting.ScriptSet;
import edu.uiuc.ncsa.security.util.scripting.ScriptingConstants;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.server.loader.qdl.scripting.QDLRuntimeEngine;
import org.qdl_lang.scripting.JSONScriptUtil;
import org.qdl_lang.scripting.QDLScript;
import org.qdl_lang.scripting.Scripts;
import org.qdl_lang.vfs.FileEntries;

public class QDLJSONConfigUtil
implements ScriptingConstants {
    public static JSONObject scriptSetToJSON(ScriptSet<? extends QDLScript> scriptSet) {
        JSONObject scripts = JSONScriptUtil.createConfig();
        for (QDLScript s : scriptSet.getScripts()) {
            JSONScriptUtil.addScript((JSONObject)scripts, (QDLScript)s);
        }
        JSONObject config = new JSONObject();
        config.put((Object)QDLRuntimeEngine.CONFIG_TAG, (Object)scripts);
        return config;
    }

    public static ScriptSet readScriptSet(JSONObject config) {
        JSONArray array = config.getJSONArray(QDLRuntimeEngine.SCRIPTS_TAG);
        ScriptSet scriptSet = new ScriptSet();
        for (int i = 0; i < array.size(); ++i) {
            QDLScript qdlScript = Scripts.fromJSON((JSONObject)array.getJSONObject(i));
            scriptSet.add((ScriptInterface)qdlScript);
        }
        return scriptSet;
    }

    public static JSONObject createCfg(String fileName) throws Throwable {
        return QDLJSONConfigUtil.createCfg(new JSONObject(), fileName);
    }

    public static JSONObject createCfgFromString(String rawScript, String execPhase) throws Throwable {
        JSONObject jsonObject = new JSONObject();
        XProperties xp = new XProperties();
        xp.put((Object)"id", (Object)(execPhase + ".qdl"));
        xp.put((Object)"exec_phase", (Object)execPhase);
        xp.put((Object)"language", (Object)"qdl");
        xp.put((Object)"lang_version", (Object)"1.6-QDL-SNAPSHOT");
        xp.put((Object)"script_version", (Object)"1.0");
        xp.put((Object)"create_ts", (Object)Iso8601.date2String((Date)new Date()));
        xp.put((Object)"last_modified", (Object)Iso8601.date2String((Date)new Date()));
        QDLScript qdlScript = new QDLScript((Reader)new StringReader(rawScript), xp);
        JSONObject scripts = JSONScriptUtil.createConfig();
        JSONScriptUtil.addScript((JSONObject)scripts, (QDLScript)qdlScript);
        jsonObject.put((Object)QDLRuntimeEngine.CONFIG_TAG, (Object)scripts);
        return jsonObject;
    }

    public static JSONObject createCfg(JSONObject currentConfig, String filePath) throws Throwable {
        String fileName = filePath.substring(filePath.lastIndexOf(File.pathSeparator));
        QDLScript qdlScript = QDLJSONConfigUtil.createCfg(fileName, filePath);
        JSONObject scripts = null;
        scripts = currentConfig.containsKey((Object)QDLRuntimeEngine.CONFIG_TAG) ? currentConfig.getJSONObject(QDLRuntimeEngine.CONFIG_TAG) : JSONScriptUtil.createConfig();
        JSONScriptUtil.addScript((JSONObject)scripts, (QDLScript)qdlScript);
        currentConfig.put((Object)QDLRuntimeEngine.CONFIG_TAG, (Object)scripts);
        return currentConfig;
    }

    protected static QDLScript createCfg(String relativePath, String absolutePath) throws Throwable {
        String script = FileUtil.readFileAsString((String)absolutePath);
        XProperties xp = new XProperties();
        String scriptName = absolutePath.substring(absolutePath.lastIndexOf(File.separator) + 1);
        switch (scriptName = scriptName.substring(0, scriptName.lastIndexOf("."))) {
            case "init": {
                xp.put((Object)"exec_phase", (Object)"init");
                break;
            }
            case "pre_auth": {
                xp.put((Object)"exec_phase", (Object)"pre_auth");
                break;
            }
            case "post_auth": {
                xp.put((Object)"exec_phase", (Object)"post_auth");
                break;
            }
            case "pre_token": {
                xp.put((Object)"exec_phase", (Object)"pre_token");
                break;
            }
            case "post_token": {
                xp.put((Object)"exec_phase", (Object)"post_token");
                break;
            }
            case "pre_refresh": {
                xp.put((Object)"exec_phase", (Object)"pre_refresh");
                break;
            }
            case "post_refresh": {
                xp.put((Object)"exec_phase", (Object)"post_refresh");
                break;
            }
            default: {
                xp.put((Object)"exec_phase", (Object)"none");
            }
        }
        File f = new File(absolutePath);
        Date createTS = new Date();
        createTS.setTime(f.lastModified());
        xp.put((Object)"id", (Object)relativePath);
        xp.put((Object)"language", (Object)"qdl");
        xp.put((Object)"lang_version", (Object)"1.6-QDL-SNAPSHOT");
        xp.put((Object)"script_version", (Object)"1.0");
        xp.put((Object)"create_ts", (Object)Iso8601.date2String((Date)createTS));
        xp.put((Object)"last_modified", (Object)Iso8601.date2String((Date)createTS));
        xp.put((Object)"length", (Object)f.length());
        QDLScript qdlScript = new QDLScript((Reader)new StringReader(script), xp);
        return qdlScript;
    }

    public static JSONObject readDir(File rootDir) throws Throwable {
        if (!rootDir.exists()) {
            throw new IllegalStateException("Error: \"" + String.valueOf(rootDir) + "\" does not exist.");
        }
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException("Error: \"" + String.valueOf(rootDir) + "\" must be a directory.");
        }
        if (!rootDir.canRead()) {
            throw new IllegalStateException("Error: \"" + String.valueOf(rootDir) + "\" cannot be read.");
        }
        JSONObject repo = new JSONObject();
        for (File file : rootDir.listFiles()) {
            if (file.isDirectory()) {
                QDLJSONConfigUtil.readDir(rootDir, file, repo);
                continue;
            }
            String relative = rootDir.toURI().relativize(file.toURI()).getPath();
            if (relative.endsWith(".qdl")) {
                QDLScript qdlScript = QDLJSONConfigUtil.createCfg(relative, file.getAbsolutePath());
                JSONScriptUtil.addScript((JSONObject)repo, (QDLScript)qdlScript);
                continue;
            }
            FileEntries.addFile((JSONObject)repo, (String)relative, (File)file, (int)-100);
        }
        return repo;
    }

    public static JSONObject readDir(File rootDir, File dir, JSONObject repo) throws Throwable {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                QDLJSONConfigUtil.readDir(rootDir, file, repo);
                continue;
            }
            String relative = rootDir.toURI().relativize(file.toURI()).getPath();
            if (relative.endsWith(".qdl")) {
                QDLScript qdlScript = QDLJSONConfigUtil.createCfg(relative, file.getAbsolutePath());
                JSONScriptUtil.addScript((JSONObject)repo, (QDLScript)qdlScript);
                continue;
            }
            FileEntries.addFile((JSONObject)repo, (String)relative, (File)file, (int)-100);
        }
        return repo;
    }

    public static JSONObject readDir(String directory) throws Throwable {
        return QDLJSONConfigUtil.readDir(new File(directory));
    }

    public static JSONObject createNCSA() {
        StringBuffer script = new StringBuffer();
        script.append("claims.uid := 'jgaynor';\n");
        script.append("f. := new_template('ncsa');\n");
        script.append("claim_sources.0. := create_source(f.);\n");
        XProperties xp = new XProperties();
        xp.put((Object)"exec_phase", (Object)"pre_auth");
        xp.put((Object)"id", (Object)"pre_auth.qdl");
        xp.put((Object)"language", (Object)"qdl");
        xp.put((Object)"lang_version", (Object)"1.0");
        xp.put((Object)"script_version", (Object)"1.0");
        QDLScript qdlScript = new QDLScript((Reader)new StringReader(script.toString()), xp);
        JSONObject scripts = JSONScriptUtil.createConfig();
        scripts = JSONScriptUtil.addScript((JSONObject)scripts, (QDLScript)qdlScript);
        script = new StringBuffer();
        script.append("if[");
        script.append("  in_group(claims.isMemberOf., 'all_users')");
        script.append("]then[");
        script.append("  claims.check := 'in group';");
        script.append("]else[");
        script.append("  claims.check := 'not in group';");
        script.append("]; //end if");
        xp = new XProperties();
        xp.put((Object)"exec_phase", (Object)"post_token");
        xp.put((Object)"id", (Object)"post_token.qdl");
        xp.put((Object)"language", (Object)"qdl");
        xp.put((Object)"lang_version", (Object)"1.0");
        xp.put((Object)"script_version", (Object)"1.0");
        qdlScript = new QDLScript((Reader)new StringReader(script.toString()), xp);
        scripts = JSONScriptUtil.addScript((JSONObject)scripts, (QDLScript)qdlScript);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)QDLRuntimeEngine.CONFIG_TAG, (Object)scripts);
        System.out.println(jsonObject.toString(2));
        return jsonObject;
    }

    protected JSONObject createFileEntry(String contents) {
        return new JSONObject();
    }

    public static JSONObject createFS() {
        JSONObject jsonObject = new JSONObject();
        StringBuffer script = new StringBuffer();
        script.append("f. := new_template('file');\n");
        script.append("f.file_path := '/home/ncsa/dev/ncsa-git/oa4mp/server-test/src/main/resources/test-claims.json';\n");
        script.append("claim_sources.0. := create_source(f.);\n");
        XProperties xp = new XProperties();
        xp.put((Object)"exec_phase", (Object)"init");
        xp.put((Object)"id", (Object)"init.qdl");
        xp.put((Object)"language", (Object)"qdl");
        xp.put((Object)"lang_version", (Object)"1.0");
        xp.put((Object)"script_version", (Object)"1.0");
        QDLScript qdlScript = new QDLScript((Reader)new StringReader(script.toString()), xp);
        JSONObject scripts = JSONScriptUtil.createConfig();
        JSONScriptUtil.addScript((JSONObject)scripts, (QDLScript)qdlScript);
        script = new StringBuffer();
        script.append("say(claim_sources.);");
        script.append("say(flow_states.);");
        xp = new XProperties();
        xp.put((Object)"exec_phase", (Object)"pre_token");
        xp.put((Object)"id", (Object)"pre_token.qdl");
        xp.put((Object)"language", (Object)"qdl");
        xp.put((Object)"lang_version", (Object)"1.0");
        xp.put((Object)"script_version", (Object)"1.0");
        qdlScript = new QDLScript((Reader)new StringReader(script.toString()), xp);
        scripts = JSONScriptUtil.createConfig();
        JSONScriptUtil.addScript((JSONObject)scripts, (QDLScript)qdlScript);
        jsonObject.put((Object)QDLRuntimeEngine.CONFIG_TAG, (Object)scripts);
        System.out.println(jsonObject.toString(2));
        return jsonObject;
    }

    protected static void testLoadDir() {
        try {
            String directory = DebugUtil.getDevPath() + "/oa4mp/qdl/src/main/resources/scripts";
            JSONObject j = QDLJSONConfigUtil.readDir(directory);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)QDLRuntimeEngine.CONFIG_TAG, (Object)j);
            System.out.println(jsonObject.toString(2));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.out.println(QDLJSONConfigUtil.createNCSA().toString(1));
    }
}

