/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.scripting;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.FileUtil;
import edu.uiuc.ncsa.security.util.mail.MailEnvironment;
import edu.uiuc.ncsa.security.util.scripting.ScriptInterface;
import edu.uiuc.ncsa.security.util.scripting.ScriptRunRequest;
import edu.uiuc.ncsa.security.util.scripting.ScriptRunResponse;
import edu.uiuc.ncsa.security.util.scripting.ScriptRuntimeEngine;
import edu.uiuc.ncsa.security.util.scripting.ScriptingConstants;
import edu.uiuc.ncsa.security.util.scripting.StateInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.oa4mp.delegation.server.jwt.ScriptRuntimeException;
import org.oa4mp.delegation.server.server.claims.ClaimSource;
import org.oa4mp.server.loader.oauth2.flows.FlowStates2;
import org.oa4mp.server.loader.oauth2.flows.FlowType;
import org.oa4mp.server.loader.oauth2.state.ScriptRuntimeEngineFactory;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.oa4mp.server.loader.qdl.OA2LibLoader;
import org.oa4mp.server.loader.qdl.claims.ConfigtoCS;
import org.oa4mp.server.loader.qdl.scripting.OA2QDLEnvironment;
import org.oa4mp.server.loader.qdl.scripting.OA2State;
import org.qdl_lang.config.QDLConfigurationLoaderUtils;
import org.qdl_lang.config.QDLEnvironment;
import org.qdl_lang.evaluate.OpEvaluator;
import org.qdl_lang.exceptions.QDLException;
import org.qdl_lang.exceptions.RaiseErrorException;
import org.qdl_lang.extensions.mail.QDLMail;
import org.qdl_lang.state.State;
import org.qdl_lang.state.StateUtils;
import org.qdl_lang.variables.QDLList;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;
import org.qdl_lang.variables.values.QDLValue;
import org.qdl_lang.variables.values.StemValue;
import org.qdl_lang.workspace.WorkspaceCommands;
import org.qdl_lang.xml.SerializationState;
import org.qdl_lang.xml.XMLUtils;

public class QDLRuntimeEngine
extends ScriptRuntimeEngine
implements ScriptingConstants {
    public static String CONFIG_TAG = "qdl";
    public static String SCRIPTS_TAG = "scripts";
    OA2QDLEnvironment qe;
    OA2State state;
    public static String SYS_ERR_VAR = "sys_err.";
    public static String SYS_ERR_OK = "ok";
    public static String SYS_ERR_MESSAGE = "message";
    public static String SYS_ERR_ERROR_TYPE = "error_type";
    public static String SYS_ERR_ERROR_URI = "error_uri";
    public static String SYS_ERR_CUSTOM_ERROR_URI = "custom_error_uri";
    public static String SYS_ERR_HTTP_STATUS_CODE = "status";
    public static String SYS_ERR_CODE = "code";
    public static String FLOW_STATE_VAR = "flow_states.";
    public static String CLAIMS_VAR = "claims.";
    public static String PROXY_CLAIMS_VAR = "proxy_claims.";
    public static String MAIL_VAR = "mail.";
    public static String MAIL_CFG_VAR = "cfg";
    public static String MAIL_MESSAGE_VAR = "message";
    public static String ACCESS_TOKEN_VAR = "access_token.";
    public static String REFRESH_TOKEN_VAR = "refresh_token.";
    public static String SCOPES_VAR = "scopes.";
    public static String EXTENDED_ATTRIBUTES_VAR = "xas.";
    public static String AUDIENCE_VAR = "audience.";
    public static String RESOURCE_VAR = "resource.";
    public static String TX_SCOPES_VAR = "tx_scopes.";
    public static String TX_AUDIENCE_VAR = "tx_audience.";
    public static String TX_RESOURCE_VAR = "tx_resource.";
    public static String CLAIM_SOURCES_VAR = "claim_sources.";
    public static String ACCESS_CONTROL = "access_control.";
    public static String AT_ORIGINAL_SCOPES = "at_original_scopes.";
    public static String AUTH_HEADERS_VAR = "auth_headers.";
    public static Long OA4MP_ERROR_CODE = 1000L;
    public static String OA4MP_ERROR_CODE_NAME = "oa4mp_error";
    protected ConfigtoCS configToCS;

    public QDLRuntimeEngine(OA2QDLEnvironment qe, OA2ServiceTransaction transaction) {
        this.qe = qe;
        this.init(transaction);
        this.setInitialized(false);
    }

    public OA2State getState() {
        return this.state;
    }

    public OA2QDLEnvironment getQE() {
        return this.qe;
    }

    public void setQE(OA2QDLEnvironment qe) {
        this.qe = qe;
    }

    protected void init(OA2ServiceTransaction transaction) {
        block11: {
            this.state = (OA2State)StateUtils.newInstance();
            if (OA2State.getRootState() == null) {
                OA2State.setRootState((State)this.state);
            }
            this.state.setServerMode(this.qe.isServerModeOn());
            this.state.setTransaction(transaction);
            if (!this.qe.isRestrictedIO()) {
                this.state.setRestrictedIO(false);
            } else if (transaction.getClient().isDebugOn()) {
                this.state.setRestrictedIO(false);
            } else {
                this.state.setRestrictedIO(true);
            }
            this.state.getOpEvaluator();
            OpEvaluator.setNumericDigits((int)this.qe.getNumericDigits());
            this.state.setScriptPaths(this.qe.getScriptPath());
            this.state.setAssertionsOn(this.qe.isAssertionsOn());
            OA2LibLoader loader = new OA2LibLoader();
            loader.add(this.state);
            if (this.qe != null && this.qe.isEnabled()) {
                try {
                    this.state.setLogger(this.qe.getMyLogger());
                    this.state.createSystemInfo(this.qe);
                    QDLConfigurationLoaderUtils.setupVFS((QDLEnvironment)this.qe, (State)this.state);
                    QDLConfigurationLoaderUtils.setupModules((QDLEnvironment)this.qe, (State)this.state);
                    QDLConfigurationLoaderUtils.runBootScript((QDLEnvironment)this.qe, (State)this.state);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (transaction.hasScriptState()) {
                try {
                    this.deserializeState(transaction.getScriptState(), transaction.getScriptStateSerializationVersion());
                }
                catch (Throwable t) {
                    DebugUtil.trace((Object)((Object)this), (String)("Could not deserialize stored transaction state:" + t.getMessage()));
                    if (this.getState().getOa2se() == null) break block11;
                    this.getState().getOa2se().getMyLogger().warn("Could not deserialize stored transaction state:" + t.getMessage());
                }
            }
        }
    }

    public String serializeState(String version) {
        if (version.equals("2.0")) {
            return this.serializeStateOLD();
        }
        return this.serializeState();
    }

    public String serializeState() {
        WorkspaceCommands workspaceCommands = new WorkspaceCommands();
        workspaceCommands.setState((State)this.state);
        SerializationState serializationState = new SerializationState();
        serializationState.setVersion("2.1");
        try {
            JSONObject json = this.state.serializeToJSON(serializationState);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(baos);
            gzipOutputStream.write(json.toString().getBytes("UTF-8"));
            gzipOutputStream.flush();
            gzipOutputStream.close();
            return Base64.encodeBase64String((byte[])baos.toByteArray());
        }
        catch (Throwable e) {
            throw new QDLException("Error: could not serialize the state:" + e.getMessage(), e);
        }
    }

    public String serializeStateOLD() {
        try {
            StringWriter w = new StringWriter();
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            XMLStreamWriter xsw = xof.createXMLStreamWriter(w);
            WorkspaceCommands workspaceCommands = new WorkspaceCommands();
            workspaceCommands.setState((State)this.state);
            workspaceCommands.toXML(xsw);
            String xml2 = XMLUtils.prettyPrint((String)w.toString());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(baos);
            gzipOutputStream.write(xml2.getBytes("UTF-8"));
            gzipOutputStream.flush();
            gzipOutputStream.close();
            xsw.close();
            return Base64.encodeBase64String((byte[])baos.toByteArray());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new QDLException("Error: could not serialize the state:" + e.getMessage(), e);
        }
    }

    protected void deserializeStateOLDXML(String rawState) {
        if (rawState == null || rawState.isEmpty()) {
            return;
        }
        try {
            byte[] xx = Base64.decodeBase64((String)rawState);
            ByteArrayInputStream bais = new ByteArrayInputStream(xx);
            GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)bais, 65536);
            InputStreamReader r = new InputStreamReader(gzipInputStream);
            XMLInputFactory xmlif = XMLInputFactory.newInstance();
            XMLEventReader xer = xmlif.createXMLEventReader(r);
            this.state.fromXML(xer, null);
            xer.close();
        }
        catch (Throwable e) {
            DebugUtil.trace((Object)((Object)this), (String)"error deserializing state", (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new QDLException("Error deserializing state", e);
        }
    }

    public void deserializeState(String rawState, String version) {
        if (rawState == null || rawState.isEmpty()) {
            return;
        }
        if (version.isEmpty() || version.equals("2.0")) {
            this.deserializeStateXML2_0(rawState);
            return;
        }
        try {
            this.deserializeJSON2_1(rawState);
        }
        catch (Throwable t) {
            this.deserializeStateXML2_0(rawState);
        }
    }

    protected void deserializeJSON2_1(String rawState) {
        try {
            byte[] bytes = Base64.decodeBase64((String)rawState);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)bais, 65536);
            String rawJSON = FileUtil.readFileAsString((InputStream)gzipInputStream);
            SerializationState serializationState = new SerializationState();
            serializationState.setVersion("2.1");
            this.state.deserializeFromJSON(JSONObject.fromObject((Object)rawJSON), serializationState);
        }
        catch (Throwable e) {
            DebugUtil.trace((Object)((Object)this), (String)"error deserializing state", (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new QDLException("Error deserializing state", e);
        }
    }

    protected void deserializeStateXML2_0(String rawState) {
        try {
            byte[] xx = Base64.decodeBase64((String)rawState);
            ByteArrayInputStream bais = new ByteArrayInputStream(xx);
            GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)bais, 65536);
            InputStreamReader r = new InputStreamReader(gzipInputStream);
            XMLInputFactory xmlif = XMLInputFactory.newInstance();
            XMLEventReader xer = xmlif.createXMLEventReader(r);
            try {
                WorkspaceCommands workspaceCommands = new WorkspaceCommands();
                workspaceCommands.setDebugOn(true);
                workspaceCommands.fromXML(xer, this.getQE().isSkipBadModulesOnLoad());
                this.state = (OA2State)workspaceCommands.getInterpreter().getState();
            }
            catch (Throwable t) {
                this.deserializeStateOLDXML(rawState);
            }
        }
        catch (Throwable e) {
            DebugUtil.trace((Object)((Object)this), (String)"error deserializing state", (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new QDLException("Error deserializing state", e);
        }
    }

    protected List<ScriptInterface> getScript(String phase) {
        if (this.getScriptSet() == null) {
            return null;
        }
        return this.getScriptSet().get("exec_phase", phase);
    }

    protected List<ScriptInterface> getServerScript(String phase) {
        if (this.getQE().getServerScripts() == null || this.getQE().getServerScripts().isEmpty()) {
            return null;
        }
        return this.getQE().getServerScripts().get("exec_phase", phase);
    }

    public ScriptRunResponse run(ScriptRunRequest request) {
        List<ScriptInterface> scripts = this.getScript(request.getAction());
        if (scripts == null || scripts.isEmpty()) {
            return this.noOpSRR();
        }
        this.createSRRequest(request);
        try {
            for (ScriptInterface s : scripts) {
                s.execute((StateInterface)this.state);
            }
        }
        catch (RaiseErrorException rex) {
            this.processSRX(rex);
        }
        return this.createSRResponse();
    }

    void processSRX(RaiseErrorException raiseErrorException) {
        if (raiseErrorException.getErrorCode().equals(OA4MP_ERROR_CODE)) {
            QDLStem sysErr = raiseErrorException.getState();
            String message = raiseErrorException.getMessage();
            String requestedType = sysErr.containsKey((Object)SYS_ERR_ERROR_TYPE) ? sysErr.getString(SYS_ERR_ERROR_TYPE) : "access_denied";
            int httpStatus = sysErr.containsKey((Object)SYS_ERR_HTTP_STATUS_CODE) ? sysErr.getLong(SYS_ERR_HTTP_STATUS_CODE).intValue() : 401;
            int errorCode = sysErr.containsKey((Object)SYS_ERR_CODE) ? sysErr.getLong(SYS_ERR_CODE).intValue() : -1;
            URI errorURI = sysErr.containsKey((Object)SYS_ERR_ERROR_URI) ? URI.create(sysErr.getString(SYS_ERR_ERROR_URI)) : null;
            URI customErrorURI = sysErr.containsKey((Object)SYS_ERR_CUSTOM_ERROR_URI) ? URI.create(sysErr.getString(SYS_ERR_CUSTOM_ERROR_URI)) : null;
            ScriptRuntimeException scriptRuntimeException = new ScriptRuntimeException(message == null ? "(no message)" : message);
            scriptRuntimeException.setCode(errorCode);
            scriptRuntimeException.setErrorURI(errorURI);
            scriptRuntimeException.setCustomErrorURI(customErrorURI);
            if (httpStatus == -1 && customErrorURI != null) {
                scriptRuntimeException.setHttpStatus(302);
            } else {
                scriptRuntimeException.setHttpStatus(httpStatus);
            }
            scriptRuntimeException.setRequestedType(requestedType);
            throw scriptRuntimeException;
        }
        this.getState().getLogger().warn("Unhandled QDL exception:" + raiseErrorException.getMessage(), (Throwable)raiseErrorException);
        DebugUtil.error((String)"Unhandled QDL exception", (Throwable)raiseErrorException);
        throw raiseErrorException;
    }

    protected void createSRRequest(ScriptRunRequest req) {
        List scopes;
        QDLStem atStem;
        JSONObject at;
        this.state.setValue("exec_phase", QDLValue.asQDLValue((Object)req.getAction()));
        QDLStem sysErr = new QDLStem();
        StemUtility.put((QDLStem)sysErr, (Object)SYS_ERR_OK, (Object)Boolean.TRUE);
        this.state.setValue(SYS_ERR_VAR, QDLValue.asQDLValue((Object)sysErr));
        this.state.setValue(OA4MP_ERROR_CODE_NAME, QDLValue.asQDLValue((Object)OA4MP_ERROR_CODE));
        if (this.state.getOa2se().getMailUtil().isEnabled()) {
            QDLStem mailStem = new QDLStem();
            QDLStem mailCfg = QDLMail.convertMEToStem((MailEnvironment)this.state.getOa2se().getMailUtil().getMailEnvironment());
            StemUtility.put((QDLStem)mailStem, (Object)MAIL_CFG_VAR, (Object)mailCfg);
            QDLList body = new QDLList();
            try {
                if (this.state.getOa2se().getMailUtil().getSubjectTemplate() == null) {
                    body.add(QDLValue.asQDLValue((Object)"(no subject)"));
                } else {
                    body.add(QDLValue.asQDLValue((Object)this.state.getOa2se().getMailUtil().getSubjectTemplate()));
                }
                if (this.state.getOa2se().getMailUtil().getMessageTemplate() == null) {
                    body.add(QDLValue.asQDLValue((Object)"(no content)"));
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(this.state.getOa2se().getMailUtil().getMessageTemplate(), "\n");
                    while (stringTokenizer.hasMoreTokens()) {
                        body.add(QDLValue.asQDLValue((Object)stringTokenizer.nextToken()));
                    }
                }
                StemUtility.put((QDLStem)mailStem, (Object)MAIL_MESSAGE_VAR, (Object)new QDLStem(body));
            }
            catch (IOException iox) {
                this.getState().getLogger().warn("could not get mail message for QDL runtime environment");
            }
            this.state.setValue(MAIL_VAR, QDLValue.asQDLValue((Object)mailStem));
        }
        FlowStates2 flowStates = (FlowStates2)((Object)req.getArgs().get("flow_states"));
        this.state.setValue(FLOW_STATE_VAR, QDLValue.asQDLValue((Object)this.toStem(flowStates)));
        JSONObject claims = (JSONObject)req.getArgs().get("claims");
        QDLStem claimStem = new QDLStem();
        if (claims != null) {
            claimStem.fromJSON(claims);
        }
        this.state.setValue(CLAIMS_VAR, QDLValue.asQDLValue((Object)claimStem));
        JSONObject proxyClaims = (JSONObject)req.getArgs().get("proxy_claims");
        QDLStem proxyClaimsStem = new QDLStem();
        proxyClaimsStem.fromJSON(proxyClaims);
        this.state.setValue(PROXY_CLAIMS_VAR, QDLValue.asQDLValue((Object)proxyClaimsStem));
        QDLStem authHeaders = new QDLStem();
        if (req.getArgs().containsKey("auth_headers")) {
            authHeaders.fromJSON((JSONObject)req.getArgs().get("auth_headers"));
        }
        this.state.setValue(AUTH_HEADERS_VAR, QDLValue.asQDLValue((Object)authHeaders));
        if (req.getArgs().containsKey("access_token")) {
            at = (JSONObject)req.getArgs().get("access_token");
            atStem = new QDLStem();
            atStem.fromJSON(at);
            this.state.setValue(ACCESS_TOKEN_VAR, QDLValue.asQDLValue((Object)atStem));
        }
        if (req.getArgs().containsKey("refresh_token")) {
            at = (JSONObject)req.getArgs().get("refresh_token");
            atStem = new QDLStem();
            atStem.fromJSON(at);
            this.state.setValue(REFRESH_TOKEN_VAR, QDLValue.asQDLValue((Object)atStem));
        }
        if ((scopes = (List)req.getArgs().get("scopes")) != null && !scopes.isEmpty()) {
            this.state.setValue(SCOPES_VAR, QDLValue.asQDLValue((Object)this.listToStem(scopes)));
        } else {
            this.state.setValue(SCOPES_VAR, (QDLValue)new StemValue());
        }
        List audience = (List)req.getArgs().get("audience");
        if (audience != null && !audience.isEmpty()) {
            this.state.setValue(AUDIENCE_VAR, QDLValue.asQDLValue((Object)this.listToStem(audience)));
        } else {
            this.state.setValue(AUDIENCE_VAR, (QDLValue)new StemValue());
        }
        List resource = (List)req.getArgs().get("resource");
        if (resource != null && !resource.isEmpty()) {
            this.state.setValue(RESOURCE_VAR, QDLValue.asQDLValue((Object)this.listToStem(resource)));
        } else {
            this.state.setValue(RESOURCE_VAR, (QDLValue)new StemValue());
        }
        Object eas = req.getArgs().get("eas");
        if (eas != null && eas instanceof JSONObject) {
            QDLStem eaStem = new QDLStem();
            eaStem.fromJSON((JSONObject)eas);
            this.state.setValue(EXTENDED_ATTRIBUTES_VAR, QDLValue.asQDLValue((Object)eaStem));
        } else {
            this.state.setValue(EXTENDED_ATTRIBUTES_VAR, (QDLValue)new StemValue());
        }
        QDLStem sources = new QDLStem();
        int i = 0;
        if (req.getArgs().containsKey("claim_sources")) {
            for (ClaimSource source : (List)req.getArgs().get("claim_sources")) {
                if (!source.hasConfiguration()) continue;
                StemUtility.put((QDLStem)sources, (Object)(i + "."), (Object)source.toQDL());
                ++i;
            }
        }
        this.state.setValue(CLAIM_SOURCES_VAR, QDLValue.asQDLValue((Object)sources));
        QDLStem acl = new QDLStem();
        StemUtility.put((QDLStem)acl, (Object)"client_id", (Object)this.state.getClientID().toString());
        ArrayList<String> adminIDs = new ArrayList<String>();
        for (Identifier id : this.state.getAdminIDs()) {
            adminIDs.add(id.toString());
        }
        QDLStem adminStem = new QDLStem();
        adminStem.addList(adminIDs);
        StemUtility.put((QDLStem)acl, (Object)"admins.", (Object)adminStem);
        this.state.setValue(ACCESS_CONTROL, QDLValue.asQDLValue((Object)acl));
        QDLStem txScopes = new QDLStem();
        QDLStem txRes = new QDLStem();
        QDLStem txAud = new QDLStem();
        if (this.state.getTxRecord() != null) {
            TXRecord txr = this.state.getTxRecord();
            if (txr.hasScopes()) {
                txScopes.addList(txr.getScopes());
            }
            if (txr.hasAudience()) {
                txAud.addList(txr.getAudience());
            }
            if (txr.hasResources()) {
                for (URI uri : txr.getResource()) {
                    txRes.listAdd(QDLValue.asQDLValue((Object)uri.toString()));
                }
            }
        }
        this.state.setValue(TX_SCOPES_VAR, QDLValue.asQDLValue((Object)txScopes));
        this.state.setValue(TX_AUDIENCE_VAR, QDLValue.asQDLValue((Object)txAud));
        this.state.setValue(TX_RESOURCE_VAR, QDLValue.asQDLValue((Object)txRes));
        QDLStem originalScopes = new QDLStem();
        if (this.state.getTransaction().hasATReturnedOriginalScopes()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(this.state.getTransaction().getATReturnedOriginalScopes());
            originalScopes.getQDLList().appendAll(arrayList);
        }
        this.state.setValue(AT_ORIGINAL_SCOPES, QDLValue.asQDLValue((Object)originalScopes));
    }

    public QDLStem listToStem(List<String> scopes) {
        QDLStem scopeStem = new QDLStem();
        for (int i = 0; i < scopes.size(); ++i) {
            String index = Integer.toString(i);
            StemUtility.put((QDLStem)scopeStem, (Object)index, (Object)scopes.get(i));
        }
        return scopeStem;
    }

    public List<String> stemToList(QDLStem arg) {
        ArrayList<String> scopes = new ArrayList<String>();
        for (Object key : arg.keySet()) {
            scopes.add(String.valueOf(arg.get(key)));
        }
        return scopes;
    }

    public ConfigtoCS getConfigToCS() {
        if (this.configToCS == null) {
            this.configToCS = new ConfigtoCS();
        }
        return this.configToCS;
    }

    public void setConfigToCS(ConfigtoCS configToCS) {
        this.configToCS = configToCS;
    }

    protected List<ClaimSource> toSources(QDLStem QDLStem2) {
        ArrayList<ClaimSource> claimSources = new ArrayList<ClaimSource>();
        for (int i = 0; i < QDLStem2.size(); ++i) {
            if (!QDLStem2.containsKey((Object)i)) continue;
            QDLStem cfg = QDLStem2.get(Long.valueOf(i)).asStem();
            claimSources.add(this.getConfigToCS().convert(cfg, this.state, this.state.getOa2se()));
        }
        return claimSources;
    }

    public QDLStem toStem(FlowStates2 flowStates) {
        QDLStem QDLStem2 = new QDLStem();
        StemUtility.put((QDLStem)QDLStem2, (Object)this.getGTName(FlowType.ACCEPT_REQUESTS), (Object)flowStates.acceptRequests);
        StemUtility.put((QDLStem)QDLStem2, (Object)this.getGTName(FlowType.ACCESS_TOKEN), (Object)flowStates.accessToken);
        StemUtility.put((QDLStem)QDLStem2, (Object)this.getGTName(FlowType.GET_CERT), (Object)flowStates.getCert);
        StemUtility.put((QDLStem)QDLStem2, (Object)this.getGTName(FlowType.GET_CLAIMS), (Object)flowStates.getClaims);
        StemUtility.put((QDLStem)QDLStem2, (Object)this.getGTName(FlowType.ID_TOKEN), (Object)flowStates.idToken);
        StemUtility.put((QDLStem)QDLStem2, (Object)this.getGTName(FlowType.REFRESH_TOKEN), (Object)flowStates.refreshToken);
        StemUtility.put((QDLStem)QDLStem2, (Object)this.getGTName(FlowType.USER_INFO), (Object)flowStates.userInfo);
        StemUtility.put((QDLStem)QDLStem2, (Object)this.getGTName(FlowType.AT_DO_TEMPLATES), (Object)flowStates.at_do_templates);
        return QDLStem2;
    }

    protected String getGTName(FlowType type) {
        return type.getValue().substring(1);
    }

    public FlowStates2 toFS(QDLStem stem) {
        FlowStates2 f = new FlowStates2();
        f.acceptRequests = stem.getBoolean(this.getGTName(FlowType.ACCEPT_REQUESTS));
        f.accessToken = stem.getBoolean(this.getGTName(FlowType.ACCESS_TOKEN));
        f.getCert = stem.getBoolean(this.getGTName(FlowType.GET_CERT));
        f.getClaims = stem.getBoolean(this.getGTName(FlowType.GET_CLAIMS));
        f.idToken = stem.getBoolean(this.getGTName(FlowType.ID_TOKEN));
        f.refreshToken = stem.getBoolean(this.getGTName(FlowType.REFRESH_TOKEN));
        f.userInfo = stem.getBoolean(this.getGTName(FlowType.USER_INFO));
        f.at_do_templates = stem.getBoolean(this.getGTName(FlowType.AT_DO_TEMPLATES));
        return f;
    }

    protected ScriptRunResponse noOpSRR() {
        return ScriptRuntimeEngineFactory.NoOpRuntimeEngine.srr;
    }

    protected ScriptRunResponse createSRResponse() {
        HashMap<String, Object> respMap;
        block21: {
            QDLStem sysErr;
            QDLValue x = this.state.getValue(SYS_ERR_VAR);
            if (x != null && x instanceof QDLStem && (sysErr = (QDLStem)x).containsKey((Object)SYS_ERR_OK) && !sysErr.getBoolean(SYS_ERR_OK).booleanValue()) {
                String message = sysErr.getString(SYS_ERR_MESSAGE);
                ScriptRuntimeException scriptRuntimeException = new ScriptRuntimeException(message == null ? "(no message)" : message);
                if (sysErr.containsKey((Object)SYS_ERR_ERROR_TYPE)) {
                    scriptRuntimeException.setRequestedType(sysErr.getString(SYS_ERR_ERROR_TYPE));
                } else {
                    scriptRuntimeException.setRequestedType("access_denied");
                }
                if (sysErr.containsKey((Object)SYS_ERR_HTTP_STATUS_CODE)) {
                    scriptRuntimeException.setHttpStatus(sysErr.getLong(SYS_ERR_HTTP_STATUS_CODE).intValue());
                } else {
                    scriptRuntimeException.setHttpStatus(401);
                }
                if (sysErr.containsKey((Object)SYS_ERR_CODE)) {
                    scriptRuntimeException.setCode(sysErr.getLong(SYS_ERR_CODE).intValue());
                }
                if (sysErr.containsKey((Object)SYS_ERR_ERROR_URI)) {
                    scriptRuntimeException.setErrorURI(URI.create(sysErr.getString(SYS_ERR_ERROR_URI)));
                }
                if (sysErr.containsKey((Object)SYS_ERR_CUSTOM_ERROR_URI)) {
                    scriptRuntimeException.setCustomErrorURI(URI.create(sysErr.getString(SYS_ERR_CUSTOM_ERROR_URI)));
                }
                throw scriptRuntimeException;
            }
            respMap = new HashMap<String, Object>();
            QDLStem flowStem = this.state.getValue(FLOW_STATE_VAR).asStem();
            respMap.put("flow_states", (Object)this.toFS(flowStem));
            respMap.put("claim_sources", this.toSources(this.state.getValue(CLAIM_SOURCES_VAR).asStem()));
            respMap.put("scopes", this.stemToList(this.state.getValue(SCOPES_VAR).asStem()));
            respMap.put("eas", this.state.getValue(EXTENDED_ATTRIBUTES_VAR).asStem().toJSON());
            if (this.state.getValue(ACCESS_TOKEN_VAR) != null) {
                respMap.put("access_token", this.state.getValue(ACCESS_TOKEN_VAR).asStem().toJSON());
            }
            if (this.state.getValue(REFRESH_TOKEN_VAR) != null) {
                respMap.put("refresh_token", this.state.getValue(REFRESH_TOKEN_VAR).asStem().toJSON());
            }
            respMap.put("audience", this.stemToList(this.state.getValue(AUDIENCE_VAR).asStem()));
            respMap.put("resource", this.stemToList(this.state.getValue(RESOURCE_VAR).asStem()));
            QDLValue z = this.state.getValue(CLAIMS_VAR);
            QDLStem stemClaims = z.isNull() ? new QDLStem() : this.state.getValue(CLAIMS_VAR).asStem();
            JSON j = stemClaims.toJSON();
            if (j.isArray()) {
                throw new NFWException("Internal error: The returned claims object was not a JSON Object.");
            }
            respMap.put("claims", j);
            DebugUtil.trace((Object)((Object)this), (String)("QDL updates response map:" + j.toString(1)));
            if (this.state.isDefined(TX_SCOPES_VAR)) {
                respMap.put("tx_scopes", this.stemToList(this.state.getValue(TX_SCOPES_VAR).asStem()));
            }
            if (this.state.isDefined(TX_AUDIENCE_VAR)) {
                respMap.put("tx_audience", this.stemToList(this.state.getValue(TX_AUDIENCE_VAR).asStem()));
            }
            if (this.state.isDefined(TX_RESOURCE_VAR)) {
                List<String> res = this.stemToList(this.state.getValue(TX_RESOURCE_VAR).asStem());
                ArrayList<URI> zz = new ArrayList<URI>();
                for (String r : res) {
                    try {
                        zz.add(URI.create(r));
                    }
                    catch (Throwable t) {
                        this.getState().getLogger().warn("Illegal uri in stem conversion for token exchange resources: \"" + r + "\". Skipping");
                    }
                }
                respMap.put("tx_resources", zz);
            }
            try {
                this.cleanUpState(new String[]{ACCESS_TOKEN_VAR, AUDIENCE_VAR, CLAIMS_VAR, CLAIM_SOURCES_VAR, "exec_phase", EXTENDED_ATTRIBUTES_VAR, FLOW_STATE_VAR, PROXY_CLAIMS_VAR, REFRESH_TOKEN_VAR, RESOURCE_VAR, SCOPES_VAR, SYS_ERR_VAR, TX_AUDIENCE_VAR, TX_RESOURCE_VAR, TX_SCOPES_VAR});
                if (this.state.getTransaction().hasScriptStateSerializationVersion()) {
                    this.state.getTransaction().setScriptState(this.serializeState(this.state.getTransaction().getScriptStateSerializationVersion()));
                } else {
                    this.state.getTransaction().setScriptState(this.serializeState("2.1"));
                }
                this.state.getTransaction().setScriptStateSerialzationVersion("2.1");
            }
            catch (Throwable t) {
                DebugUtil.trace((Object)((Object)this), (String)("Could not serialize stored transaction state:" + t.getMessage()));
                if (this.getState().getOa2se() == null) break block21;
                this.getState().getOa2se().getMyLogger().warn("Could not serialize stored transaction state:" + t.getMessage());
            }
        }
        return new ScriptRunResponse("ok", respMap, 1);
    }

    protected void cleanUpState(String[] varNames) {
        for (String varName : varNames) {
            if (!this.state.isDefined(varName)) continue;
            this.state.remove(varName);
        }
    }
}

