/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.util;

import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import edu.uiuc.ncsa.security.util.jwk.JWKUtil2;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.server.JWTUtil;
import org.oa4mp.delegation.server.jwt.MyOtherJWTUtil2;
import org.oa4mp.server.loader.oauth2.state.ExtendedParameters;
import org.oa4mp.server.loader.qdl.scripting.OA2State;
import org.oa4mp.server.loader.qdl.util.SigningCommands;
import org.qdl_lang.exceptions.BadArgException;
import org.qdl_lang.exceptions.QDLException;
import org.qdl_lang.extensions.QDLFunction;
import org.qdl_lang.extensions.QDLVariable;
import org.qdl_lang.state.State;
import org.qdl_lang.util.QDLFileUtil;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;
import org.qdl_lang.variables.values.BooleanValue;
import org.qdl_lang.variables.values.QDLNullValue;
import org.qdl_lang.variables.values.QDLValue;
import org.qdl_lang.variables.values.StringValue;

public class JWTCommands {
    JWKUtil2 jwkUtil;
    JSONWebKeys jwks;
    QDLStem jwkStem;
    transient MyLoggingFacade logger = null;
    transient SigningCommands signingCommands = null;
    transient JWKUtil2 jsonWebKeyUtil = null;
    protected String CREATE_KEYS_NAME = "create_keys";
    public static String ARG_KEY_TYPE = "type";
    public static String ARG_DEFAULT_KEY_ID = "default_key_id";
    public static String ARG_RSA_KEY_SIZE_TYPE = "size";
    public static String ARG_EC_CURVE_TYPE = "curve";
    public static String ARG_FILE_PATH_TYPE = "file";
    public static String ARG_FILE_OVERWRITE_TYPE = "force";
    public static String ARG_SET_TO_CURRENT_KEYS_TYPE = "set";
    protected String LOAD_KEYS_NAME = "load_keys";
    protected String SAVE_KEYS_NAME = "save_keys";
    SecureRandom random = new SecureRandom();
    protected String DEFAULT_KEY_NAME = "default_key";
    protected String CURRENT_KEYS = "jwks";
    protected String CREATE_JWT_NAME = "create_jwt";
    protected String KEY_INFO_NAME = "key_info";
    protected String VERIFY_JWT_NAME = "verify_jwt";
    protected String GET_HEADER_NAME = "get_header";
    protected String GET_PAYLOAD_NAME = "get_payload";
    protected String CREATE_UUID = "create_uuid";

    public boolean hasJWKS() {
        return this.jwks != null && !this.jwks.isEmpty();
    }

    public JSONWebKeys getJwks() {
        return this.jwks;
    }

    public void setJwks(JSONWebKeys jwks) {
        if (jwks == null) {
            this.jwkStem = null;
        } else {
            this.jwkStem = new QDLStem();
            this.jwkStem.fromJSON(this.getJsonWebKeyUtil().toJSON(jwks));
        }
        this.jwks = jwks;
    }

    public QDLStem getJwkStem() {
        return this.jwkStem;
    }

    public JWKUtil2 getJwkUtil() {
        if (this.jwkUtil == null) {
            this.jwkUtil = new JWKUtil2();
        }
        return this.jwkUtil;
    }

    public void setJwkUtil(JWKUtil2 jwkUtil) {
        this.jwkUtil = jwkUtil;
    }

    public JWTCommands(MyLoggingFacade logger) {
        this.logger = logger;
    }

    public MyLoggingFacade getLogger() {
        return this.logger;
    }

    public void setLogger(MyLoggingFacade logger) {
        this.logger = logger;
    }

    public SigningCommands getSigningCommands() throws Throwable {
        if (this.signingCommands == null) {
            CLIDriver cli = new CLIDriver();
            cli.setVerbose(false);
            this.signingCommands = new SigningCommands(cli, null);
        }
        return this.signingCommands;
    }

    public JWKUtil2 getJsonWebKeyUtil() {
        if (this.jsonWebKeyUtil == null) {
            this.jsonWebKeyUtil = new JWKUtil2();
        }
        return this.jsonWebKeyUtil;
    }

    protected void writeWebkeys(State state, JSONObject jsonObject, String target) throws Throwable {
        QDLFileUtil.writeTextFile((State)state, (String)target, (String)jsonObject.toString(2));
    }

    public class Create_UUID
    implements QDLFunction {
        public String getName() {
            return JWTCommands.this.CREATE_UUID;
        }

        public int[] getArgCount() {
            return new int[]{0};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            UUID uuid = UUID.randomUUID();
            return QDLValue.asQDLValue((Object)uuid.toString());
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + " create a new uuid.");
            doxx.add("This returns a string.");
            return doxx;
        }
    }

    public class TestClaims
    implements QDLVariable {
        QDLStem QDLStem = null;
        String rawJSON = "{\n  \"iss\": \"https://test.cilogon.org\",\n  \"sub\": \"http://cilogon.org/serverT/users/17048\",\n  \"aud\": \"myproxy:oa4mp,2012:/client_id/910d7984412870aa6e199f9afrab8\",\n  \"auth_time\": \"" + System.currentTimeMillis() / 1000L + "\",\n  \"exp\": " + (950400L + System.currentTimeMillis() / 1000L) + ",\n  \"iat\": " + System.currentTimeMillis() / 1000L + ",\n  \"nonce\": \"R72KPZ4Pwo9nPd9z1qCA04hBALMC-yVGUOGyTn-miHo\",\n  \"email\": \"bob@bigstate.edu\",\n  \"given_name\": \"Robert\",\n  \"family_name\": \"Bruce\",\n  \"name\": \"Roibert a Briuis\",\n  \"cert_subject_dn\": \"/DC=org/DC=cilogon/C=US/O=Big State Supercomputing Center/CN=Robert Bruce T17099\",\n  \"idp\": \"https://idp.bigstate.edu/idp/shibboleth\",\n  \"idp_name\": \"Supercomputing at BSU\",\n  \"eppn\": \"rbriuis@bigstate.edu\",\n  \"eptid\": \"https://idp.bigstate.edu/idp/shibboleth!https://cilogon.org/shibboleth!65P3o9FNjrp4z6+WI7Dir/4I=\",\n  \"affiliation\": \"staff@bigstate.edu;employee@bigstate.edu;member@bigstate.edu\",\n  \"acr\": \"https://refeds.org/profile/mfa\",\n  \"uid\": \"rbriuis\",\n  \"voPersonExternalID\": \"rbriuis@bigstate.edu\",\n  \"uidNumber\": \"55939\",\n  \"isMemberOf\":   [  {\n      \"name\": \"all_users\",\n      \"id\": 13002\n    },\n        {\n      \"name\": \"staff_reporting\",\n      \"id\": 16405\n    },\n        {\n      \"name\": \"list_allbsu\",\n      \"id\": 18942\n    }\n  ]\n}";

        public String getName() {
            return "test_claims.";
        }

        public Object getValue() {
            if (this.QDLStem == null) {
                this.QDLStem = new QDLStem();
                this.QDLStem.fromJSON(JSONObject.fromObject((Object)this.rawJSON));
            }
            return this.QDLStem;
        }
    }

    public class TestAudience
    implements QDLVariable {
        QDLStem QDLStem = null;

        public String getName() {
            return "test_audience.";
        }

        public Object getValue() {
            if (this.QDLStem == null) {
                this.QDLStem = new QDLStem();
                ArrayList<String> audience = new ArrayList<String>();
                audience.add("https://foo.edu/bar");
                audience.add("https://foo.edu/baz");
                this.QDLStem.addList(audience);
            }
            return this.QDLStem;
        }
    }

    public class TestXAs
    implements QDLVariable {
        QDLStem QDLStem = null;

        public String getName() {
            return "test_xas.";
        }

        public Object getValue() {
            if (this.QDLStem == null) {
                this.QDLStem = new QDLStem();
                HashMap<String, String[]> pmap = new HashMap<String, String[]>();
                pmap.put(ExtendedParameters.OA4MP_NS + ":/roles/", new String[]{"A", "B", "C"});
                pmap.put(ExtendedParameters.OA4MP_NS + ":/tokens/id/lifetime", new String[]{"100000000"});
                pmap.put(ExtendedParameters.OA4MP_NS + ":/tokens/access/lifetime", new String[]{"500000"});
                ExtendedParameters xp = new ExtendedParameters();
                JSONObject jsonObject = xp.snoopParameters(pmap);
                this.QDLStem.fromJSON(jsonObject);
            }
            return this.QDLStem;
        }
    }

    public class TestScopes
    implements QDLVariable {
        QDLStem QDLStem = null;

        public String getName() {
            return "test_scopes.";
        }

        public Object getValue() {
            if (this.QDLStem == null) {
                this.QDLStem = new QDLStem();
                ArrayList<String> scopes = new ArrayList<String>();
                scopes.add("wlcg");
                scopes.add("compute.exec:/");
                scopes.add("compute.create:/");
                scopes.add("storage.write:/store/data");
                scopes.add("storage.read:/store ");
                this.QDLStem.addList(scopes);
            }
            return this.QDLStem;
        }
    }

    public class GetPayload
    implements QDLFunction {
        public String getName() {
            return JWTCommands.this.GET_PAYLOAD_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            String token = objects[0].asString();
            JSONObject[] array = JWTUtil.readJWT((String)token);
            QDLStem QDLStem2 = new QDLStem();
            QDLStem2.fromJSON(array[1]);
            return QDLValue.asQDLValue((Object)QDLStem2);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> docs = new ArrayList<String>();
            docs.add(this.getName() + "(arg) takes a JWT and returns the payload as a stem. This does no verification.");
            docs.add("See also:" + JWTCommands.this.GET_HEADER_NAME);
            return docs;
        }
    }

    public class GetHeader
    implements QDLFunction {
        public String getName() {
            return JWTCommands.this.GET_HEADER_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            String token = objects[0].asString();
            JSONObject[] array = JWTUtil.readJWT((String)token);
            QDLStem QDLStem2 = new QDLStem();
            QDLStem2.fromJSON(array[0]);
            return QDLValue.asQDLValue((Object)QDLStem2);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> docs = new ArrayList<String>();
            docs.add(this.getName() + "(arg) takes a JWT and returns the header as a stem. This does no verification.");
            docs.add("See also:" + JWTCommands.this.GET_PAYLOAD_NAME);
            return docs;
        }
    }

    public class VerifyJWT
    implements QDLFunction {
        public String getName() {
            return JWTCommands.this.VERIFY_JWT_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1, 2};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (!JWTCommands.this.hasJWKS()) {
                throw new IllegalStateException(" No keys have been set.");
            }
            URI well_known = null;
            if (objects.length == 2) {
                try {
                    well_known = URI.create(objects[1].asString());
                }
                catch (Throwable t) {
                    throw new BadArgException(" The second argument \"" + String.valueOf(objects[1]) + "\" must be a valid URI.", 1);
                }
            }
            String token = objects[0].toString();
            JSONObject json = well_known == null ? JWTUtil.verifyAndReadJWT((String)token, (JSONWebKeys)JWTCommands.this.jwks) : JWTUtil.verifyAndReadJWT((String)token, (URI)well_known);
            QDLStem QDLStem2 = new QDLStem();
            QDLStem2.fromJSON(json);
            return QDLValue.asQDLValue((Object)QDLStem2);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> docs = new ArrayList<String>();
            switch (argCount) {
                case 1: {
                    docs.add(this.getName() + "(jwt) - This will decode the jwt and verify the signature, using the current set of keys.");
                    break;
                }
                case 2: {
                    docs.add(this.getName() + "(jwt, url) - This will decode the jwt and verify the signature using the");
                    docs.add("well-known url for a service and the (public) key there.");
                }
            }
            docs.add("If the signature is not valid, an error is raised.");
            docs.add("See also:" + JWTCommands.this.DEFAULT_KEY_NAME + ", " + JWTCommands.this.CREATE_KEYS_NAME);
            return docs;
        }
    }

    public class KeyInfo
    implements QDLFunction {
        public String getName() {
            return JWTCommands.this.KEY_INFO_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (!JWTCommands.this.hasJWKS()) {
                throw new IllegalStateException(" No keys have been set.");
            }
            QDLStem QDLStem2 = new QDLStem();
            if (JWTCommands.this.getJwks().hasDefaultKey()) {
                StemUtility.put((QDLStem)QDLStem2, (Object)"default", (Object)JWTCommands.this.getJwks().getDefaultKeyID());
            }
            for (String id : JWTCommands.this.getJwks().keySet()) {
                JSONWebKey jwk = (JSONWebKey)JWTCommands.this.getJwks().get((Object)id);
                QDLStem entry = new QDLStem();
                StemUtility.put((QDLStem)entry, (Object)MyOtherJWTUtil2.ALGORITHM, (Object)jwk.algorithm);
                StemUtility.put((QDLStem)entry, (Object)"use", (Object)jwk.use);
                StemUtility.put((QDLStem)entry, (Object)"kty", (Object)jwk.type);
                StemUtility.put((QDLStem)QDLStem2, (Object)id, (Object)entry);
            }
            return QDLValue.asQDLValue((Object)QDLStem2);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> docs = new ArrayList<String>();
            docs.add(this.getName() + "() - return a stem variable consisting of the ids (as keys) and the algorithms (as the values).");
            docs.add("See also:" + JWTCommands.this.DEFAULT_KEY_NAME);
            return docs;
        }
    }

    public class CreateJWT
    implements QDLFunction {
        public String getName() {
            return JWTCommands.this.CREATE_JWT_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1, 2};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (state instanceof OA2State) {
                JWTCommands.this.setJwks(((OA2State)state).getJsonWebKeys());
            }
            Object kid = null;
            JSONWebKey key = null;
            if (objects.length == 2) {
                if (objects[1].isString()) {
                    if (!JWTCommands.this.hasJWKS()) {
                        throw new IllegalStateException(" no keys loaded.");
                    }
                    key = (JSONWebKey)JWTCommands.this.getJwks().get((Object)objects[1].asString());
                }
                if (objects[1].isStem()) {
                    JSONObject newKey = new JSONObject();
                    JSONArray jsonArray = new JSONArray();
                    jsonArray.add((Object)objects[1].asStem().toJSON());
                    newKey.put((Object)"keys", (Object)jsonArray);
                    try {
                        JSONWebKeys keys = JSONWebKeyUtil.fromJSON((JSON)newKey);
                        key = (JSONWebKey)keys.values().iterator().next();
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvalidKeySpecException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                if (!JWTCommands.this.hasJWKS()) {
                    throw new IllegalStateException(" no keys loaded.");
                }
                if (!JWTCommands.this.getJwks().hasDefaultKey()) {
                    throw new IllegalStateException(" no default key.");
                }
                key = (JSONWebKey)JWTCommands.this.getJwks().get((Object)JWTCommands.this.getJwks().getDefaultKeyID());
            }
            QDLStem arg = objects[0].asStem();
            try {
                return QDLValue.asQDLValue((Object)JWTUtil.createJWT((JSONObject)((JSONObject)arg.toJSON()), (JSONWebKey)key));
            }
            catch (Throwable e) {
                throw new QDLException("Error creating JWT:" + e.getMessage(), e);
            }
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> docs = new ArrayList<String>();
            switch (argCount) {
                case 1: {
                    docs.add(this.getName() + "(arg) takes a stem variable (the claims) and creates a signed JSON Web Token (JWT)");
                    docs.add("using the default id.");
                    break;
                }
                case 2: {
                    docs.add(this.getName() + "(arg.,id) takes a stem variable (the claims) and creates a signed JSON Web Token (JWT)");
                    docs.add("using the given id from the current set of keys.");
                    docs.add(this.getName() + "(arg.,key.) takes a stem variable (the claims) and creates a signed JSON Web Token (JWT) using ther given key.");
                }
            }
            docs.add("This returned  signed JWT is  a string.");
            docs.add("See also: " + JWTCommands.this.CREATE_KEYS_NAME + ", " + JWTCommands.this.DEFAULT_KEY_NAME + ", " + JWTCommands.this.KEY_INFO_NAME);
            return docs;
        }
    }

    public class Keys
    implements QDLFunction {
        public String getName() {
            return JWTCommands.this.CURRENT_KEYS;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            if (objects.length == 0) {
                if (JWTCommands.this.jwks == null) {
                    return QDLNullValue.getNullValue();
                }
                QDLStem out = new QDLStem();
                return QDLValue.asQDLValue((Object)out.fromJSON(JWTCommands.this.getJsonWebKeyUtil().toJSON(JWTCommands.this.jwks)));
            }
            if (!objects[0].isStem()) {
                throw new BadArgException("no key specified", 0);
            }
            QDLStem stem = objects[0].asStem();
            QDLStem old = JWTCommands.this.getJwkStem();
            JWTCommands.this.setJwks(JWTCommands.this.getJsonWebKeyUtil().fromJSON(stem.toJSON()));
            if (old == null) {
                return QDLNullValue.getNullValue();
            }
            return QDLValue.asQDLValue((Object)old);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doc = new ArrayList<String>();
            switch (argCount) {
                case 0: {
                    doc.add(this.getName() + "() - return current jwk set or none if there are none");
                    break;
                }
                case 1: {
                    doc.add(this.getName() + "(keys.) - set the current keys to this stem");
                    doc.add("this returns the previously active keys or null if there was none.");
                }
            }
            return doc;
        }
    }

    public class DefaultKey
    implements QDLFunction {
        public String getName() {
            return JWTCommands.this.DEFAULT_KEY_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (!JWTCommands.this.hasJWKS()) {
                return new StringValue();
            }
            if (objects.length == 0) {
                return QDLValue.asQDLValue((Object)JWTCommands.this.getJwks().getDefaultKeyID());
            }
            String newId = objects[0].asString();
            if (!JWTCommands.this.getJwks().containsKey((Object)newId)) {
                throw new BadArgException(" There is no such key in the collection.", 0);
            }
            String oldID = JWTCommands.this.getJwks().getDefaultKeyID();
            JWTCommands.this.getJwks().setDefaultKeyID(newId);
            return QDLValue.asQDLValue((Object)oldID);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> docs = new ArrayList<String>();
            switch (argCount) {
                case 0: {
                    docs.add(this.getName() + "() get the current default key used for signatures.");
                    break;
                }
                case 1: {
                    docs.add(this.getName() + "(new_id)  set the current default key used for signatures.");
                }
            }
            return docs;
        }
    }

    public class SymmKeys
    implements QDLFunction {
        int defaultLength = 32;

        public String getName() {
            return "create_skeys";
        }

        public int[] getArgCount() {
            return new int[]{0, 1, 2};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            List<String> sKeys = null;
            int count = 1;
            int length = this.defaultLength;
            switch (objects.length) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!objects[0].isLong()) {
                        throw new BadArgException(" The first argument must be an integer", 0);
                    }
                    Long lCount = objects[0].asLong();
                    count = lCount.intValue();
                    break;
                }
                case 2: {
                    if (!objects[0].isLong()) {
                        throw new BadArgException(" The first argument must be an integer", 0);
                    }
                    Long lCount = objects[0].asLong();
                    count = lCount.intValue();
                    if (!objects[1].isLong()) {
                        throw new BadArgException(" The second argument must be an integer", 1);
                    }
                    Long lLength = objects[1].asLong();
                    length = lLength.intValue();
                }
            }
            sKeys = this.createKeys(count, length);
            if (count == 1) {
                return QDLValue.asQDLValue((Object)sKeys.get(0));
            }
            ArrayList<String> dummy = new ArrayList<String>();
            dummy.addAll(sKeys);
            QDLStem QDLStem2 = new QDLStem();
            QDLStem2.addList(dummy);
            return QDLValue.asQDLValue((Object)QDLStem2);
        }

        protected List<String> createKeys(int count, int length) {
            ArrayList<String> sKeys = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                byte[] array = new byte[length];
                JWTCommands.this.random.nextBytes(array);
                String output = Base64.getEncoder().encodeToString(array);
                while (output.endsWith("=")) {
                    output = output.substring(0, output.length() - 2);
                }
                sKeys.add(output);
            }
            return sKeys;
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> docs = new ArrayList<String>();
            switch (argCount) {
                case 0: {
                    docs.add(this.getName() + "() - creates a single symmetric key.");
                    break;
                }
                case 1: {
                    docs.add(this.getName() + "(count) - create a stem list with this number. Default length is " + this.defaultLength + " bytes.");
                    break;
                }
                case 2: {
                    docs.add(this.getName() + "(count, length) - creates count keys of the given length (in bytes, not characters)");
                }
            }
            docs.add("To save these to a file, use the file_write command.");
            return docs;
        }
    }

    public class SaveKeys
    implements QDLFunction {
        public String getName() {
            return JWTCommands.this.SAVE_KEYS_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (!JWTCommands.this.hasJWKS()) {
                throw new IllegalStateException(" No keys found to save.");
            }
            if (!objects[0].isString()) {
                throw new BadArgException(this.getName() + " requires a string as its argument", 0);
            }
            try {
                JWTCommands.this.writeWebkeys(state, JWTCommands.this.getJsonWebKeyUtil().toJSON(JWTCommands.this.jwks), objects[0].asString());
            }
            catch (Throwable e) {
                throw new QDLException(" could not save keys to " + String.valueOf(objects[0]), e);
            }
            return BooleanValue.True;
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> docs = new ArrayList<String>();
            docs.add(this.getName() + "(file_name) - saves the keys from current session to the given file.");
            return docs;
        }
    }

    public class LoadJWK
    implements QDLFunction {
        public String getName() {
            return JWTCommands.this.LOAD_KEYS_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (!objects[0].isString()) {
                throw new BadArgException(this.getName() + " requires a string as its argument", 0);
            }
            String filePath = objects[0].asString();
            try {
                String rawJSON = QDLFileUtil.readTextFile((State)state, (String)filePath);
                JWTCommands.this.setJwks(JWTCommands.this.getJsonWebKeyUtil().fromJSON(rawJSON));
            }
            catch (Throwable e) {
                throw new QDLException("Error reading keys file:" + e.getMessage(), e);
            }
            return BooleanValue.True;
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> docs = new ArrayList<String>();
            docs.add(this.getName() + "(file_name) - loads the keys file in to the current session.");
            return docs;
        }
    }

    public class CreateJWK
    implements QDLFunction {
        public String getName() {
            return JWTCommands.this.CREATE_KEYS_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0, 1, 2};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            String keyType = "RSA";
            String ecCurve = null;
            int rsaKeySize = 2048;
            String filePath = null;
            String defaultKeyID = null;
            boolean overwriteFile = false;
            boolean setCurrent = false;
            boolean argTypeOk = false;
            switch (objects.length) {
                case 0: {
                    argTypeOk = true;
                    break;
                }
                case 1: {
                    if (objects[0].isString()) {
                        argTypeOk = true;
                        filePath = objects[0].asString();
                    }
                    if (!objects[0].isStem()) break;
                    QDLStem args = objects[0].asStem();
                    argTypeOk = true;
                    if (args.containsKey((Object)ARG_KEY_TYPE)) {
                        if (!args.get(ARG_KEY_TYPE).isString()) {
                            throw new BadArgException(this.getName() + " requires a string as the " + ARG_KEY_TYPE + " of the key.", 0);
                        }
                        keyType = args.getString(ARG_KEY_TYPE);
                    }
                    if (args.containsKey((Object)ARG_DEFAULT_KEY_ID)) {
                        if (!args.get(ARG_DEFAULT_KEY_ID).isString()) {
                            throw new BadArgException(this.getName() + " requires a string as the " + ARG_DEFAULT_KEY_ID + " of the generated keys.", 0);
                        }
                        defaultKeyID = args.getString(ARG_DEFAULT_KEY_ID);
                    }
                    if (args.containsKey((Object)ARG_FILE_PATH_TYPE)) {
                        if (!args.get(ARG_FILE_PATH_TYPE).isString()) {
                            throw new BadArgException(this.getName() + " requires a string as the " + ARG_FILE_PATH_TYPE + " of the generated keys.", 0);
                        }
                        filePath = args.getString(ARG_FILE_PATH_TYPE);
                    }
                    if (args.containsKey((Object)ARG_FILE_OVERWRITE_TYPE)) {
                        if (!args.get(ARG_KEY_TYPE).isBoolean()) {
                            throw new BadArgException(this.getName() + " requires a boolean as the " + ARG_FILE_OVERWRITE_TYPE + " argument.", 0);
                        }
                        overwriteFile = args.getBoolean(ARG_FILE_OVERWRITE_TYPE);
                    }
                    if (args.containsKey((Object)ARG_SET_TO_CURRENT_KEYS_TYPE)) {
                        if (!args.get(ARG_SET_TO_CURRENT_KEYS_TYPE).isBoolean()) {
                            throw new BadArgException(this.getName() + " requires a boolean as the " + ARG_SET_TO_CURRENT_KEYS_TYPE + " argument.", 0);
                        }
                        setCurrent = args.getBoolean(ARG_SET_TO_CURRENT_KEYS_TYPE);
                    }
                    if (args.containsKey((Object)ARG_RSA_KEY_SIZE_TYPE)) {
                        if (!args.get(ARG_RSA_KEY_SIZE_TYPE).isLong()) {
                            throw new BadArgException(this.getName() + " requires an integer as the " + ARG_RSA_KEY_SIZE_TYPE + " argument.", 0);
                        }
                        rsaKeySize = args.getLong(ARG_RSA_KEY_SIZE_TYPE).intValue();
                    }
                    if (!args.containsKey((Object)ARG_EC_CURVE_TYPE)) break;
                    if (!args.get(ARG_EC_CURVE_TYPE).isStem()) {
                        throw new BadArgException(this.getName() + " requires a string as the " + ARG_EC_CURVE_TYPE + " of the generated keys.", 0);
                    }
                    ecCurve = args.getString(ARG_EC_CURVE_TYPE);
                    break;
                }
                case 2: {
                    if (!objects[0].isString()) {
                        throw new BadArgException("In dyadic " + this.getName() + ", the first argument must be a string", 0);
                    }
                    filePath = objects[0].asString();
                    if (objects[1].isBoolean()) {
                        overwriteFile = objects[1].asBoolean();
                        break;
                    }
                    throw new BadArgException("In dyadic " + this.getName() + ", the second argument must be a boolean", 1);
                }
            }
            if (!argTypeOk) {
                throw new BadArgException("Unsupport arg type as first argument to " + this.getName(), 0);
            }
            try {
                JSONWebKeys newKeys = null;
                if (keyType.equals("RSA")) {
                    JWTCommands.this.getSigningCommands();
                    newKeys = SigningCommands.createRSAJsonWebKeys(rsaKeySize, defaultKeyID);
                }
                if (keyType.equals("EC")) {
                    JWTCommands.this.getSigningCommands();
                    newKeys = SigningCommands.createECJsonWebKeys(ecCurve);
                }
                if (newKeys == null) {
                    throw new IllegalArgumentException("unsupported key type '" + keyType + "'");
                }
                if (setCurrent || !JWTCommands.this.hasJWKS()) {
                    JWTCommands.this.setJwks(newKeys);
                }
                if (!newKeys.hasDefaultKey()) {
                    for (String id : newKeys.keySet()) {
                        if (!"ES256".equals(((JSONWebKey)newKeys.get((Object)id)).algorithm) && !"RS256".equals(((JSONWebKey)newKeys.get((Object)id)).algorithm)) continue;
                        newKeys.setDefaultKeyID(id);
                    }
                }
                JSONObject jsonObject = JWTCommands.this.getJsonWebKeyUtil().toJSON(newKeys);
                if (filePath != null) {
                    if (overwriteFile) {
                        JWTCommands.this.writeWebkeys(state, jsonObject, filePath);
                    } else if (!QDLFileUtil.exists((State)state, (String)filePath)) {
                        JWTCommands.this.writeWebkeys(state, jsonObject, filePath);
                    }
                }
                QDLStem outKeys = new QDLStem();
                outKeys.fromJSON(jsonObject);
                return QDLValue.asQDLValue((Object)outKeys);
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new QDLException(" Could not create JSON web keys" + e.getMessage(), e);
            }
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doc = new ArrayList<String>();
            switch (argCount) {
                case 0: {
                    doc.add(this.getName() + "() - create a set of RSA JSON WebKeys and sets the current set of web keys.");
                    break;
                }
                case 1: {
                    doc.add(this.getName() + "(arg. | file_path) - create a set of JSON WebKeys.");
                    doc.add("file_path - create a set of RSA JSON web keys, set current keys to them and write to the file");
                    doc.add("     arg. - stem of options. {'" + ARG_KEY_TYPE + "':'RSA'|'EC', '" + ARG_RSA_KEY_SIZE_TYPE + "':rsa_key_size,'" + ARG_FILE_PATH_TYPE + "':'path','" + ARG_FILE_OVERWRITE_TYPE + "':true|false, '" + ARG_SET_TO_CURRENT_KEYS_TYPE + "':true|false}");
                    doc.add("            " + ARG_KEY_TYPE + " = of type RSA or EC (default is RSA)");
                    doc.add("            " + ARG_EC_CURVE_TYPE + " = name of the elliptic curve to use, default is " + JWKUtil2.EC_CURVE_P_256);
                    doc.add("            " + ARG_RSA_KEY_SIZE_TYPE + " = size of the RSA keys, default is 2048");
                    doc.add("            " + ARG_FILE_PATH_TYPE + " = path to file (if missing no write is done)");
                    doc.add("            " + ARG_FILE_OVERWRITE_TYPE + " = overwrite file if present (default is false, ignore if no file)");
                    doc.add("            " + ARG_SET_TO_CURRENT_KEYS_TYPE + " = set to the current keys for this module.");
                    doc.add("If there are no keys active, it will set the new keys to the current ones.");
                    doc.add("Otherwise, you must tell it to do so.");
                    break;
                }
                case 2: {
                    doc.add(this.getName() + "(file_path, true|false) - create a set of RSA JSON WebKeys, writes them to the given file.");
                    doc.add("If the second argument is true, the current active set of keys is replaced.");
                    doc.add("This is equivalent to {'" + ARG_KEY_TYPE + "':'RSA', '" + ARG_FILE_PATH_TYPE + "':'file_path', '" + ARG_FILE_OVERWRITE_TYPE + "':false, '" + ARG_SET_TO_CURRENT_KEYS_TYPE + "':true|false}");
                    break;
                }
                default: {
                    return doc;
                }
            }
            doc.add("\nThis also returns the newly generated set of keys as the output.");
            doc.add("If you are replacing the current keys with the new one, the default is set to");
            doc.add("key with algorithm RS256 (if RSA) or ES256 (if elliptic)");
            doc.add("RSA keys follow https://www.rfc-editor.org/rfc/rfc7518.html#section-3.3");
            doc.add("EC keys follow https://www.rfc-editor.org/rfc/rfc7518.html#section-3.4");
            doc.add("See also: default_key");
            return doc;
        }
    }
}

