/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.util;

import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import edu.uiuc.ncsa.security.util.jwk.JWKUtil2;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.codec.binary.Base64;
import org.oa4mp.server.loader.qdl.util.JWTCommands;
import org.qdl_lang.expressions.module.Module;
import org.qdl_lang.extensions.JavaModule;
import org.qdl_lang.state.State;
import org.qdl_lang.xml.XMLMissingCloseTagException;
import org.qdl_lang.xml.XMLUtilsV2;

public class JWTModule
extends JavaModule {
    public static final String JWT_COMMANDS_TAG = "jwt_commands";
    public static final String NAMESPACE = "oa4mp:/qdl/jwt";
    protected JWTCommands jwtCommands;
    List<String> descr = new ArrayList<String>();
    JWKUtil2 jwkUtil2 = new JWKUtil2();

    public JWTModule() {
    }

    public JWTModule(URI namespace, String alias) {
        super(namespace, alias);
    }

    public Module newInstance(State state) {
        JWTCommands jwtCommands;
        JWTModule jwtModule = new JWTModule(URI.create(NAMESPACE), "jwt");
        jwtModule.jwtCommands = jwtCommands = new JWTCommands(null);
        this.funcs = new ArrayList();
        this.funcs.add(new JWTCommands.CreateJWK(jwtCommands));
        this.funcs.add(new JWTCommands.LoadJWK(jwtCommands));
        this.funcs.add(new JWTCommands.KeyInfo(jwtCommands));
        this.funcs.add(new JWTCommands.Create_UUID(jwtCommands));
        this.funcs.add(new JWTCommands.SaveKeys(jwtCommands));
        this.funcs.add(new JWTCommands.CreateJWT(jwtCommands));
        this.funcs.add(new JWTCommands.Keys(jwtCommands));
        this.funcs.add(new JWTCommands.VerifyJWT(jwtCommands));
        this.funcs.add(new JWTCommands.GetHeader(jwtCommands));
        this.funcs.add(new JWTCommands.GetPayload(jwtCommands));
        this.funcs.add(new JWTCommands.DefaultKey(jwtCommands));
        this.funcs.add(new JWTCommands.SymmKeys(jwtCommands));
        jwtModule.addFunctions(this.funcs);
        this.vars = new ArrayList();
        this.vars.add(new JWTCommands.TestClaims(jwtCommands));
        this.vars.add(new JWTCommands.TestScopes(jwtCommands));
        this.vars.add(new JWTCommands.TestAudience(jwtCommands));
        this.vars.add(new JWTCommands.TestXAs(jwtCommands));
        jwtModule.addVariables(this.vars);
        if (state != null) {
            jwtModule.init(state);
        }
        this.setupModule((Module)jwtModule);
        return jwtModule;
    }

    public void writeExtraXMLElements(XMLStreamWriter xsw) throws XMLStreamException {
        this.writeExtraXMLElementsNEW(xsw);
    }

    public void writeExtraXMLElementsNEW(XMLStreamWriter xsw) throws XMLStreamException {
        super.writeExtraXMLElements(xsw);
        if (this.jwtCommands != null && this.jwtCommands.jwks != null) {
            xsw.writeStartElement(JWT_COMMANDS_TAG);
            xsw.writeCData(Base64.encodeBase64URLSafeString((byte[])JSONWebKeyUtil.toJSON((JSONWebKeys)this.jwtCommands.jwks).toString().getBytes(StandardCharsets.UTF_8)));
            xsw.writeEndElement();
        }
    }

    public void readExtraXMLElements(XMLEvent xe, XMLEventReader xer) throws XMLStreamException {
        this.readExtraXMLElementsNEW(xe, xer);
    }

    public void readExtraXMLElementsOLD(XMLEvent xe, XMLEventReader xer) throws XMLStreamException {
        super.readExtraXMLElements(xe, xer);
        xe = xer.peek();
        while (xer.hasNext()) {
            switch (xe.getEventType()) {
                case 1: {
                    switch (xe.asStartElement().getName().getLocalPart()) {
                        case "jwt_commands": {
                            try {
                                this.jwtCommands.setJwks(JSONWebKeyUtil.fromXML((XMLEventReader)xer));
                                break;
                            }
                            catch (Throwable e) {
                                System.out.println(" Could not deserialize the JWT module. " + e.getMessage());
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    if (!xe.asEndElement().getName().getLocalPart().equals(JWT_COMMANDS_TAG)) break;
                    return;
                }
            }
            xe = xer.nextEvent();
        }
        throw new XMLMissingCloseTagException(JWT_COMMANDS_TAG);
    }

    public void readExtraXMLElementsNEW(XMLEvent xe, XMLEventReader xer) throws XMLStreamException {
        super.readExtraXMLElements(xe, xer);
        if (!xe.asStartElement().getName().getLocalPart().equals(JWT_COMMANDS_TAG)) {
            return;
        }
        xe = xer.peek();
        while (xer.hasNext()) {
            switch (xe.getEventType()) {
                case 1: {
                    switch (xe.asStartElement().getName().getLocalPart()) {
                        case "jwt_commands": {
                            try {
                                String raw = new String(Base64.decodeBase64((String)XMLUtilsV2.getText((XMLEventReader)xer, (String)JWT_COMMANDS_TAG)));
                                if (StringUtils.isTrivial((String)raw)) {
                                    return;
                                }
                                this.jwtCommands.setJwks(this.jwkUtil2.fromJSON(raw));
                                break;
                            }
                            catch (Throwable e) {
                                System.out.println(" Could not deserialize the JWT module. " + e.getMessage());
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    if (!xe.asEndElement().getName().getLocalPart().equals(JWT_COMMANDS_TAG)) break;
                    return;
                }
            }
            xe = xer.nextEvent();
        }
        throw new XMLMissingCloseTagException(JWT_COMMANDS_TAG);
    }

    public List<String> getDescription() {
        if (this.descr.isEmpty()) {
            this.descr.add("The module for JWT (JSON Web Token) support. This will allow you to create them,");
            this.descr.add("validate them, create and save keys, etc.");
        }
        return this.descr;
    }
}

