/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.qdl.util;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.CommonCommands2;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import edu.uiuc.ncsa.security.util.jwk.JWKUtil2;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.server.loader.oauth2.OA2SE;

public class SigningCommands
extends CommonCommands2 {
    public static final String RS_256 = "RS256";
    public static final String RS_384 = "RS384";
    public static final String RS_512 = "RS512";
    OA2SE oa2SE;
    public int defaultSymmetricKeyLength = 256;
    public String SYMMETRIC_KEY_ARG = "-length";
    public String SYMMETRIC_KEY_COUNT_ARG = "-count";
    public String SYMMETRIC_KEY_FILE_ARG = "-out";
    static SecureRandom random = new SecureRandom();
    protected static JWKUtil2 jwkUtil2;

    public void about(boolean showBanner, boolean showHeader) {
    }

    public void initialize() throws Throwable {
    }

    public void load(InputLine inputLine) throws Throwable {
    }

    public SigningCommands(CLIDriver driver, OA2SE oa2se) throws Throwable {
        super(driver);
        this.oa2SE = oa2se;
    }

    public OA2SE getOa2SE() {
        return this.oa2SE;
    }

    public String getName() {
        return "keys";
    }

    public String getPrompt() {
        return this.getName() + ">";
    }

    protected void createHelp() {
        this.say("create [path]: This will allow you to create a completely new set of JSON web keys and write it to a file");
        this.say("       If the path is given, the keys will be written. If the path is not given then you will be");
        this.say("       prompted for one. This will not overwrite an existing file.");
    }

    public void create(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.createHelp();
            return;
        }
        boolean retry = true;
        File publicKeyFile = null;
        boolean isInteractive = true;
        if (inputLine.size() == 1 || inputLine.size() == 2 && inputLine.hasArg("-single")) {
            boolean singleKeyOnly = inputLine.hasArg("-single");
            JSONWebKeys keys = SigningCommands.createJsonWebKeys();
            StringWriter writer = new StringWriter();
            JSONObject jwks = JSONWebKeyUtil.toJSON((JSONWebKeys)keys);
            if (singleKeyOnly) {
                JSONArray array = jwks.getJSONArray("keys");
                JSONObject key = null;
                for (int i = 0; i < array.size(); ++i) {
                    if (!array.getJSONObject(i).getString("alg").equals(RS_256)) continue;
                    key = array.getJSONObject(i);
                    break;
                }
                jwks = new JSONObject();
                JSONArray array1 = new JSONArray();
                array1.add(key);
                jwks.put((Object)"keys", (Object)array1);
            }
            writer.write(jwks.toString(2));
            writer.flush();
            writer.close();
            this.say(writer.toString());
            return;
        }
        if (1 < inputLine.size()) {
            publicKeyFile = inputLine.hasArg("-file") ? new File(inputLine.getNextArgFor("-file")) : new File(inputLine.getArg(1));
        }
        if (publicKeyFile == null) {
            throw new GeneralException("No full path to the file given.");
        }
        while (retry) {
            if (publicKeyFile == null) {
                String publicKeyPath = this.getInput("Give the file path", "");
                if (publicKeyPath.toLowerCase().equals("exit") || publicKeyPath.toLowerCase().equals("quit")) {
                    return;
                }
                publicKeyFile = new File(publicKeyPath);
            }
            if (publicKeyFile.exists()) {
                if (publicKeyFile.isFile()) continue;
                retry = !this.isOk(this.readline("The file you gave exists, do you want to over write it? [y/n]"));
                continue;
            }
            retry = false;
        }
        if (!this.isOk(this.readline("create a new set of JSON web keys to \"" + publicKeyFile.getAbsolutePath() + "\"?[y/n]"))) {
            this.say("create cancelled.");
            return;
        }
        JSONWebKeys keys = SigningCommands.createJsonWebKeys();
        FileWriter writer = new FileWriter(publicKeyFile);
        JSONObject jwks = JSONWebKeyUtil.toJSON((JSONWebKeys)keys);
        writer.write(jwks.toString(2));
        writer.flush();
        writer.close();
        this.sayi("JSONweb keys written");
        this.sayi("Done!");
    }

    public static JSONWebKeys createRSAJsonWebKeys(int size, String defaultKeyID) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        JSONWebKey defaultKey = SigningCommands.createRSAJWK(size, RS_256);
        defaultKey = SigningCommands.resetDefaultID(defaultKeyID, defaultKey);
        JSONWebKeys keys = new JSONWebKeys(defaultKey.id);
        keys.put(defaultKey);
        keys.put(SigningCommands.createRSAJWK(size, RS_384));
        keys.put(SigningCommands.createRSAJWK(size, RS_512));
        return keys;
    }

    private static JSONWebKey resetDefaultID(String defaultKeyID, JSONWebKey defaultKey) {
        if (defaultKeyID != null) {
            Map rawKey = defaultKey.getJOSEJWK().toJSONObject();
            rawKey.put("kid", defaultKeyID);
            JSONObject rawjson = new JSONObject();
            rawjson.putAll(rawKey);
            defaultKey = SigningCommands.getJwkUtil2().getJsonWebKey(rawjson);
            defaultKey.id = defaultKeyID;
        }
        return defaultKey;
    }

    public static JSONWebKeys createECJsonWebKeys(String defaultKeyID) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        JSONWebKey defaultKey = SigningCommands.createECJWK(JWKUtil2.EC_CURVE_P_256, "ES256");
        if (defaultKeyID != null) {
            defaultKey.id = defaultKeyID;
        }
        JSONWebKeys keys = new JSONWebKeys(defaultKey.id);
        keys.put(defaultKey);
        keys.put(SigningCommands.createECJWK(JWKUtil2.EC_CURVE_P_384, "ES384"));
        keys.put(SigningCommands.createECJWK(JWKUtil2.EC_CURVE_P_521, "ES512"));
        return keys;
    }

    public static JSONWebKeys createECJsonWebKeys(String curve, String defaultKeyID) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (StringUtils.isTrivial((String)curve)) {
            return SigningCommands.createECJsonWebKeys(defaultKeyID);
        }
        JSONWebKey defaultKey = SigningCommands.createECJWK(curve, "ES256");
        defaultKey = SigningCommands.resetDefaultID(defaultKeyID, defaultKey);
        JSONWebKeys keys = new JSONWebKeys(defaultKey.id);
        keys.put(defaultKey);
        keys.put(SigningCommands.createECJWK(curve, "ES384"));
        keys.put(SigningCommands.createECJWK(curve, "ES512"));
        return keys;
    }

    public static JSONWebKeys createJsonWebKeys() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        JSONWebKey defaultKey = SigningCommands.createJWK(RS_256);
        JSONWebKeys keys = new JSONWebKeys(defaultKey.id);
        keys.put(defaultKey);
        keys.put(SigningCommands.createJWK(RS_384));
        keys.put(SigningCommands.createJWK(RS_512));
        return keys;
    }

    protected void showSymmetricKeyHelp() {
        this.say("createSymmetricKey [" + this.SYMMETRIC_KEY_ARG + " len + | " + this.SYMMETRIC_KEY_COUNT_ARG + "count] This will create a key for use as a symmetric key, i.e., this will produce");
        this.say("   a base 64 encoded sequence of random bytes to be used as a symmetric key for");
        this.say("   the given length. If no length is included, the default of " + this.defaultSymmetricKeyLength + " bytes is used.");
        this.say("   If the " + this.SYMMETRIC_KEY_COUNT_ARG + " is given, this will produce that many keys");
        this.say("   If the " + this.SYMMETRIC_KEY_FILE_ARG + " is given, this will write the keys to the given file, one per line.");
    }

    public void create_symmetric_keys(InputLine inputLine) {
        if (this.showHelp(inputLine)) {
            this.showSymmetricKeyHelp();
            return;
        }
        int length = this.defaultSymmetricKeyLength;
        if (inputLine.hasArg(this.SYMMETRIC_KEY_ARG)) {
            try {
                length = Integer.parseInt(inputLine.getNextArgFor(this.SYMMETRIC_KEY_ARG));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        int count = 1;
        if (inputLine.hasArg(this.SYMMETRIC_KEY_COUNT_ARG)) {
            try {
                count = Integer.parseInt(inputLine.getNextArgFor(this.SYMMETRIC_KEY_COUNT_ARG));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        File targetFile = null;
        if (inputLine.hasArg(this.SYMMETRIC_KEY_FILE_ARG)) {
            try {
                targetFile = new File(inputLine.getNextArgFor(this.SYMMETRIC_KEY_FILE_ARG));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        byte[] array = null;
        if (targetFile == null) {
            this.say(count + " base 64 encoded key" + (count == 1 ? "" : "s") + " with length of " + length + " bytes:\n");
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            array = new byte[length];
            random.nextBytes(array);
            String output = Base64.getEncoder().encodeToString(array);
            while (output.endsWith("=")) {
                output = output.substring(0, output.length() - 2);
            }
            if (targetFile != null) {
                keys.add(output);
                continue;
            }
            this.say(output);
        }
        if (targetFile != null) {
            try {
                Files.write(targetFile.toPath(), keys, new OpenOption[0]);
                this.say("Done. Wrote " + count + " key" + (count == 1 ? "" : "s") + " to " + String.valueOf(targetFile));
            }
            catch (IOException e) {
                this.say("Could not write keys to " + String.valueOf(targetFile) + ":" + e.getMessage());
            }
        }
    }

    public static JSONWebKey createJWK(String algorithm) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        return SigningCommands.createRSAJWK(2048, algorithm);
    }

    public static JSONWebKey createRSAJWK(int size, String algorithm) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        return SigningCommands.getJwkUtil2().createRSAKey(size, algorithm);
    }

    public static JWKUtil2 getJwkUtil2() {
        if (jwkUtil2 == null) {
            jwkUtil2 = new JWKUtil2();
        }
        return jwkUtil2;
    }

    public static void setJwkUtil2(JWKUtil2 newJWKUtil2) {
        jwkUtil2 = newJWKUtil2;
    }

    public static JSONWebKey createECJWK(String curve, String algorithm) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        return SigningCommands.getJwkUtil2().createECKey(curve, algorithm);
    }

    public static JSONWebKey createJWK(String algorithm, boolean isRSA) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        if (isRSA) {
            return SigningCommands.getJwkUtil2().createRSAKey(2048, algorithm);
        }
        return SigningCommands.getJwkUtil2().createECKey("P-256", algorithm);
    }
}

