/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.Pacer;
import edu.uiuc.ncsa.security.storage.FileStore;
import edu.uiuc.ncsa.security.util.TestBase;
import java.util.Date;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.admin.adminClient.AdminClientConverter;
import org.oa4mp.server.api.admin.adminClient.AdminClientKeys;
import org.oa4mp.server.api.admin.adminClient.AdminClientProvider;
import org.oa4mp.server.api.admin.adminClient.AdminClientStore;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionsStore;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.test.TestStoreProvider2;
import org.oa4mp.server.test.TestUtils;

public class AdminClientTest
extends TestBase {
    boolean doBigStore = false;

    public void testFS() throws Exception {
        this.testAdminClient(((TestStoreProvider2)TestUtils.getFsStoreProvider()).getAdminClientStore());
        this.testAdminClientConverter(((TestStoreProvider2)TestUtils.getFsStoreProvider()).getAdminClientStore());
    }

    public void testMYSQL() throws Exception {
        this.testAdminClient(((TestStoreProvider2)TestUtils.getMySQLStoreProvider()).getAdminClientStore());
        this.testAdminClientConverter(((TestStoreProvider2)TestUtils.getMySQLStoreProvider()).getAdminClientStore());
    }

    public void testMemStore() throws Exception {
        this.testAdminClient(((TestStoreProvider2)TestUtils.getMemoryStoreProvider()).getAdminClientStore());
        this.testAdminClientConverter(((TestStoreProvider2)TestUtils.getMemoryStoreProvider()).getAdminClientStore());
    }

    public void testPG() throws Exception {
        this.testAdminClient(((TestStoreProvider2)TestUtils.getPgStoreProvider()).getAdminClientStore());
        this.testAdminClientConverter(((TestStoreProvider2)TestUtils.getPgStoreProvider()).getAdminClientStore());
    }

    public void testDerby() throws Exception {
        this.testAdminClient(((TestStoreProvider2)TestUtils.getDerbyStoreProvider()).getAdminClientStore());
        this.testAdminClientConverter(((TestStoreProvider2)TestUtils.getDerbyStoreProvider()).getAdminClientStore());
    }

    public void testAdminClientConverter(AdminClientStore store) throws Exception {
        AdminClientProvider clientProvider = new AdminClientProvider();
        AdminClientConverter converter = new AdminClientConverter(new AdminClientKeys(), (IdentifiableProvider)clientProvider);
        AdminClient c = (AdminClient)store.create();
        c.setLastModifiedTS(new Date(1000L));
        c.setSecret("idufh84057thsdfghwre");
        c.setEmail("bob@foo.bar");
        c.setName("Test client 42");
        c.setIssuer("https://www.bigscience.org/claims");
        c.setVirtualIssuer(BasicIdentifier.randomID());
        c.setMaxClients(AdminClient.DEFAULT_MAX_NUMBER_OF_OIDC_CLIENTS + 100);
        JSONObject j = new JSONObject();
        converter.toJSON(c, j);
        System.out.println(j);
        AdminClient c2 = converter.fromJSON(j);
        assert (c.getLastModifiedTS().getTime() == c2.getLastModifiedTS().getTime());
        assert (c.getSecret().equals(c2.getSecret()));
        assert (c.getEmail().equals(c2.getEmail()));
        assert (c.getName().equals(c2.getName()));
        assert (c.getIssuer().equals(c2.getIssuer()));
        assert (c.getVirtualIssuer().equals(c2.getVirtualIssuer()));
        assert (c.getMaxClients() == c2.getMaxClients());
        store.remove((Object)c.getIdentifier());
    }

    public void testAdminClient(AdminClientStore store) throws Exception {
        long comparisonTolerance = 1000L;
        AdminClientProvider clientProvider = new AdminClientProvider();
        AdminClientConverter converter = new AdminClientConverter(new AdminClientKeys(), (IdentifiableProvider)clientProvider);
        AdminClient c = (AdminClient)store.create();
        c.setLastModifiedTS(new Date(1009000L));
        c.setSecret("idufh84057thsdfghwre");
        c.setEmail("bob@foo.bar");
        c.setName("Test client 42");
        c.setIssuer("https://www.bigscience.org/claims");
        c.setVirtualIssuer(BasicIdentifier.randomID());
        c.setMaxClients(AdminClient.DEFAULT_MAX_NUMBER_OF_OIDC_CLIENTS + 100);
        Date nowDate = new Date();
        long now = nowDate.getTime();
        store.save((Identifiable)c);
        AdminClient c2 = (AdminClient)store.get((Object)c.getIdentifier());
        long lastMod = c2.getLastModifiedTS().getTime();
        assert (c.getIdentifier().equals(c2.getIdentifier()));
        assert (c.getSecret().equals(c2.getSecret()));
        assert (c.getEmail().equals(c2.getEmail()));
        assert (c.getName().equals(c2.getName()));
        assert (c.getIssuer().equals(c2.getIssuer()));
        assert (c.getVirtualIssuer().equals(c2.getVirtualIssuer()));
        assert (c.getMaxClients() == c2.getMaxClients());
        assert (now - comparisonTolerance <= lastMod && lastMod <= now + comparisonTolerance) : "timestamp " + lastMod + " failed to be within tolerance " + comparisonTolerance + " for now " + now + ", difference =" + (lastMod - now);
        store.remove((Object)c.getIdentifier());
    }

    public void testBigAdminClientStore() throws Exception {
        if (!this.doBigStore) {
            return;
        }
        AdminClientStore store = TestUtils.getOLDfsStoreProvider().getAdminClientStore();
        ClientStore clientStore = TestUtils.getOLDfsStoreProvider().getClientStore();
        ClientApprovalStore clientApprovalStore = TestUtils.getOLDfsStoreProvider().getClientApprovalStore();
        PermissionsStore permissionsStore = TestUtils.getOLDfsStoreProvider().getPermissionStore();
        FileStore fileStore = (FileStore)store;
        String random = AdminClientTest.getRandomString((int)8);
        Date now = new Date();
        Pacer pacer = new Pacer(20);
        long startTime = System.currentTimeMillis();
        int count = 100;
        System.out.println("creating " + count + " files in " + fileStore.getStorageDirectory().getAbsolutePath());
        for (int i = 0; i < count; ++i) {
            AdminClient adminClient = (AdminClient)store.create();
            adminClient.setSecret(AdminClientTest.getRandomString((int)100));
            adminClient.setName("name-" + random);
            adminClient.setEmail("bob@" + random + "bgsu.edu");
            adminClient.setCreationTS(now);
            adminClient.setLastModifiedTS(now);
            adminClient.setIssuer("issuer:" + random);
            if (i % 47 == 0) {
                adminClient.setLastAccessed(now);
            }
            adminClient.setDescription("big test admin client batch:" + random);
            adminClient.setConfig(this.createRandomJSON());
            store.register((Identifiable)adminClient);
            for (int j = 0; j < 10; ++j) {
                OA2Client oa2Client = (OA2Client)clientStore.create();
                ClientApproval clientApproval = (ClientApproval)clientApprovalStore.create();
                clientApproval.setIdentifier(oa2Client.getIdentifier());
                Permission p = new Permission(BasicIdentifier.randomID());
                p.setAdminID(adminClient.getIdentifier());
                p.setClientID(oa2Client.getIdentifier());
                clientApproval.setStatus(ClientApproval.Status.APPROVED);
                clientApproval.setApproved(true);
                clientApproval.setApprover("bob-" + random);
                clientStore.register((Identifiable)oa2Client);
                clientApprovalStore.register((Identifiable)clientApproval);
                permissionsStore.register((Identifiable)p);
            }
            if (i % 20 != 0) continue;
            pacer.pace((long)i, "files saved, " + (double)i * 100.0 / (double)count + "% done.");
        }
        System.out.println("\n" + count + " files processed in " + (System.currentTimeMillis() - startTime) + "ms.");
    }

    public void testBigClientStore() throws Exception {
        if (!this.doBigStore) {
            return;
        }
        ClientStore store = TestUtils.getOLDfsStoreProvider().getClientStore();
        ClientApprovalStore clientApprovalStore = TestUtils.getOLDfsStoreProvider().getClientApprovalStore();
        FileStore fileStore = (FileStore)store;
        String random = AdminClientTest.getRandomString((int)8);
        Date now = new Date();
        Pacer pacer = new Pacer(20);
        long startTime = System.currentTimeMillis();
        int count = 100000;
        System.out.println("creating " + count + " files in " + fileStore.getStorageDirectory().getAbsolutePath());
        for (int i = 0; i < count; ++i) {
            OA2Client client = (OA2Client)store.create();
            client.setSecret(AdminClientTest.getRandomString((int)100));
            client.setName("name-" + random);
            client.setEmail("bob@" + random + "bgsu.edu");
            client.setCreationTS(now);
            client.setLastModifiedTS(now);
            ClientApproval clientApproval = (ClientApproval)clientApprovalStore.create();
            clientApproval.setIdentifier(client.getIdentifier());
            clientApproval.setApprover("tom" + random);
            clientApproval.setApproved(true);
            clientApproval.setStatus(ClientApproval.Status.APPROVED);
            clientApproval.setApprovalTimestamp(now);
            if (i % 47 == 0) {
                client.setLastAccessed(now);
            }
            client.setDescription("big test client batch:" + random);
            client.setConfig(this.createRandomJSON());
            store.register((Identifiable)client);
            clientApprovalStore.register((Identifiable)clientApproval);
            if (i % 1000 != 0) continue;
            pacer.pace((long)i, "files saved, " + (double)i * 100.0 / (double)count + "% done.");
        }
        System.out.println(count + " files processed in " + (System.currentTimeMillis() - startTime) + "ms.");
    }

    protected JSONObject createRandomJSON() {
        JSONObject jsonObject = new JSONObject();
        for (int i = 0; i < 10; ++i) {
            jsonObject.put((Object)AdminClientTest.getRandomString((int)10), (Object)AdminClientTest.getRandomString((int)100));
        }
        return jsonObject;
    }
}

