/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.IdentifierProvider;
import java.lang.invoke.CallSite;
import java.security.SecureRandom;
import java.util.LinkedList;
import junit.framework.TestCase;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONUtils;
import org.apache.commons.codec.binary.Base64;
import org.oa4mp.delegation.common.storage.clients.BaseClientConverter;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.server.config.LDAPConfiguration;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.admin.adminClient.AdminClientConverter;
import org.oa4mp.server.api.admin.adminClient.AdminClientStore;
import org.oa4mp.server.api.admin.adminClient.AdminClientStoreProviders;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionList;
import org.oa4mp.server.api.admin.transactions.OA4MPIdentifierProvider;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientConverter;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientKeys;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientProvider;
import org.oa4mp.server.test.TestStoreProviderInterface;
import org.oa4mp.server.test.TestUtils;

public abstract class DDServerTests
extends TestCase {
    SecureRandom secureRandom = new SecureRandom();
    public final String DD = "----------------------------------------------------------------------------";

    public abstract void testAll(TestStoreProviderInterface var1) throws Exception;

    public void testMemoryStore() throws Exception {
        this.testAll(TestUtils.getMemoryStoreProvider());
    }

    public void testFilestore() throws Exception {
        this.testAll(TestUtils.getFsStoreProvider());
    }

    public void testMysql() throws Exception {
        this.testAll(TestUtils.getMySQLStoreProvider());
    }

    public void testPostgres() throws Exception {
        this.testAll(TestUtils.getPgStoreProvider());
    }

    public void testDerby() throws Exception {
        this.testAll(TestUtils.getDerbyStoreProvider());
    }

    protected String getRandom() {
        return this.getRandom(16);
    }

    protected String getRandom(int length) {
        byte[] bytes = new byte[length];
        this.secureRandom.nextBytes(bytes);
        return Base64.encodeBase64URLSafeString((byte[])bytes);
    }

    protected CC setupClients(TestStoreProviderInterface tp2) throws Exception {
        AdminClient adminClient = this.getAdminClient(tp2.getAdminClientStore());
        ClientApproval clientApproval = (ClientApproval)tp2.getClientApprovalStore().create();
        clientApproval.setIdentifier(adminClient.getIdentifier());
        clientApproval.setApproved(true);
        clientApproval.setApprover("junit");
        tp2.getClientApprovalStore().save((Identifiable)clientApproval);
        OA2Client client = this.getOa2Client(tp2.getClientStore());
        PermissionList permissions = tp2.getPermissionStore().get(adminClient.getIdentifier(), client.getIdentifier());
        if (permissions.isEmpty()) {
            Permission p = (Permission)tp2.getPermissionStore().create();
            p.setAdminID(adminClient.getIdentifier());
            p.setClientID(client.getIdentifier());
            p.setRead(true);
            p.setWrite(true);
            p.setDelete(true);
            p.setApprove(true);
            p.setCreate(true);
            tp2.getPermissionStore().save((Identifiable)p);
        }
        CC cc = new CC();
        cc.adminClient = adminClient;
        cc.client = client;
        return cc;
    }

    protected void cleanupCC(CC cc, TestStoreProviderInterface tp2) {
        try {
            PermissionList pList = tp2.getPermissionStore().get(cc.adminClient.getIdentifier(), cc.client.getIdentifier());
            for (Permission p : pList) {
                tp2.getPermissionStore().remove((Object)p.getIdentifier());
            }
        }
        catch (Throwable t) {
            System.out.println("NOTE: Could not remove permissions for client \"" + cc.client.getIdentifierString() + "\" and admin \"" + cc.adminClient.getIdentifierString() + "\",:" + t.getMessage());
        }
        try {
            tp2.getClientApprovalStore().remove((Object)cc.client.getIdentifier());
        }
        catch (Throwable t) {
            System.out.println("NOTE: remove client approval for \"" + cc.client.getIdentifierString() + "\" and admin \"" + cc.adminClient.getIdentifierString() + "\",:" + t.getMessage());
        }
        try {
            tp2.getClientStore().remove((Object)cc.client.getIdentifier());
        }
        catch (Throwable t) {
            System.out.println("NOTE: Could not remove client with id \"" + cc.client.getIdentifierString() + "\" and admin \"" + cc.adminClient.getIdentifierString() + "\",:" + t.getMessage());
        }
        try {
            tp2.getAdminClientStore().remove((Object)cc.adminClient.getIdentifier());
        }
        catch (Throwable t) {
            System.out.println("NOTE: Could not remove admin client \"" + cc.adminClient.getIdentifierString() + "\",:" + t.getMessage());
        }
    }

    protected AdminClientConverter getAdminClientConverter(TestStoreProviderInterface tp2) throws Exception {
        BaseClientConverter bcc = (BaseClientConverter)tp2.getAdminClientStore().getMapConverter();
        if (bcc instanceof AdminClientConverter) {
            return (AdminClientConverter)bcc;
        }
        return AdminClientStoreProviders.getAdminClientConverter();
    }

    protected OA2ClientConverter getClientConverter(TestStoreProviderInterface tp2) throws Exception {
        BaseClientConverter bcc = (BaseClientConverter)tp2.getClientStore().getMapConverter();
        if (bcc instanceof OA2ClientConverter) {
            return (OA2ClientConverter)bcc;
        }
        OA2ClientProvider clientProvider = new OA2ClientProvider((IdentifierProvider)new OA4MPIdentifierProvider("client"));
        OA2ClientConverter converter = new OA2ClientConverter((IdentifiableProvider)clientProvider);
        return converter;
    }

    protected OA2ClientKeys getClientKeys(TestStoreProviderInterface tp2) throws Exception {
        return (OA2ClientKeys)this.getClientConverter(tp2).getKeys();
    }

    public void x() {
        System.out.println("----------------------------------------------------------------------------");
    }

    protected void prettyPrint(JSONObject api) {
        String out = JSONUtils.valueToString((Object)api, (int)1, (int)0);
        System.out.println(out);
        this.x();
    }

    protected Client getClient(ClientStore store) {
        Client c = (Client)store.create();
        String random = this.getRandom(8);
        c.setSecret(this.getRandom(64));
        c.setProxyLimited(true);
        c.setHomeUri("https://baz.foo.edu/" + random + "/home");
        c.setErrorUri("https://baz.foo.edu/home/" + random + "/error");
        c.setProxyLimited(false);
        c.setEmail("bob@" + random + ".foo.bar");
        c.setName("Test client " + random);
        return c;
    }

    protected AdminClient getAdminClient(AdminClientStore store) {
        AdminClient adminClient = (AdminClient)store.create();
        String random = this.getRandom(8);
        adminClient.setSecret(this.getRandom(64));
        adminClient.setName("Test admin client " + random);
        adminClient.setEmail("bob@" + random + ".foo.bar");
        adminClient.setVirtualIssuer(BasicIdentifier.randomID());
        adminClient.setIssuer("Issuer=" + random);
        store.save((Identifiable)adminClient);
        return adminClient;
    }

    protected OA2Client getOa2Client(ClientStore store) {
        OA2Client c = (OA2Client)store.create();
        String random = this.getRandom(8);
        c.setSecret(this.getRandom(64));
        c.setProxyLimited(true);
        c.setHomeUri("https://baz.foo.edu/" + random + "/home");
        c.setErrorUri("https://baz.foo.edu/home/" + random + "/error");
        c.setProxyLimited(false);
        c.setEmail("bob@" + random + ".foo.bar");
        c.setName("Test client " + random);
        c.setRtLifetime(456767875477L);
        JSONObject cfg = new JSONObject();
        cfg.put((Object)"version", (Object)this.getRandom());
        c.setConfig(cfg);
        LinkedList<CallSite> callbacks = new LinkedList<CallSite>();
        callbacks.add((CallSite)((Object)("https:/baz.foo.edu/client2/" + random + "/ready1")));
        callbacks.add((CallSite)((Object)("https:/baz.foo.edu/client2/" + random + "/ready2")));
        c.setCallbackURIs(callbacks);
        LDAPConfiguration ldapConfiguration = new LDAPConfiguration();
        ldapConfiguration.setServer("foo.bar.edu");
        LinkedList<LDAPConfiguration> ldaps = new LinkedList<LDAPConfiguration>();
        ldaps.add(ldapConfiguration);
        c.setLdaps(ldaps);
        LinkedList<String> scopes = new LinkedList<String>();
        scopes.add("openid");
        scopes.add("email");
        scopes.add("profile");
        scopes.add("org.cilogon.userinfo");
        c.setScopes(scopes);
        store.save((Identifiable)c);
        return c;
    }

    public static class CC {
        public AdminClient adminClient;
        public OA2Client client;
    }
}

