/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.util.TestBase;
import edu.uiuc.ncsa.security.util.ssl.SSLConfiguration;
import edu.uiuc.ncsa.security.util.ssl.VerifyingHTTPClientFactory;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;

public class HTTPTester
extends TestBase {
    VerifyingHTTPClientFactory vcf;

    protected String getSecret() {
        return System.getProperty("clientSecret");
    }

    protected String getID() {
        return System.getProperty("clientID");
    }

    protected String getAddress() {
        return System.getProperty("serverAddress");
    }

    VerifyingHTTPClientFactory getVCF() throws IOException {
        if (this.vcf == null) {
            this.vcf = new VerifyingHTTPClientFactory(null, new SSLConfiguration());
        }
        return this.vcf;
    }

    protected HttpResponse doRequest(HttpUriRequest request) throws IOException, NoSuchAlgorithmException, KeyStoreException {
        HttpClient client = this.newClient();
        return client.execute(request);
    }

    protected String createCreds() {
        String creds = this.getID() + ":" + this.getSecret();
        return Base64.encodeBase64URLSafeString((byte[])creds.getBytes());
    }

    protected HttpResponse doDelete() throws IOException, NoSuchAlgorithmException, KeyStoreException {
        HttpDelete deleteReq = new HttpDelete(this.getAddress());
        deleteReq.setHeader("Authorization: Bearer", this.createCreds());
        return this.doRequest((HttpUriRequest)deleteReq);
    }

    protected HttpResponse doGet() throws IOException, NoSuchAlgorithmException, KeyStoreException {
        HttpGet getReq = new HttpGet(this.getAddress());
        getReq.setHeader("Authorization: Bearer", this.createCreds());
        return this.doRequest((HttpUriRequest)getReq);
    }

    protected HttpResponse doPut() throws IOException, NoSuchAlgorithmException, KeyStoreException {
        HttpPut putReq = new HttpPut(this.getAddress());
        putReq.setHeader("Authorization: Bearer", this.createCreds());
        putReq.setHeader("Content-Type", "application/json; charset=UTF-8");
        return this.doRequest((HttpUriRequest)putReq);
    }

    protected HttpResponse doPost() throws IOException, NoSuchAlgorithmException, KeyStoreException {
        HttpPost postReq = new HttpPost(this.getAddress());
        postReq.setHeader("Authorization: Bearer", this.createCreds());
        postReq.setHeader("Content-Type", "application/json; charset=UTF-8");
        return this.doRequest((HttpUriRequest)postReq);
    }

    protected HttpClient newClient() throws IOException, NoSuchAlgorithmException, KeyStoreException {
        HttpClient client = this.vcf.getClient(this.getAddress());
        return client;
    }
}

