/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.util.JSONPreprocessorTest;
import edu.uiuc.ncsa.security.util.json.JSONEntry;
import edu.uiuc.ncsa.security.util.json.JSONStore;
import edu.uiuc.ncsa.security.util.json.PreProcessor;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.junit.Test;
import org.oa4mp.delegation.server.server.config.LDAPConfiguration;

public class OA2JSONPreprocessorTest
extends JSONPreprocessorTest {
    public Identifier ID_PRE_PROCESSOR = BasicIdentifier.newID((String)"id:pre");
    public String ID_POST_PROCESSOR = "id:post";
    public String preproc = "{\"preProcessing\": {\n            \"script\": [\n              \"# Set some variables to keep the verbosity down. These are mostly the IDPs.\",\n              \"# Note that this must run only before the first LDAP query.\",\n              \"setEnv('vi','voPersonExternalID');\",\n              \"setEnv('github','http://github.com/login/oauth/authorize');\",\n              \"setEnv('google','http://google.com/accounts/o8/id');\",\n              \"setEnv('orcid','http://orcid.org/oauth/authorize');\",\n              \"setEnv('ncsa','https://idp.ncsa.illinois.edu/idp/shibboleth');\",\n              \"#  Now figure out which IDP was used and set voPersonExternalID so it may be searched for.\",\n              \"xor{\",\n              \"    if[equals(get('idp'),'${github}')]then[set('${vi}',concat(get('oidc'),'@github.com'))],\",\n              \"    if[equals(get('idp'),'${google}')]then[set('${vi}',concat(get('oidc'),'@accounts.google.com'))],\",\n              \"    if[equals(get('idp'),'${orcid}')]then[set('${vi}',replace(get('oidc'),'http://','https://'))],\",\n              \"    if[hasClaim('eppn')]then[set('${vi}',get('eppn'))],\",\n              \"    if[hasClaim('eptid')]then[set('${vi}',get('eptid'))]\",\n              \"};\"\n            ],\n            \"version\": \"1.0\"\n          }\n       }";
    String rawLDAP = "{\"ldap\": {  \"address\": \"ldap.ncsa.illinois.edu\",\n  \"port\": 636,\n  \"" + PreProcessor.IMPORT_DIRECTIVE + "\":\"" + this.ID_PRE_PROCESSOR.toString() + "\"\n}}";

    protected void populateStore(JSONStore store) {
        super.populateStore(store);
        JSONObject prep = JSONObject.fromObject((Object)this.preproc);
        JSONEntry jsonEntry = new JSONEntry(this.ID_PRE_PROCESSOR);
        jsonEntry.setRawContent(prep.toString());
        jsonEntry.setType("JSONObject");
        store.put((Object)this.ID_PRE_PROCESSOR, (Object)jsonEntry);
    }

    @Test
    public void testCreateScript() throws Exception {
        String[] tail;
        String[] head;
        JSONArray caput = new JSONArray();
        for (String x : head = new String[]{"setEnv('vi','voPersonExternalID');\n", "setEnv('github','http://github.com/login/oauth/authorize');\n", "setEnv('google','http://google.com/accounts/o8/id');\n", "setEnv('orcid','http://orcid.org/oauth/authorize');\n", "# Here is a comment"}) {
            caput.add((Object)x);
        }
        JSONArray cauda = new JSONArray();
        for (String y : tail = new String[]{"if[\n", "    endsWith(getEnv('orcid'),'ize')\n", "   ]then[\n", "     echo('got one')\n", "   ]else[\n", "     echo('newp')\n", "];"}) {
            cauda.add((Object)y);
        }
    }

    @Test
    public void testOtherLDAP() throws Exception {
        LDAPConfiguration cfg = new LDAPConfiguration();
        cfg.setPort(636);
        cfg.setServer("https://foo.bar");
        JSONObject json = cfg.toJSON();
        System.out.println(json.toString(2));
    }

    @Test
    public void testLDAP() throws Exception {
        PreProcessor pp = this.createPP();
        System.out.println(this.rawLDAP);
        JSONObject ldap = JSONObject.fromObject((Object)this.rawLDAP);
        JSONObject post = (JSONObject)pp.execute(ldap);
        System.out.println(post.toString(2));
    }
}

