/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.util.TestBase;
import java.util.List;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.admin.adminClient.AdminClientStore;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionsStore;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.test.TestStoreProvider2;
import org.oa4mp.server.test.TestUtils;

public class PermissionTest
extends TestBase {
    public void testFS() throws Exception {
        this.doTestAll((TestStoreProvider2)TestUtils.getFsStoreProvider());
    }

    public void testMYSQL() throws Exception {
        this.doTestAll((TestStoreProvider2)TestUtils.getMySQLStoreProvider());
    }

    public void testMemStore() throws Exception {
        this.doTestAll((TestStoreProvider2)TestUtils.getMemoryStoreProvider());
    }

    public void testPG() throws Exception {
        this.doTestAll((TestStoreProvider2)TestUtils.getPgStoreProvider());
    }

    public void testDerby() throws Exception {
        this.doTestAll((TestStoreProvider2)TestUtils.getDerbyStoreProvider());
    }

    protected void doTestAll(TestStoreProvider2 tp2) throws Exception {
        this.testPermission(tp2.getPermissionStore(), tp2.getClientStore(), tp2.getAdminClientStore());
        this.testAttributes(tp2.getPermissionStore(), tp2.getClientStore(), tp2.getAdminClientStore());
        this.testIDs(tp2.getPermissionStore(), tp2.getClientStore(), tp2.getAdminClientStore());
    }

    public void testPermission(PermissionsStore pStore, ClientStore clientStore, AdminClientStore acStore) throws Exception {
        AdminClient ac = (AdminClient)acStore.create();
        OA2Client c = (OA2Client)clientStore.create();
        Permission p = (Permission)pStore.create();
        p.setAdminID(ac.getIdentifier());
        p.setClientID(c.getIdentifier());
        pStore.save((Identifiable)p);
        assert (pStore.hasEntry(ac.getIdentifier(), c.getIdentifier()));
        List adminIds = pStore.getAdmins(c.getIdentifier());
        assert (adminIds.contains(ac.getIdentifier()));
        List clientIDs = pStore.getClients(ac.getIdentifier());
        assert (clientIDs.contains(c.getIdentifier()));
        pStore.save((Identifiable)p);
        pStore.save((Identifiable)p);
        assert (pStore.getAdmins(c.getIdentifier()).size() == 1);
        assert (pStore.getClients(ac.getIdentifier()).size() == 1);
        OA2Client c1 = (OA2Client)clientStore.create();
        Permission p1 = (Permission)pStore.create();
        p1.setApprove(false);
        p1.setAdminID(ac.getIdentifier());
        p1.setClientID(c1.getIdentifier());
        pStore.save((Identifiable)p1);
        assert (pStore.getAdmins(c1.getIdentifier()).size() == 1);
        assert (pStore.getClients(ac.getIdentifier()).size() == 2);
    }

    public void testAttributes(PermissionsStore pStore, ClientStore clientStore, AdminClientStore acStore) throws Exception {
        AdminClient ac = (AdminClient)acStore.create();
        OA2Client c = (OA2Client)clientStore.create();
        Permission p = (Permission)pStore.create();
        p.setAdminID(ac.getIdentifier());
        p.setClientID(c.getIdentifier());
        p.setApprove(false);
        pStore.save((Identifiable)p);
        Permission p2 = (Permission)pStore.get((Object)p.getIdentifier());
        assert (p2.equals((Object)p));
        p.setCreate(false);
        pStore.save((Identifiable)p);
        p2 = (Permission)pStore.get((Object)p.getIdentifier());
        assert (p2.equals((Object)p));
        p.setRead(false);
        pStore.save((Identifiable)p);
        p2 = (Permission)pStore.get((Object)p.getIdentifier());
        assert (p2.equals((Object)p));
        p.setDelete(false);
        pStore.save((Identifiable)p);
        p2 = (Permission)pStore.get((Object)p.getIdentifier());
        assert (p2.equals((Object)p));
        p.setDelete(false);
        pStore.save((Identifiable)p);
        p2 = (Permission)pStore.get((Object)p.getIdentifier());
        assert (p2.equals((Object)p));
    }

    public void testIDs(PermissionsStore pStore, ClientStore clientStore, AdminClientStore acStore) throws Exception {
        AdminClient ac = (AdminClient)acStore.create();
        AdminClient ac2 = (AdminClient)acStore.create();
        OA2Client c = (OA2Client)clientStore.create();
        Permission p = (Permission)pStore.create();
        p.setAdminID(ac.getIdentifier());
        p.setClientID(c.getIdentifier());
        pStore.save((Identifiable)p);
        p.setAdminID(ac2.getIdentifier());
        System.out.println(p);
        pStore.save((Identifiable)p);
        Permission p2 = (Permission)pStore.get((Object)p.getIdentifier());
        assert (p2.getAdminID().equals(ac2.getIdentifier()));
        assert (pStore.hasEntry(ac2.getIdentifier(), c.getIdentifier()));
        assert (!pStore.hasEntry(ac.getIdentifier(), c.getIdentifier()));
    }
}

