/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import java.util.List;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.loader.OA2ConfigurationLoader;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.qdl.scripting.OA2State;
import org.oa4mp.server.test.QDLTestUtils;
import org.oa4mp.server.test.TestUtils;
import org.qdl_lang.AbstractQDLTester;
import org.qdl_lang.exceptions.QDLExceptionWithTrace;
import org.qdl_lang.parsing.QDLInterpreter;
import org.qdl_lang.state.State;

public class QDLTests
extends AbstractQDLTester {
    String a = "  <tx_record id=\"https://test.cilogon.org/oauth2/4d0034722ec53ee4da7825b9b89ddb57?type=accessToken&amp;ts=1646856623934&amp;version=v2.0&amp;lifetime=10800000\" expires_at=\"1646856623934\" lifetime=\"0\" issue_at=\"1646856623934\" is_valid=\"false\" token_type=\"urn:ietf:params:oauth:token-type:access_token\" parent_id=\"https://test.cilogon.org/oauth2/7b8e151e4c6d0f371bd90def043cefbc?type=authzGrant&amp;ts=1646855546449&amp;version=v2.0&amp;lifetime=900000\">\n    <scopes>      <stem>        <entry key=\"0\">\n          <string><![CDATA[profile]]></string>\\n            \n          n        </entry>\n        <entry key=\"1\"><string><![CDATA[email]]>        </string></entry><entry key=\"2\">\n          <string>\n            <![CDATA[org.cilogon.userinfo]]>\n          </string>\n        </entry>\n        <entry key=\"3\">\n          <string>\n            <![CDATA[wlcg.capabilityset:/dunepilot]]>\n          </string>\n        </entry>\n        <entry key=\"4\">\n          <string>\n            <![CDATA[wlcg.groups:/dune]]>\n          </string>\n        </entry>\n        <entry key=\"5\">\n          <string>\n            <![CDATA[wlcg.groups:/dune/pilot]]>\n          </string>\n        </entry>\n        <entry key=\"6\">\n          <string>\n            <![CDATA[openid]]>\n          </string>\n        </entry>\n        <entry key=\"7\">\n          <string>\n            <![CDATA[offline_access]]>\n          </string>\n        </entry>\n      </stem>\n    </scopes>\n  </tx_record>";

    protected org.qdl_lang.TestUtils getTestUtils() {
        QDLTestUtils.set_instance((org.qdl_lang.TestUtils)new QDLTestUtils());
        return QDLTestUtils.newInstance();
    }

    public void testInGroup2() throws Throwable {
        OA2State state = (OA2State)this.getTestUtils().getNewState();
        StringBuffer script = new StringBuffer();
        this.addLine(script, "module_load('org.oa4mp.server.loader.qdl.OA2QDLLoader', 'java');");
        this.addLine(script, "module_import('oa4mp:/qdl/oidc/claims');");
        this.addLine(script, "groups. := [{'name':'test0','id':123}, {'name':'test1','id':234}, {'name':'test2','id':345}, {'name':'test3','id':456}];");
        this.addLine(script, "groups2. := ['test0', 'test1', 'test2', 'test3'];");
        this.addLine(script, "groups3. := ['test0', 'test1', 42, 'test3']; // should fail");
        this.addLine(script, "groups4. := [{'name':'test0','id':123}, 'test1', 'test2', 'test3']; // should work\n");
        this.addLine(script, "ok1 := reduce(@&&, in_group2(['test0', 'foo'], groups.)==[true,false]);");
        this.addLine(script, "ok2 := reduce(@&&, in_group2(['test0', 'foo', 'test2'], groups2.)==[true,false,true]);");
        this.addLine(script, "ok3 := reduce(@&&, in_group2(['test0', 'foo', 'test2'], groups4.)==[true,false,true]);");
        QDLInterpreter interpreter = new QDLInterpreter(null, (State)state);
        interpreter.execute(script.toString());
        assert (this.getBooleanValue("ok1", (State)state).booleanValue()) : "Basic in_group test for structured group list failed";
        assert (this.getBooleanValue("ok2", (State)state).booleanValue()) : "Basic in_group test for flat list group list failed";
        assert (this.getBooleanValue("ok3", (State)state).booleanValue()) : "Basic in_group test for mixed group list failed";
    }

    public void testInGroup2A() throws Throwable {
        OA2State state = (OA2State)this.getTestUtils().getNewState();
        StringBuffer script = new StringBuffer();
        this.addLine(script, "claims:=j_load('oa4mp.util.claims');");
        this.addLine(script, "groups. := [{'name':'test0','id':123}, {'name':'test1','id':234}, {'name':'test2','id':345}, {'name':'test3','id':456}];");
        this.addLine(script, "groups2. := ['test0', 'test1', 'test2', 'test3'];");
        this.addLine(script, "groups3. := ['test0', 'test1', 42, 'test3']; // should fail");
        this.addLine(script, "groups4. := [{'name':'test0','id':123}, 'test1', 'test2', 'test3']; // should work\n");
        this.addLine(script, "ok1 := reduce(@&&, claims#in_group2(['test0', 'foo'], groups.)==[true,false]);");
        this.addLine(script, "ok2 := reduce(@&&, claims#in_group2(['test0', 'foo', 'test2'], groups2.)==[true,false,true]);");
        this.addLine(script, "ok3 := reduce(@&&, claims#in_group2(['test0', 'foo', 'test2'], groups4.)==[true,false,true]);");
        QDLInterpreter interpreter = new QDLInterpreter(null, (State)state);
        interpreter.execute(script.toString());
        assert (this.getBooleanValue("ok1", (State)state).booleanValue()) : "Basic in_group test for structured group list failed";
        assert (this.getBooleanValue("ok2", (State)state).booleanValue()) : "Basic in_group test for flat list group list failed";
        assert (this.getBooleanValue("ok3", (State)state).booleanValue()) : "Basic in_group test for mixed group list failed";
    }

    public void testInGroup2B() throws Throwable {
        OA2State state = (OA2State)this.getTestUtils().getNewState();
        StringBuffer script = new StringBuffer();
        this.addLine(script, "module_load('org.oa4mp.server.loader.qdl.OA2QDLLoader', 'java');");
        this.addLine(script, "module_import('oa4mp:/qdl/oidc/claims');");
        this.addLine(script, "claims:=j_load('oa4mp.util.claims');");
        this.addLine(script, "groups. := [{'name':'test0','id':123}, {'name':'test1','id':234}, {'name':'test2','id':345}, {'name':'test3','id':456}];");
        this.addLine(script, "groups2. := ['test0', 'test1', 'test2', 'test3'];");
        this.addLine(script, "groups3. := ['test0', 'test1', 42, 'test3']; // should fail");
        this.addLine(script, "groups4. := [{'name':'test0','id':123}, 'test1', 'test2', 'test3']; // should work\n");
        this.addLine(script, "ok1 := reduce(@&&, claims#in_group2(['test0', 'foo'], groups.)==[true,false]);");
        this.addLine(script, "ok2 := reduce(@&&, claims#in_group2(['test0', 'foo', 'test2'], groups2.)==[true,false,true]);");
        this.addLine(script, "ok3 := reduce(@&&, claims#in_group2(['test0', 'foo', 'test2'], groups4.)==[true,false,true]);");
        QDLInterpreter interpreter = new QDLInterpreter(null, (State)state);
        interpreter.execute(script.toString());
        assert (this.getBooleanValue("ok1", (State)state).booleanValue()) : "Basic in_group test for structured group list failed";
        assert (this.getBooleanValue("ok2", (State)state).booleanValue()) : "Basic in_group test for flat list group list failed";
        assert (this.getBooleanValue("ok3", (State)state).booleanValue()) : "Basic in_group test for mixed group list failed";
    }

    public void testInGroup2FailA() throws Throwable {
        OA2State state = (OA2State)this.getTestUtils().getNewState();
        StringBuffer script = new StringBuffer();
        this.addLine(script, "claims := j_load('oa4mp.util.claims');");
        this.addLine(script, "groups3. := ['test0', 'test1', 42, 'test3']; // should fail");
        this.addLine(script, "claims#in_group2(['test0', 'foo', 'test2'], groups3.);");
        QDLInterpreter interpreter = new QDLInterpreter(null, (State)state);
        boolean good = false;
        try {
            interpreter.execute(script.toString());
        }
        catch (QDLExceptionWithTrace iax) {
            good = iax.getCause() instanceof IllegalArgumentException;
        }
        assert (good) : "Was able to execute in_group2 test against bad list";
    }

    public void testInGroup2Fail() throws Throwable {
        OA2State state = (OA2State)this.getTestUtils().getNewState();
        StringBuffer script = new StringBuffer();
        this.addLine(script, "module_load('org.oa4mp.server.loader.qdl.OA2QDLLoader', 'java');");
        this.addLine(script, "module_import('oa4mp:/qdl/oidc/claims');");
        this.addLine(script, "groups3. := ['test0', 'test1', 42, 'test3']; // should fail");
        this.addLine(script, "in_group2(['test0', 'foo', 'test2'], groups3.);");
        QDLInterpreter interpreter = new QDLInterpreter(null, (State)state);
        boolean good = false;
        try {
            interpreter.execute(script.toString());
        }
        catch (QDLExceptionWithTrace iax) {
            good = iax.getCause() instanceof IllegalArgumentException;
        }
        assert (good) : "Was able to execute in_group2 test against bad list";
    }

    public void testVFSFileClaimSourceA() throws Throwable {
        OA2State state = (OA2State)this.getTestUtils().getNewState();
        StringBuffer script = new StringBuffer();
        String realPath = DebugUtil.getDevPath() + "/oa4mp/server-admin/src/main/resources/qdl/ui-test/test-claims.json";
        this.addLine(script, "claims:= j_load('oa4mp.util.claims');");
        this.addLine(script, "cfg. := claims#new_template('file');");
        this.addLine(script, "cfg.file_path := '" + realPath + "';");
        this.addLine(script, "my_claims. := claims#get_claims(claims#create_source(cfg.), 'jgaynor@foo.bar');");
        this.addLine(script, "ok_eppn := my_claims.eppn == 'jgaynor@foo.bar';");
        this.addLine(script, "ok_name := my_claims.isMemberOf.0.name == 'org_ici';");
        this.addLine(script, "ok_id := my_claims.isMemberOf.0.id == 1282;");
        QDLInterpreter interpreter = new QDLInterpreter(null, (State)state);
        interpreter.execute(script.toString());
        assert (this.getBooleanValue("ok_eppn", (State)state).booleanValue()) : "Did not get the correct eppn";
        assert (this.getBooleanValue("ok_name", (State)state).booleanValue()) : "Did not get the correct name from the zeroth group";
        assert (this.getBooleanValue("ok_id", (State)state).booleanValue()) : "Did not get the correct id from the zeroth group";
    }

    public void testVFSFileClaimSource() throws Throwable {
        OA2State state = (OA2State)this.getTestUtils().getNewState();
        StringBuffer script = new StringBuffer();
        String realPath = DebugUtil.getDevPath() + "/oa4mp/server-admin/src/main/resources/qdl/ui-test/test-claims.json";
        this.addLine(script, "module_load('org.oa4mp.server.loader.qdl.OA2QDLLoader', 'java');");
        this.addLine(script, "module_import('oa4mp:/qdl/oidc/claims');");
        this.addLine(script, "cfg. := new_template('file');");
        this.addLine(script, "cfg.file_path := '" + realPath + "';");
        this.addLine(script, "my_claims. := get_claims(create_source(cfg.), 'jgaynor@foo.bar');");
        this.addLine(script, "ok_eppn := my_claims.eppn == 'jgaynor@foo.bar';");
        this.addLine(script, "ok_name := my_claims.isMemberOf.0.name == 'org_ici';");
        this.addLine(script, "ok_id := my_claims.isMemberOf.0.id == 1282;");
        QDLInterpreter interpreter = new QDLInterpreter(null, (State)state);
        interpreter.execute(script.toString());
        assert (this.getBooleanValue("ok_eppn", (State)state).booleanValue()) : "Did not get the correct eppn";
        assert (this.getBooleanValue("ok_name", (State)state).booleanValue()) : "Did not get the correct name from the zeroth group";
        assert (this.getBooleanValue("ok_id", (State)state).booleanValue()) : "Did not get the correct id from the zeroth group";
    }

    public void testFileClaimSourceA() throws Throwable {
        OA2State state = (OA2State)this.getTestUtils().getNewState();
        StringBuffer script = new StringBuffer();
        String testClaimsFile = DebugUtil.getDevPath() + "/oa4mp/server-test/src/main/resources/test-claims.json";
        this.addLine(script, "claims := j_load('oa4mp.util.claims');");
        this.addLine(script, "cfg. := claims#new_template('file');");
        this.addLine(script, "cfg.file_path := '" + testClaimsFile + "';");
        this.addLine(script, "my_claims. := claims#get_claims(claims#create_source(cfg.), 'jgaynor');");
        this.addLine(script, "ok_eppn := my_claims.eppn == 'test-eppn@foo.bar';");
        this.addLine(script, "ok_name := my_claims.isMemberOf.0.name == 'org_ici';");
        this.addLine(script, "ok_id := my_claims.isMemberOf.0.id == 1282;");
        QDLInterpreter interpreter = new QDLInterpreter(null, (State)state);
        interpreter.execute(script.toString());
        assert (this.getBooleanValue("ok_eppn", (State)state).booleanValue()) : "Did not get the correct eppn";
        assert (this.getBooleanValue("ok_name", (State)state).booleanValue()) : "Did not get the correct name from the zeroth group";
        assert (this.getBooleanValue("ok_id", (State)state).booleanValue()) : "Did not get the correct id from the zeroth group";
    }

    public void testTemplateSubstitution() throws Throwable {
        OA2State state = (OA2State)this.getTestUtils().getNewState();
        StringBuffer script = new StringBuffer();
        this.addLine(script, "module_load('org.oa4mp.server.loader.qdl.OA2QDLLoader', 'java');");
        this.addLine(script, "module_import('oa4mp:/qdl/oidc/claims');");
        this.addLine(script, "raw:='storage.read:/bsu/${isMemberOf}/${uid}';");
        this.addLine(script, "claims.uid \u2254 'bob';");
        this.addLine(script, "grps.isMemberOf. \u2254 ['all','dune'];");
        this.addLine(script, "ok \u2254 reduce(@\u2227, ['storage.read:/bsu/all/bob','storage.read:/bsu/dune/bob'] \u2261 template_substitution(raw, claims., grps.));");
        this.addLine(script, "ok1 \u2254 reduce(@\u2227, ['a.b/bob','a.c:/all/bob','a.c:/dune/bob'] \u2261 template_substitution(['a.b/${uid}', 'a.c:/${isMemberOf}/${uid}'], claims., grps.));");
        QDLInterpreter interpreter = new QDLInterpreter(null, (State)state);
        interpreter.execute(script.toString());
        assert (this.getBooleanValue("ok", (State)state).booleanValue()) : "template substitution failed";
        assert (this.getBooleanValue("ok1", (State)state).booleanValue()) : "template substitution failed";
    }

    public void testTemplateSubstitutionA() throws Throwable {
        OA2State state = (OA2State)this.getTestUtils().getNewState();
        StringBuffer script = new StringBuffer();
        this.addLine(script, "claims := j_load('oa4mp.util.claims');");
        this.addLine(script, "raw:='storage.read:/bsu/${isMemberOf}/${uid}';");
        this.addLine(script, "claims.uid \u2254 'bob';");
        this.addLine(script, "grps.isMemberOf. \u2254 ['all','dune'];");
        this.addLine(script, "ok \u2254 reduce(@\u2227, ['storage.read:/bsu/all/bob','storage.read:/bsu/dune/bob'] \u2261 claims#template_substitution(raw, claims., grps.));");
        this.addLine(script, "ok1 \u2254 reduce(@\u2227, ['a.b/bob','a.c:/all/bob','a.c:/dune/bob'] \u2261 claims#template_substitution(['a.b/${uid}', 'a.c:/${isMemberOf}/${uid}'], claims., grps.));");
        QDLInterpreter interpreter = new QDLInterpreter(null, (State)state);
        interpreter.execute(script.toString());
        assert (this.getBooleanValue("ok", (State)state).booleanValue()) : "template substitution failed";
        assert (this.getBooleanValue("ok1", (State)state).booleanValue()) : "template substitution failed";
    }

    public void testResolveTemplates() throws Throwable {
        OA2State state = (OA2State)this.getTestUtils().getNewState();
        StringBuffer script = new StringBuffer();
        this.addLine(script, "module_load('org.oa4mp.server.loader.qdl.OA2QDLLoader', 'java');");
        this.addLine(script, "module_import('oa4mp:/qdl/oidc/claims');");
        this.addLine(script, "cs. :=['x.y:/abc/def','p.q:/rst'];");
        this.addLine(script, "req. := ['x.y:/abc/def/ghi','x.y:/abc/defg', 'p.q:/'];");
        this.addLine(script, "ok_false \u2254 reduce(@\u2227,resolve_templates(cs., req., false) \u2261 ['x.y:/abc/def/ghi']);");
        this.addLine(script, "ok_true \u2254 reduce(@\u2227,resolve_templates(cs., req., true) \u2261 ['p.q:/rst','x.y:/abc/def/ghi']);");
        QDLInterpreter interpreter = new QDLInterpreter(null, (State)state);
        interpreter.execute(script.toString());
        assert (this.getBooleanValue("ok_false", (State)state).booleanValue()) : "resolve template failed for non-query";
        assert (this.getBooleanValue("ok_true", (State)state).booleanValue()) : "resolve template failed for query";
    }

    public void testResolveTemplatesA() throws Throwable {
        OA2State state = (OA2State)this.getTestUtils().getNewState();
        StringBuffer script = new StringBuffer();
        this.addLine(script, "claims := j_load('oa4mp.util.claims');");
        this.addLine(script, "cs. :=['x.y:/abc/def','p.q:/rst'];");
        this.addLine(script, "req. := ['x.y:/abc/def/ghi','x.y:/abc/defg', 'p.q:/'];");
        this.addLine(script, "ok_false \u2254 reduce(@\u2227,claims#resolve_templates(cs., req., false) \u2261 ['x.y:/abc/def/ghi']);");
        this.addLine(script, "ok_true \u2254 reduce(@\u2227,claims#resolve_templates(cs., req., true) \u2261 ['p.q:/rst','x.y:/abc/def/ghi']);");
        QDLInterpreter interpreter = new QDLInterpreter(null, (State)state);
        interpreter.execute(script.toString());
        assert (this.getBooleanValue("ok_false", (State)state).booleanValue()) : "resolve template failed for non-query";
        assert (this.getBooleanValue("ok_true", (State)state).booleanValue()) : "resolve template failed for query";
    }

    public void testResolveTemplates2() throws Throwable {
        OA2State state = (OA2State)this.getTestUtils().getNewState();
        StringBuffer script = new StringBuffer();
        this.addLine(script, "module_load('org.oa4mp.server.loader.qdl.OA2QDLLoader', 'java');");
        this.addLine(script, "module_import('oa4mp:/qdl/oidc/claims');");
        this.addLine(script, "c.:=['insert:/DQSegDB',\n                 'read:/frames',\n                 'read:/GraceDB',\n                 'compute.create',\n                 'compute.create2'\n                 ];");
        this.addLine(script, "    r.:=['openid',\n        'profile',\n        'email',\n        'org.cilogon.userinfo',\n        'read:/DQSegDB',\n        'write:/DQSegDB',\n        'query:/DQSegDB',\n        'insert:/DQSegDB',\n        'read:/frames',\n        'read:/GraceDB',\n        'compute.create',\n        'compute.cancel',\n        'compute.read',\n        'compute.modify'\n       ];");
        this.addLine(script, "out. := ['read:/frames','compute.create','read:/GraceDB','insert:/DQSegDB'];");
        this.addLine(script, "resolved.:= resolve_templates(c., r., false);");
        this.addLine(script, "size_resolved := size(resolved.);");
        this.addLine(script, "size_out := size(out.);");
        this.addLine(script, "size_ok := size_resolved \u2261 size_out;");
        this.addLine(script, "ok \u2254 reduce(@\u2227,out.\u2208 resolved.);");
        QDLInterpreter interpreter = new QDLInterpreter(null, (State)state);
        interpreter.execute(script.toString());
        assert (this.getBooleanValue("size_ok", (State)state).booleanValue()) : "expect  " + this.getLongValue("size_out", (State)state) + " but got " + this.getLongValue("size_resolved", (State)state) + " elements";
        assert (this.getBooleanValue("ok", (State)state).booleanValue()) : "incorrect result.";
    }

    public void testResolveTemplates2A() throws Throwable {
        OA2State state = (OA2State)this.getTestUtils().getNewState();
        StringBuffer script = new StringBuffer();
        this.addLine(script, "claims:=j_load('oa4mp.util.claims');");
        this.addLine(script, "c.:=['insert:/DQSegDB',\n                 'read:/frames',\n                 'read:/GraceDB',\n                 'compute.create',\n                 'compute.create2'\n                 ];");
        this.addLine(script, "    r.:=['openid',\n        'profile',\n        'email',\n        'org.cilogon.userinfo',\n        'read:/DQSegDB',\n        'write:/DQSegDB',\n        'query:/DQSegDB',\n        'insert:/DQSegDB',\n        'read:/frames',\n        'read:/GraceDB',\n        'compute.create',\n        'compute.cancel',\n        'compute.read',\n        'compute.modify'\n       ];");
        this.addLine(script, "out. := ['read:/frames','compute.create','read:/GraceDB','insert:/DQSegDB'];");
        this.addLine(script, "resolved.:= claims#resolve_templates(c., r., false);");
        this.addLine(script, "size_resolved := size(resolved.);");
        this.addLine(script, "size_out := size(out.);");
        this.addLine(script, "size_ok := size_resolved \u2261 size_out;");
        this.addLine(script, "ok \u2254 reduce(@\u2227,out.\u2208 resolved.);");
        QDLInterpreter interpreter = new QDLInterpreter(null, (State)state);
        interpreter.execute(script.toString());
        assert (this.getBooleanValue("size_ok", (State)state).booleanValue()) : "expect  " + this.getLongValue("size_out", (State)state) + " but got " + this.getLongValue("size_resolved", (State)state) + " elements";
        assert (this.getBooleanValue("ok", (State)state).booleanValue()) : "incorrect result.";
    }

    protected void setFakeState(OA2State oa2State) {
        OA2ServiceTransaction oa2ServiceTransaction = new OA2ServiceTransaction(BasicIdentifier.randomID());
        OA2Client oa2Client = new OA2Client(BasicIdentifier.randomID());
        OA2ConfigurationLoader loader = new OA2ConfigurationLoader(TestUtils.findConfigNode((String)(DebugUtil.getConfigPath() + "/server-oa2.xml"), (String)"localhost:oa4mp.oa2.mariadb"));
        OA2SE oa2SE = (OA2SE)loader.load();
        oa2State.setOa2se(oa2SE);
        oa2Client.setConfig(new JSONObject());
        oa2ServiceTransaction.setClient((Client)oa2Client);
        oa2State.setTransaction(oa2ServiceTransaction);
    }

    void checkLists(List list1, List list2) {
        for (int i = 0; i < list1.size(); ++i) {
            assert (list2.contains(list1.get(i)));
        }
    }
}

