/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.util.TestBase;
import java.util.Date;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.RefreshToken;
import org.oa4mp.delegation.common.token.impl.AuthorizationGrantImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;
import org.oa4mp.delegation.server.OA2TokenForge;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.loader.oauth2.storage.RefreshTokenStore;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.test.TestUtils;

public class RefreshTokenStoreTest
extends TestBase {
    public long EXPIRES_IN = 10000L;

    public void testFS() throws Exception {
        this.testRT(TestUtils.getFsStoreProvider().getTransactionStore(), TestUtils.getFsStoreProvider().getClientStore());
    }

    public void testMYSQL() throws Exception {
        this.testRT(TestUtils.getMySQLStoreProvider().getTransactionStore(), TestUtils.getMySQLStoreProvider().getClientStore());
    }

    public void testMemStore() throws Exception {
        this.testRT(TestUtils.getMemoryStoreProvider().getTransactionStore(), TestUtils.getMemoryStoreProvider().getClientStore());
    }

    public void testPG() throws Exception {
        this.testRT(TestUtils.getPgStoreProvider().getTransactionStore(), TestUtils.getPgStoreProvider().getClientStore());
    }

    public void testDerby() throws Exception {
        this.testRT(TestUtils.getDerbyStoreProvider().getTransactionStore(), TestUtils.getDerbyStoreProvider().getClientStore());
    }

    public void testRT(TransactionStore tStore, ClientStore clientStore) throws Exception {
        if (!(tStore instanceof RefreshTokenStore)) {
            throw new IllegalStateException(" The store " + tStore.getClass().getSimpleName() + " is not of a type RefreshTokenStore");
        }
        RefreshTokenStore rts = (RefreshTokenStore)tStore;
        OA2ServiceTransaction st2 = (OA2ServiceTransaction)tStore.create();
        OA2TokenForge tf2 = new OA2TokenForge("http://localhost/test/" + RefreshTokenStoreTest.getRandomString() + "/");
        RefreshTokenImpl rt = tf2.getRefreshToken(new String[0]);
        st2.setRefreshToken((RefreshToken)rt);
        AuthorizationGrantImpl ag = TokenFactory.createAG((String)st2.getIdentifierString());
        OA2Client client = new OA2Client(BasicIdentifier.randomID());
        clientStore.save((Identifiable)client);
        st2.setClient((Client)client);
        st2.setAuthorizationGrant((AuthorizationGrant)ag);
        st2.setRefreshTokenLifetime(this.EXPIRES_IN);
        st2.setAuthTime(new Date());
        tStore.save((Identifiable)st2);
        OA2ServiceTransaction testST = rts.get((RefreshToken)rt);
        assert (testST.equals((Object)st2)) : " created transaction is not fetched faithfully from the store";
        rt = tf2.getRefreshToken(new String[0]);
        st2.setRefreshToken((RefreshToken)rt);
        st2.setRefreshTokenValid(false);
        tStore.save((Identifiable)st2);
        assert (rts.get((RefreshToken)rt).equals((Object)st2)) : " updating refresh token fails.";
        tStore.remove((Object)st2.getIdentifier());
        clientStore.remove((Object)client.getIdentifier());
    }
}

