/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

class TestAD {
    static DirContext ldapContext;

    TestAD() {
    }

    public static void main(String[] args) throws NamingException {
        try {
            System.out.println("D\u00e9but du test Active Directory");
            Hashtable<String, String> ldapEnv = new Hashtable<String, String>(11);
            ldapEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            ldapEnv.put("java.naming.provider.url", "ldap://ldap.ad.uillinois.edu:389");
            ldapEnv.put("java.naming.security.authentication", "simple");
            ldapEnv.put("java.naming.security.principal", "gaynor");
            ldapEnv.put("java.naming.security.credentials", "pwd");
            ldapContext = new InitialDirContext(ldapEnv);
            Attributes attrs = ldapContext.getAttributes("cn=gaynor, ou=People", new String[]{"cn"});
            Attribute cnAttr = attrs.get("cn");
            DirContext cnSchema = cnAttr.getAttributeDefinition();
            Attributes cnAttrs = cnSchema.getAttributes("");
            SearchControls searchCtls = new SearchControls();
            String[] returnedAtts = new String[]{"sn", "givenName", "samAccountName"};
            searchCtls.setReturningAttributes(returnedAtts);
            searchCtls.setSearchScope(2);
            String searchFilter = "(&(objectClass=user))";
            String searchBase = "dc=dom,dc=fr";
            int totalResults = 0;
            NamingEnumeration<SearchResult> answer = ldapContext.search(searchBase, searchFilter, searchCtls);
            while (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                ++totalResults;
                System.out.println(">>>" + sr.getName());
                attrs = sr.getAttributes();
                System.out.println(">>>>>>" + String.valueOf(attrs.get("samAccountName")));
            }
            System.out.println("Total results: " + totalResults);
            ldapContext.close();
        }
        catch (Exception e) {
            System.out.println(" Search error: " + String.valueOf(e));
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

