/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import edu.uiuc.ncsa.security.storage.sql.derby.DerbyConnectionPool;
import org.oa4mp.delegation.common.storage.clients.ClientConverter;
import org.oa4mp.server.api.ServiceEnvironment;
import org.oa4mp.server.api.admin.adminClient.AdminClientConverter;
import org.oa4mp.server.api.admin.adminClient.AdminClientStoreProviders;
import org.oa4mp.server.api.admin.things.SATFactory;
import org.oa4mp.server.api.storage.servlet.AbstractBootstrapper;
import org.oa4mp.server.loader.oauth2.loader.OA2ConfigurationLoader;
import org.oa4mp.server.test.AbstractTestSuiteInitializer;
import org.oa4mp.server.test.QDLTestUtils;
import org.oa4mp.server.test.TestStoreProvider2;
import org.oa4mp.server.test.TestStoreProviderInterface;
import org.oa4mp.server.test.TestUtils;

public class TestSuiteInitializer
extends AbstractTestSuiteInitializer {
    public TestSuiteInitializer(AbstractBootstrapper bootstrapper) {
        super(bootstrapper);
    }

    public TestStoreProvider2 getTSP(final String namedNode) {
        return new TestStoreProvider2(){
            OA2ConfigurationLoader loader;

            public ConfigurationLoader<? extends ServiceEnvironment> getConfigLoader() {
                if (this.loader == null) {
                    this.loader = new OA2ConfigurationLoader(TestUtils.findConfigNode((String)namedNode));
                }
                return this.loader;
            }
        };
    }

    public String getAggregateStoreConfigName() {
        return this.getFileStoreConfigName();
    }

    public String getFileStoreConfigName() {
        return "oa4mp.oa2.derby.filestore";
    }

    public String getOLDFileStoreConfigName() {
        return "oa4mp.oa2.fileStore";
    }

    public String getMemoryStoreConfigName() {
        return "oa4mp.oa2.derby.memory";
    }

    public String getExplicitMemoryStoreConfigName() {
        return "oa4mp.oa2.derby.memory";
    }

    public String getMySQLStoreConfigName() {
        return "oa4mp.oa2.mysql";
    }

    public String getPostgresStoreConfigName() {
        return "oa4mp.oa2.postgres";
    }

    public String getDerbyStoreConfigName() {
        return "oa4mp.oa2.derby";
    }

    protected TestStoreProviderInterface checkDerby(TestStoreProviderInterface tspi) {
        try {
            DerbyConnectionPool dcp;
            if (tspi.getClientStore() instanceof SQLStore && ((SQLStore)tspi.getClientStore()).getConnectionPool() instanceof DerbyConnectionPool && ((dcp = (DerbyConnectionPool)((SQLStore)tspi.getClientStore()).getConnectionPool()).isMemoryStore() || dcp.isFileStore())) {
                System.out.println("TEST, starting Derby store create for " + dcp.getConnectionParameters().getRootDirectory());
                dcp.createStore();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new GeneralException("could not get client store:" + x.getMessage());
        }
        return tspi;
    }

    public void init() {
        TestUtils.setBootstrapper((AbstractBootstrapper)this.getBootstrapper());
        TestStoreProvider2 tspi = this.getTSP(this.getExplicitMemoryStoreConfigName());
        TestUtils.setMemoryStoreProvider((TestStoreProviderInterface)this.checkDerby((TestStoreProviderInterface)tspi));
        TestStoreProvider2 fsp = this.getTSP(this.getFileStoreConfigName());
        TestUtils.setFsStoreProvider((TestStoreProviderInterface)this.checkDerby((TestStoreProviderInterface)fsp));
        TestUtils.setOLDfsStoreProvider((TestStoreProviderInterface)this.getTSP(this.getOLDFileStoreConfigName()));
        TestUtils.setMySQLStoreProvider((TestStoreProviderInterface)this.getTSP(this.getMySQLStoreConfigName()));
        TestUtils.setPgStoreProvider((TestStoreProviderInterface)this.getTSP(this.getPostgresStoreConfigName()));
        TestUtils.setDerbyStoreProvider((TestStoreProviderInterface)this.getTSP(this.getDerbyStoreConfigName()));
        try {
            SATFactory.setAdminClientConverter((AdminClientConverter)AdminClientStoreProviders.getAdminClientConverter());
            SATFactory.setClientConverter((ClientConverter)((ClientConverter)fsp.getClientStore().getMapConverter()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        org.qdl_lang.TestUtils.set_instance((org.qdl_lang.TestUtils)new QDLTestUtils());
    }
}

