/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.util.crypto.MyPKCS10CertRequest;
import edu.uiuc.ncsa.security.util.pkcs.MyCertUtil;
import java.net.URI;
import java.util.List;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.storage.transactions.BasicTransaction;
import org.oa4mp.delegation.common.token.AuthorizationGrant;

public class ServiceTransaction
extends BasicTransaction {
    public String PROMPT_KEY = "prompt";
    public String ID_TOKEN_HINT_KEY = "id_token_hint";
    public String STATE_KEY = "state";
    public String STATE_COMMENT_KEY = "comment";
    JSONObject state;
    public boolean authGrantValid;
    public boolean accessTokenValid;
    URI callback;
    Client client;
    long lifetime = 0L;
    String username;
    String certReqString;
    transient MyPKCS10CertRequest certReq;

    public boolean hasPromptKey() {
        return this.getState().containsKey((Object)this.PROMPT_KEY);
    }

    public String getPrompt() {
        return this.getState().getString(this.PROMPT_KEY);
    }

    public void setPrompt(String prompt) {
        this.getState().put((Object)this.PROMPT_KEY, (Object)prompt);
    }

    public boolean hasIDTokenHintKey() {
        return this.getState().containsKey((Object)this.ID_TOKEN_HINT_KEY);
    }

    public JSONObject getIDTokenHint() {
        return this.getState().getJSONObject(this.ID_TOKEN_HINT_KEY);
    }

    public void setIDTokenHint(JSONObject idTokenHint) {
        this.getState().put((Object)this.ID_TOKEN_HINT_KEY, (Object)idTokenHint);
    }

    public void setState(JSONObject state) {
        this.state = state;
    }

    public JSONObject getState() {
        if (this.state == null) {
            this.state = new JSONObject();
            this.state.put((Object)this.STATE_COMMENT_KEY, (Object)("State for object id \"" + this.getAuthorizationGrant().getToken() + "\""));
        }
        return this.state;
    }

    public ServiceTransaction(Identifier identifier) {
        super(identifier);
    }

    public ServiceTransaction(AuthorizationGrant ag) {
        super(ag);
    }

    public boolean isAuthGrantValid() {
        return this.authGrantValid;
    }

    public void setAuthGrantValid(boolean authGrantValid) {
        this.authGrantValid = authGrantValid;
    }

    public boolean isAccessTokenValid() {
        return this.accessTokenValid;
    }

    public void setAccessTokenValid(boolean accessTokenValid) {
        this.accessTokenValid = accessTokenValid;
    }

    public URI getCallback() {
        return this.callback;
    }

    public void setCallback(URI callback) {
        this.callback = callback;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public MyPKCS10CertRequest getCertReq() {
        if (this.certReq != null) {
            return this.certReq;
        }
        if (this.certReqString == null) {
            return null;
        }
        return MyCertUtil.fromStringToCertReq((String)this.getCertReqString());
    }

    public void setCertReqString(String certReqString) {
        if (certReqString == null && this.certReq != null) {
            certReqString = MyCertUtil.fromCertReqToString((MyPKCS10CertRequest)this.certReq);
        }
        this.certReqString = certReqString;
    }

    public String getCertReqString() {
        return this.certReqString;
    }

    public void setCertReq(String certReq) {
        this.certReqString = certReq;
    }

    public void setCertReq(MyPKCS10CertRequest certReq) {
        this.certReq = certReq;
        this.certReqString = MyCertUtil.fromCertReqToString((MyPKCS10CertRequest)certReq);
    }

    protected String formatToString() {
        String out = "id=" + this.getIdentifierString() + ", authGrant=" + String.valueOf(this.getAuthorizationGrant()) + "(" + (this.isAuthGrantValid() ? "" : "in") + "valid)";
        out = out + ", access token=" + String.valueOf(this.getAccessToken()) + "(" + (this.isAccessTokenValid() ? "" : "in") + "valid)";
        out = out + ", lifetime=" + this.getLifetime();
        return out;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.formatToString() + "]";
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ServiceTransaction)) {
            return false;
        }
        ServiceTransaction st = (ServiceTransaction)((Object)obj);
        if (this.isAuthGrantValid() != st.isAuthGrantValid()) {
            return false;
        }
        if (this.isAccessTokenValid() != st.isAccessTokenValid()) {
            return false;
        }
        return this.getLifetime() == st.getLifetime();
    }

    public List<String> getResponseTypes() {
        return null;
    }
}

