/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.storage;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.monitored.MonitoredSQLStore;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionRecord;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.BaseClientKeys;
import org.oa4mp.delegation.common.storage.clients.ClientApprovalKeys;
import org.oa4mp.delegation.server.storage.BaseClientStore;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;

public abstract class BaseClientSQLStore<V extends BaseClient>
extends MonitoredSQLStore<V>
implements BaseClientStore<V> {
    public BaseClientSQLStore(ConnectionPool connectionPool, Table table, Provider<V> idp, MapConverter converter) {
        super(connectionPool, table, idp, converter);
    }

    @Override
    public List<Identifier> getByStatus(String status, ClientApprovalStore clientApprovalStore) {
        SQLStore caStore = (SQLStore)clientApprovalStore;
        ClientApprovalKeys caKeys = (ClientApprovalKeys)caStore.getMapConverter().getKeys();
        return this.getByField(caKeys.status(new String[0]), status, clientApprovalStore);
    }

    @Override
    public List<Identifier> getByApprover(String approver, ClientApprovalStore clientApprovalStore) {
        SQLStore caStore = (SQLStore)clientApprovalStore;
        ClientApprovalKeys caKeys = (ClientApprovalKeys)caStore.getMapConverter().getKeys();
        return this.getByField(caKeys.approver(new String[0]), approver, clientApprovalStore);
    }

    public List<Identifier> getByField(String fieldName, String field, ClientApprovalStore clientApprovalStore) {
        ArrayList<Identifier> ids = new ArrayList<Identifier>();
        if (!(clientApprovalStore instanceof SQLStore)) {
            throw new IllegalStateException("Cannot perform this against a non-SQL store. ");
        }
        SQLStore caStore = (SQLStore)clientApprovalStore;
        ClientApprovalKeys caKeys = (ClientApprovalKeys)caStore.getMapConverter().getKeys();
        BaseClientKeys baseClientKeys = (BaseClientKeys)this.getMapConverter().getKeys();
        String clientID = baseClientKeys.identifier(new String[0]);
        String approvalID = caKeys.identifier(new String[0]);
        String clientTableName = this.getTable().getFQTablename();
        String approvalTableName = caStore.getTable().getFQTablename();
        String query = "select p." + clientID + ", p." + baseClientKeys.creationTS(new String[0]) + " from " + clientTableName + " as p left join " + approvalTableName + " as s on p." + clientID + " = s." + approvalID + " where s." + fieldName + " = ? ORDER BY p." + baseClientKeys.creationTS(new String[0]) + " DESC";
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        Object t = null;
        try {
            PreparedStatement stmt = c.prepareStatement(query);
            stmt.setString(1, field);
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                ids.add((Identifier)new BasicIdentifier(rs.getString(clientID)));
            }
            rs.close();
            stmt.close();
            this.releaseConnection(cr);
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            if (DebugUtil.isEnabled()) {
                e.printStackTrace();
            }
            throw new GeneralException("Error getting approvals for status \"" + field + "\"", (Throwable)e);
        }
        return ids;
    }

    public String getCreationTSField() {
        BaseClientKeys keys = (BaseClientKeys)this.getMapConverter().getKeys();
        return keys.creationTS(new String[0]);
    }

    protected BaseClientKeys getKeys() {
        return (BaseClientKeys)this.getMapConverter().getKeys();
    }
}

