/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.storage;

import edu.uiuc.ncsa.security.core.DateComparable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.IdentifiableImpl;
import edu.uiuc.ncsa.security.core.util.StatusValue;
import java.util.Date;

public class ClientApproval
extends IdentifiableImpl
implements DateComparable {
    static final long serialVersionUID = 1714880068599897702L;
    boolean approved;
    String approver;
    Date approvalTimestamp;
    Status status = Status.NONE;

    public ClientApproval(Identifier identifier) {
        super(identifier);
    }

    public Date getCreationTS() {
        return this.getApprovalTimestamp();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Date getApprovalTimestamp() {
        return this.approvalTimestamp;
    }

    public void setApprovalTimestamp(Date approvalTimestamp) {
        this.approvalTimestamp = approvalTimestamp;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public void setApproved(boolean approved) {
        boolean oldValue = approved;
        this.approved = approved;
        if (approved) {
            this.setStatus(Status.APPROVED);
        } else if (oldValue) {
            this.setStatus(Status.REVOKED);
        }
    }

    public String getApprover() {
        return this.approver;
    }

    public void setApprover(String approver) {
        this.approver = approver;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ClientApproval)) {
            return false;
        }
        ClientApproval ca = (ClientApproval)((Object)obj);
        if (!this.getIdentifierString().equals(ca.getIdentifierString())) {
            return false;
        }
        if (this.isApproved() != ca.isApproved()) {
            return false;
        }
        if (this.getApprover() == null && ca.getApprover() == null) {
            return true;
        }
        if (this.getApprover() != null && ca.getApprover() == null) {
            return false;
        }
        if (this.getApprover() == null && ca.getApprover() != null) {
            return false;
        }
        return this.getApprover().equals(ca.getApprover());
    }

    public IdentifiableImpl clone() {
        ClientApproval ca = new ClientApproval(this.getIdentifier());
        ca.setApprover(this.getApprover());
        ca.setStatus(this.getStatus());
        ca.setApprovalTimestamp(this.getApprovalTimestamp());
        ca.setApproved(this.isApproved());
        return ca;
    }

    public String toString() {
        String x = ((Object)((Object)this)).getClass().getSimpleName() + "[approved=" + this.isApproved() + ", status=" + String.valueOf((Object)this.status) + ", approver=" + this.getApprover() + ", id=" + this.getIdentifierString() + ", on " + String.valueOf(this.getApprovalTimestamp()) + "]";
        return x;
    }

    public static enum Status implements StatusValue
    {
        NONE("none"),
        DENIED("denied"),
        APPROVED("approved"),
        REVOKED("revoked"),
        TEMPLATE("template"),
        PENDING("pending");

        private final String status;

        private Status(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public static Status resolveByStatusValue(String code) {
            Status[] enumConstants;
            for (Status entry : enumConstants = (Status[])Status.class.getEnumConstants()) {
                if (!entry.getStatus().equals(code)) continue;
                return entry;
            }
            return null;
        }
    }
}

