/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.storage;

import edu.uiuc.ncsa.security.core.exceptions.UninitializedException;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.util.HashMap;
import javax.inject.Provider;
import org.oa4mp.delegation.common.storage.transactions.SQLBaseTransactionStore;
import org.oa4mp.delegation.common.token.TokenForge;
import org.oa4mp.delegation.server.ServiceTransaction;

public abstract class SQLServiceTransactionStore<V extends ServiceTransaction>
extends SQLBaseTransactionStore<V> {
    public static final String DEFAULT_TABLENAME = "transactions";
    HashMap<String, ServiceTransaction> createdTransactions;

    protected SQLServiceTransactionStore(TokenForge tokenForge, ConnectionPool connectionPool, Table table, Provider<V> idp, MapConverter converter) {
        super(tokenForge, connectionPool, table, idp, converter);
    }

    public HashMap<String, ServiceTransaction> getCreatedTransactions() {
        if (this.createdTransactions == null) {
            this.createdTransactions = new HashMap();
        }
        return this.createdTransactions;
    }

    public void register(V t) {
        if (t.getIdentifierString() == null) {
            throw new UninitializedException("Error: There is no identifier for this transaction");
        }
        super.register(t);
        this.getCreatedTransactions().remove(t.getIdentifier());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[table=" + String.valueOf(this.getTable()) + "]";
    }
}

