/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.storage.impl;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.XMLConverter;
import edu.uiuc.ncsa.security.storage.GenericStoreUtils;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.monitored.MonitoredMemoryStore;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.storage.clients.ClientConverter;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.delegation.server.storage.impl.GenericClientStoreUtils;

public class ClientMemoryStore<V extends Client>
extends MonitoredMemoryStore<V>
implements ClientStore<V> {
    public List<V> getMostRecent(int n, List<String> attributes) {
        return GenericStoreUtils.getMostRecent((Store)this, (int)n, attributes);
    }

    public ClientMemoryStore(IdentifiableProvider<V> vIdentifiableProvider) {
        super(vIdentifiableProvider);
    }

    public XMLConverter<V> getXMLConverter() {
        return this.getMapConverter();
    }

    @Override
    public MapConverter<V> getMapConverter() {
        return new ClientConverter(this.identifiableProvider);
    }

    public void save(V value) {
        value.setLastModifiedTS((Date)new Timestamp(new Date().getTime()));
        super.save(value);
    }

    @Override
    public List<Identifier> getByStatus(String status, ClientApprovalStore clientApprovalStore) {
        return GenericClientStoreUtils.getByStatus(this, status, clientApprovalStore);
    }

    @Override
    public List<Identifier> getByApprover(String approver, ClientApprovalStore clientApprovalStore) {
        return GenericClientStoreUtils.getByApprover(this, approver, clientApprovalStore);
    }
}

