/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.storage.impl;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.XMLConverter;
import edu.uiuc.ncsa.security.core.util.IdentifiableProviderImpl;
import edu.uiuc.ncsa.security.storage.FileStore;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.File;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;

public abstract class FSClientApprovalStore<V extends ClientApproval>
extends FileStore<V>
implements ClientApprovalStore<V> {
    protected FSClientApprovalStore(File storeDirectory, File indexDirectory, IdentifiableProviderImpl<V> idp, MapConverter<V> cp, boolean removeEmptyFiles, boolean removeFailedFiles) {
        super(storeDirectory, indexDirectory, idp, cp, removeEmptyFiles, removeFailedFiles);
    }

    protected FSClientApprovalStore(File file, IdentifiableProviderImpl<V> idp, MapConverter<V> cp, boolean removeEmptyFiles, boolean removeFailedFiles) {
        super(new File(file, "cas"), idp, cp, removeEmptyFiles, removeFailedFiles);
    }

    @Override
    public boolean isApproved(Identifier identifier) {
        ClientApproval ca = (ClientApproval)this.get(identifier);
        if (ca == null) {
            return false;
        }
        return ca.isApproved();
    }

    @Override
    public int getUnapprovedCount() {
        int count = 0;
        for (Identifier key : this.keySet()) {
            if (this.isApproved(key)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getPendingCount() {
        int count = 0;
        for (Identifier key : this.keySet()) {
            ClientApproval approval = (ClientApproval)this.get(key);
            if (approval != null && approval.getStatus() != ClientApproval.Status.PENDING) continue;
            ++count;
        }
        return count;
    }

    public XMLConverter<V> getXMLConverter() {
        return this.converter;
    }
}

